/*  This code supports an article in issue #51 of:

    Micro Cornucopia Magazine
    P.O. Box 223
    Bend, OR 97709
*/

#include "zg_lwlvl.h"

#include "stdio.h"
#include "conio.h"

int main(void);

int main(void)
    {
    int x, y, c;

    if (ZG_Init())
        {
        printf("\aError: Could not determine adapter type!\n");
        return 1;
        }

    switch (ZG_VideoInfo.Type)
        {
        case ZG_VID_MDA:
            printf("MDA\n");
            break;
        case ZG_VID_CGA:
            printf("CGA\n");
            break;
        case ZG_VID_HGC:
            printf("HGC\n");
            break;
        case ZG_VID_EGA:
            printf("EGA\n");
            break;
        case ZG_VID_MCGA:
            printf("MCGA\n");
            break;
        case ZG_VID_VGA:
            printf("VGA\n");
            break;
        default :
            printf("\aError: unknown adapter type\n");
            return 1;
        }

    switch (ZG_VideoInfo.Monitor)
        {
        case ZG_MTR_MONO :
            printf("Monochrome monitor\n");
            break;
        case ZG_MTR_COLOR :
            printf("Color Monitor\n");
            break;
        default :
            printf("\aError: unknown monitor type!");
            return 1;
        }

    while (!kbhit) ;
    if (!getch()) getch() ;

    if (ZG_SetMode(ZG_MOD_BESTRES))
        {
        printf("\aError: unable to set BestRes mode\n");
        return 1;
        }

    for (x = 0; x < ZG_VideoInfo.Xwidth; ++x)
        for (y = 0; y < ZG_VideoInfo.Ylength; ++y)
            ZG_PlotPixel(x, y, (x % ZG_VideoInfo.NoColors), ZG_PXL_SET);

    for (x = 0; x < ZG_VideoInfo.Xwidth; ++x)
        for (y = 0; y < ZG_VideoInfo.Ylength; ++y)
            ZG_PlotPixel(x, y, ZG_VideoInfo.NoColors - (x % ZG_VideoInfo.NoColors), ZG_PXL_XOR);

    for (x = 0; x < ZG_VideoInfo.Xwidth; ++x)
        for (y = 0; y < ZG_VideoInfo.Ylength; ++y)
            ZG_PlotPixel(x, y, ZG_VideoInfo.NoColors - (x % ZG_VideoInfo.NoColors), ZG_PXL_XOR);

    while (!kbhit) ;
    if (!getch()) getch() ;

    if (ZG_SetMode(ZG_MOD_MOSTCOLOR))
        {
        printf("\aError: unable to set BestRes mode\n");
        return 1;
        }

    for (x = 0; x < ZG_VideoInfo.Xwidth; ++x)
        for (y = 0; y < ZG_VideoInfo.Ylength; ++y)
            ZG_PlotPixel(x, y, (x % ZG_VideoInfo.NoColors), ZG_PXL_SET);

    for (x = 0; x < ZG_VideoInfo.Xwidth; ++x)
        for (y = 0; y < ZG_VideoInfo.Ylength; ++y)
            ZG_PlotPixel(x, y, ZG_VideoInfo.NoColors - (x % ZG_VideoInfo.NoColors), ZG_PXL_XOR);

    for (x = 0; x < ZG_VideoInfo.Xwidth; ++x)
        for (y = 0; y < ZG_VideoInfo.Ylength; ++y)
            ZG_PlotPixel(x, y, ZG_VideoInfo.NoColors - (x % ZG_VideoInfo.NoColors), ZG_PXL_XOR);

    while (!kbhit) ;
    if (!getch()) getch() ;

    ZG_PlotPixel(10, 10, ZG_VideoInfo.NoColors - 1, ZG_PXL_SET);

    c = ZG_ReadPixel(10, 10);

    ZG_Done();

    if (c == (ZG_VideoInfo.NoColors - 1))
        printf("ReadPixel Worked! Plotted %d, got %d\n",ZG_VideoInfo.NoColors -1, c);
    else
        printf("\aError: ReadPixel failed. plotted %d, got %d\n",ZG_VideoInfo.NoColors -1, c);

    return 0;
    }
