/*  This code supports an article in issue #51 of:

    Micro Cornucopia Magazine
    P.O. Box 223
    Bend, OR 97709
*/

/* VOICE.C : displaying a voice pattern on the screen using the Borland
   BGI graphics functions.
   Bruce Eckel, Revolution2 Real-Time Consulting.
*/

#include <conio.h>  /* kbhit() */
#include <stdlib.h> /* calloc() */
#include "capture.h"
#include "display.h" /* includes graphics.h */

main() {
  int graphdriver = DETECT;  /* will request autodetection */
  struct viewporttype view;
  int i, graphmode, color;
  unsigned int * points;
  /* Initialize graphics.  The string in the third argument tells
     the function where to look for the graphics drivers (you may
     need to change it for your own environment): */
  initgraph(&graphdriver, &graphmode, "c:\\turboc");
  color = getmaxcolor();  /* works with all machines */
  getviewsettings(&view);
/*  display_viewsettings(view);  /* for debugging */
  /* create an array according to the size in pixels of the monitor: */
  points = (unsigned int *)calloc(view.right, sizeof(int));
  MUX(0);  /* select the channel to read */
  while(!kbhit()) {
    capture(points, view.right, 1000, 0);
    for(i = 0; i < view.right; i++)
      points[i] >>= 3; /* do some rough scaling */
    display_series(points, view.right, 20, half, full, color);
    clearviewport();
  }
  closegraph();
}

