/* This code is from TechTips
in Micro Cornucopia Magazine, issue #50

Micro Cornucopia
PO Box 223
Bend, OR 97709
*/


/* STDPRINT.H                                                             */
/*                                                                        */
/* AUTHOR   :  JEFFREY SCOTT DONOVAN                                      */

/* MODULE :                  PRINTER OK                                   */
/*========================================================================*/
/* This function checks the printer status to see if printer is ok. The   */
/* variable pointer prn_status returns status in case further examination */
/* is needed. If printer ok return 1, otherwise return 0.                 */
/* Prn_num 0 =LPT1:, 1 =LPT2: ETC.                                        */
/*                                                                        */
int printer_ok(int prn_num,int *prn_status)
   {
   int ok;

   /* CHECK STATUS OF PRINTER */
   /*-------------------------*/
   *prn_status=biosprint(2,'x',prn_num);

   /* IF PRINTER NOT BUSY AND */
   /* SELECTED, THEN ITS OK   */
   /*-------------------------*/
   if ( (((*prn_status) & 128)==128) &&  (((*prn_status) & 16)==16) ) ok=1;else ok=0;

   return(ok);
   }
/*========================================================================*/

/* MODULE : ABORT RETRY PRINTER                                           */
/*========================================================================*/
/* This function is called when a printer error has already been detected.*/
/* In then saves the screen and window, retrys printer, prints the approp */
/* error, and asks to abort or retry. If aborted then the function returns*/
/* 1, if retry then we keep checking printer status until we are ok or    */
/* decides to abort. If ok then we return 0. Before returning we restore  */
/* the old screen and window. Prn_num 0 =LPT1:, 1 =LPT2: ETC.             */
/*                                                                        */
int abort_retry_printer(int prn_num,int *prn_status)
   {
   char ch;
   int time_out,io_err,select_err,no_paper,power_err,busy; /* ERRORS */

   int early_exit,ok;             /* TO TEST USER ANSWER, PRINTER    */
   char *screen_0buf[80*25*2];    /* TO SAVE SCREEN TO               */
   struct text_info w;            /* OLD WINDOW COORDINATES          */

   /* SOME SLOW PRINTERS NEED    */
   /* LONGER TO SEND STATUS, IF  */
   /* YOURS IS FAST TAKE THIS OUT*/
   /* BUT IS YOUR CUSTOMERS?     */
   /*----------------------------*/
   delay(1000);
   printer_ok(prn_num,prn_status);

   /* SAVE THE CURRENT SCREEN    */
   /*----------------------------*/
   gettext(1,1,80,24,screen_0buf);

   /* SAVE CURRENT WINDOW COORDS */
   /*----------------------------*/
   gettextinfo(&w);

   /* MAKE NEW WINDOW FOR MESSAGE*/
   /*----------------------------*/
   window(1,1,80,25);
   textbackground(4);            /* LO RED FOR BACKGROUND ERROR MESSAGE */
   textcolor(0);                 /* TEXT COLOR BLACK                    */
   window(18,11,62,12);          /* PROGRAMMER CAN DRAW A BOX AROUND    */
   clrscr();                     /* THE WINDOW TO MAKE IT LOOK BETTER   */
                                 /* BUT WE WONT FOR SIMPLICITY SAKE     */

   /* SET STARTUP-END VARIABLES  */
   /*----------------------------*/
   early_exit=0;
   ok=0;

   /* PRINT ABORT RETRY MESSAGE  */
   /*----------------------------*/
   textcolor(0);
   gotoxy(18,2);
   textcolor(14);cprintf("A");textcolor(1);cprintf("bort, ");
   textcolor(14);cprintf("R");textcolor(1);cprintf("etry ?");
   textcolor(0);

   /* DO THIS ROUTINE UNTIL WE   */
   /* HAVE ABORTED OR PRINTER IS */
   /* OK.                        */
   /*----------------------------*/
   do
      {

      /* FIGURE OUT WHAT THE ERROR IS     */
      /*----------------------------------*/
      time_out=  ((*prn_status & 1))==1?1:0;
      io_err=    ((*prn_status & 8))==8?1:0;
      select_err=((*prn_status & 16))!=16?1:0;
      no_paper=  ((*prn_status & 32))==32?1:0;
      power_err= ((*prn_status & 64))==64?1:0;
      busy   =   ((*prn_status & 128))==128?1:0;

      /* IF ANY OF THESE ARE ON, SO IS    */
      /* SELECT ,LETS TURN THAT OFF.      */
      /*----------------------------------*/
      if ((no_paper)||(power_err)||(busy)||(time_out)) {select_err=0;io_err=0;}
      if (io_err) select_err=0;

      /* NOW PRINT OUT THE ENTIRE ERROR.   */
      /*-----------------------------------*/
      gotoxy(2,1);
      if (time_out) cprintf("   Time-Out Error or Device Write Error.    ");
	 else if (io_err) cprintf(" Printer I/O Error / Is Cabling Connected? ");
	     else if (select_err) cprintf(" Printer Select Error / Is Select Light On? ");
		else if (no_paper) cprintf("     No Paper Error / Check Paper Tray.     ");
		   else if (power_err) cprintf(" Printer Acknowledge Error / Is Printer On? ");
		      else if (busy) cprintf("Printer Busy Error / To Wait Or Not To Wait?");
      cprintf("%c",7);

      /* READ CHAR FROM KEYBOARD.          */
      /*-----------------------------------*/
      ch=getch();

      /* IF KEY = A,a THEN ABORT PROCESS   */
      /*-----------------------------------*/
      if ((ch==65)||(ch==97)) early_exit=1;

      /* IF KEY = R,r THEN RETRY STATUS    */
      /*-----------------------------------*/
      if ((ch==82)||(ch==114))
	 ok=printer_ok(prn_num,prn_status);
      }

   while( (!early_exit)&&(!ok));

   /* PUT ORIGINAL SCREEN BACK   */
   /*----------------------------*/
   puttext(1,1,80,24,screen_0buf);

   /* RESET THE ORIGINAL WINDOW  */
   /* AND COLORS                 */
   /*----------------------------*/
   window(1,1,80,25);
   window(w.winleft,w.wintop,w.winright,w.winbottom);
   textcolor(w.attribute);
   textbackground(w.normattr);
   gotoxy(w.curx,w.cury);

   /* IF EARLY EXIT, THEN WE     */
   /* ABORTED, OTHERWISE PRINTER */
   /* IS NOW OK.                 */
   /*----------------------------*/
   return(early_exit);
   }
/*========================================================================*/

/*                           BIO PRINT STRING                             */
/*========================================================================*/
/* This function trys to print a string to the printer. If errors occur,  */
/* goto abort-retry-printer to see if user wants to abort. Continue until */
/* string is printed or user aborts. You can pass standard control        */
/* sequences to print form feed ( \f ), carriage return, etc.             */
/* Prn_num 0 =LPT1:, 1 =LPT2: ETC.                                        */
/*                                                                        */
int bio_print_string(const char string[255],int prn_num)
   {
   int byte,loop,status;
   int ok;

   loop=0;

   /* TRY TO PRINT ENTIRE STRING */
   /*----------------------------*/
   while (loop<=strlen(string))
      {

      /* CHECK PRINTER STATUS   */
      /*------------------------*/
      status=biosprint(2,string[loop],prn_num);

      /* IF TIMEOUT OR SEL ERR  */
      /* OR NO PAPER OR IO ERR. */
      /* ASK TO ABORT. IF USER  */
      /* ABORTS,WE RETURN HERE. */
      /*------------------------*/
      if ( ((status & 1)==1) ||
	   ((status & 8)==8) ||
	   ((status & 16)!=16) ||
	   ((status & 32)==32) )
	   if (abort_retry_printer(prn_num,&status)) return(0);

      /* IF STATUS OK AND PRN   */
      /* NOT BUSY THEN PRINT    */
      /* CHAR AND UPDATE LOOP   */
      /*------------------------*/
      if ((status & 128)==128)
	 {
	 biosprint(0,string[loop],prn_num);
	 ++loop;
	 }

      }

   /* ALL DONE, RETURN TRUE  */
   /*------------------------*/
   return(1);
   }
/*========================================================================*/




