;************************************************
;*  02/17/89  *  SUBROUTS.ASM  *  Version 1.00	*
;************************************************
;*						*
;*	Handy Subroutines			*
;*						*
;************************************************

;Stack during most interrupts

;if pusha, mov bp,sp followed by
;  push es, push ds.
    PALL_DS	EQU -4
    PALL_ES	EQU -2
    PALL_DI	EQU 0
    PALL_SI	EQU 2
    PALL_BP	EQU 4
    PALL_SP	EQU 6
    PALL_BX	EQU 8
    PALL_DX	EQU 10
    PALL_CX	EQU 12
    PALL_AX	EQU 14
;if pusha done after int
    PALL_IP	EQU 16
    PALL_CS	EQU 18
    PALL_FLAGS	EQU 20
      CARRY_FLAG	  EQU 0001H
      ZERO_FLAG		  EQU 0040H
      INT_ENABLE_FLAG	  EQU 0200H	

;*********************************************************
PrinterPort	equ 0
PrinterFlag	DB	0	;set by equate in COTRAP.ASM

Putc   PROC NEAR  ;sends character in AL to video/Printer
  CMP	PrinterFlag, 0
  JNE	@F
  RomCall	Video, TTYOut
  JMP	short	PC_99
@@:
  PUSH	DX
  MOV	DX, PrinterPort
  RomCall	Printer, PSend
  POP	DX
PC_99:
  RET
Putc   ENDP
  
Puts PROC NEAR	;sends string at DS:SI to video/printer
  CLD
  CMP	PrinterFlag, 0
  JNE	SO_20
SO_11:	;send output to video
  LODSB
  OR	AL, AL
  JZ	SO_10
  RomCall	Video, TTYOut
  JMP	SO_11

SO_20:
  PUSH	DX
  MOV	DX, PrinterPort
SO_21:	;send output to printer
  LODSB
  OR	AL, AL
  JZ	SO_22
  RomCall	Printer, PSend
  JMP	SO_21
SO_22:
  POP	DX
SO_10:
  RET
Puts ENDP

IP_StringOut PROC NEAR
  PUSH	BP
  MOV	BP,SP
  PUSH	AX
  PUSH	SI
  PUSH	DS
  MOV	AX, CS
  MOV	DS, AX
  MOV	SI, 2[BP]
  CALL	Puts
  MOV	2[BP], SI
  POP	DS
  POP	SI
  POP	AX
  POP	BP
  RET
IP_StringOut ENDP

HexNibble:
  push	ax
  and	al, 0fh
  cmp	al, 9
  jbe	@f
  add	al, 7
@@:
  add	al, '0'
  call	Putc
  pop	ax
  ret
  
HexByte PROC NEAR
  push	ax
  shr	ax, 4
  call	HexNibble
  pop	ax
  call	HexNibble
  ret
HexByte ENDP

HexWord PROC NEAR
  push	ax
  mov	al, ah
  call	HexByte
  pop	ax
  call	HexByte
  ret
HexWord ENDP

Space PROC NEAR USES AX
  mov	al, ' '
  call	Putc
  ret
Space ENDP

CRLF PROC NEAR USES AX
  mov	al, CR
  call	Putc
  mov	al, LF
  call	Putc
  ret
CRLF ENDP
;------------------------------------------------
