/*
     From the C'ing Clearly column in Micro Cornucopia Magazine Issue #46

     Program:  Sines

     Version:  1.00
     Date:     29-Nov-1988

     Language: ANSI C

     Computes all of the sines of the angles between 0 and 360 degrees.

     Developed by Scott Robert Ladd. This program is public domain.
*/

#define pi2rad 57.29577951

/* prototypes */
void main(void);
double fact(double);
double power(double, double);

void main()
    {
    double angle, radians, sine, worksine, temp, k;

    for (angle = 0.0; angle <= 360.0; angle += 1.0)
        {
        radians = angle / pi2rad;
        k = 0.0;
        worksine = 0.0;

        do  {
            sine = worksine;
            temp = (2.0 * k) + 1.0;
            worksine += (power(-1.0,k) / fact(temp)) * power(radians,temp);
            k += 1.0;
            }
        while (sine != worksine);
        }
    }

/* Note: this function is designed for speed; it ONLY works when n is integral */
double fact(double n)
    {
    double res;

    res = 1.0;

    while (n > 0.0)
        {
        res *= n;
        n -= 1.0;
        }

    return res;
    }

/* Note: this function is designed for speed; it ONLY works when p is integral */
double power(double n, double p)
    {
    double res;

    res = 1.0;

    while (p > 0.0)
        {
        res *= n;
        p -= 1.0;
        }

    return res;
    }
