/*
     From the C'ing Clearly column in Micro Cornucopia Magazine Issue #46

     Program:  Grind

     Version:  1.11
     Date:     26-Oct-1988

     Language: ANSI C

     Tests all aspects of a C compiler's functions, including disk i/o,
     screen i/o, floating point, recursion, prototyping, and memory
     allocation. It should be a large enough program to test the advanced
     optimizers in some compilers.

     Developed by Scott Robert Ladd. This program is public domain.
*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define MAXFLOATS 1000

struct tabent
     {
     double val, vsum, vsqr, vcalc;
     };

struct tabent table[MAXFLOATS];

char *errmsg[] = {
                 "GRIND.TBL cannot be created",
                 "GRIND.TBL cannot be closed properly",
                 "GRIND.IN cannot be found",
                 "GRIND.IN has been truncated",
                 "GRIND.IN cannot be closed properly"
                 };

/* function prototypes */
short main(void);
void  readfloats(void);
void  sortfloats(void);
void  quicksort(struct tabent *, short, short);
void  maketable(void);
void  writetable(void);
void  error(short);

short main(void)
     {
     puts("\nGrind (C) v1.10  -- A Benchmark Program\n");

     readfloats();

     sortfloats();

     maketable();

     writetable();

     puts("\7End run GRIND!!!");

     return(0);
     }

void readfloats()
     {
     register short i;
     char buf[12];
     FILE *fltsin;

     printf("--> Reading in floats. At #     ");
     if (NULL == (fltsin = fopen("GRIND.IN","r")))
          error(2);

     for (i = 0; i < MAXFLOATS; ++i)
          {
          printf("\b\b\b\b\b%5d",i);
          if (NULL == fgets(buf,12,fltsin))
               error(3);
          table[i].val = atof(buf);
          }

     if (fclose(fltsin))
          error(4);

     printf("\n");
     }

void sortfloats()
     {
     puts("--> Sorting data");
     quicksort(table,0,MAXFLOATS-1);
     }

void quicksort(struct tabent * item,
               short left,
               short right)
     {
     register short i, j;
     struct tabent x, y;

     i = left;
     j = right;
     x = item[(i+j)/2];

     do
          {
          while (item[i].val < x.val && i < right) i++;
          while (x.val < item[j].val && j > left)  j--;
          if (i <= j)
               {
               y = item[i];
               item[i] = item[j];
               item[j] = y;
               i++;
               j--;
               }
          }
     while (i <= j);

     if (left < j)  quicksort(item,left,j);
     if (i < right) quicksort(item,i,right);
     }

void maketable()
     {
     register short i;
     double sum = 0.0;

     puts("--> Calculating table values");

     for (i = 0; i < MAXFLOATS; ++i)
          {
          sum = sum + table[i].val;
          table[i].vsum  = sum;
          table[i].vsqr  = table[i].val * table[i].val;
          table[i].vcalc = sqrt(fabs(table[i].val)) * log10(fabs(table[i].val));
          }
     }

void writetable()
     {
     FILE *fd;
     register short i;

     if (NULL == (fd = fopen("GRIND.TBL","w+")))
          error(0);

     puts("--> Writing Table to File");

     for (i = 0; i < MAXFLOATS; i = i + 10)
          {
          fprintf(fd,
                  "val = %5.2f, sum = %5.2f, sqr = %5.2f, calc = %5.2f\n",
                  table[i].val,
                  table[i].vsum,
                  table[i].vsqr,
                  table[i].vcalc);
          }

     if (fclose(fd))
          error(1);

     }

void error(short err_no)
     {
     printf("\n\7GRIND ERROR: %s\n",errmsg[err_no]);
     exit(err_no);
     }
