/*	REGSDUMP.c -  Routine to dump a __regs structure

        Supports ISR article in Micro Cornucopia Magazine Issue #46
*/


#include <call.h>

#define err_printf printf

#pragma vpindex __regs_dump
void __regs_dump( rp )
__regs far *rp;
{
#define _REGS (*rp)

	err_printf( "\
ax-%04x  cx-%04x  si-%04x  bp-%04x  ds-%04x   pc-%04x:%04x  pswh-%02x %c%c%c%c %c%c%c%c\n\
bx-%04x  dx-%04x  di-%04x           es-%04x  stk-%04x:%04x     l-%02x %c%c%c%c %c%c%c%c\n",

	      _AX, _CX, _SI, _BP, _DS, _CS, _IP,

	      _PSW >> 8,
	      rp->psw.bit.resf ? '1' : '.',
	      rp->psw.bit.rese ? '1' : '.',
	      rp->psw.bit.resd ? '1' : '.',
	      rp->psw.bit.resc ? '1' : '.',
	      _OF    ? 'o' : '.',
	      _DIR   ? 'd' : '.',
	      _INTE  ? 'i' : '.',
	      _TRAP  ? 't' : '.',

	      _BX, _DX, _DI,      _ES, _SS, _SP,

	      _PSW & 0xff,
	      _SIGN  ? 's' : '.',
	      _ZERO  ? 'z' : '.',
	      rp->psw.bit.res5 ? '1' : '.',
	      _AUXC  ? 'a' : '.',
	      rp->psw.bit.res3 ? '1' : '.',
	      _PE    ? 'p' : '.',
	      rp->psw.bit.res1 ? '1' : '.',
	      _CARRY ? 'c' : '.' );
}


