/*	ISR.c -  Routines to support Interrupt Service Routines.

        Supports ISR article in Micro Cornucopia Magazine Issue #46
*/


#include <isr.h>


#pragma vpindex isr_get_vector
void far *isr_get_vector( inum )
int inum;
{
	return (void far *)(*((long far *)((long)(inum * 4))));
}


#pragma vpindex isr_set_vector
void isr_set_vector( inum, farfuncp )
void far (*farfuncp)();
int inum;
{
#asm
	mov	ax,word ptr 4[bp]
	shl	ax,1
	shl	ax,1
	mov     dx,0
	mov	es,dx
	mov	bx,ax
	mov	dx,word ptr 8[bp]
	mov	ax,word ptr 6[bp]
	cli
	mov	es:word ptr 2[bx],dx
	mov     es:word ptr 0[bx],ax
	sti
#endasm
}


#pragma vpindex isr_install
void isr_install( isr, isr_num, handler )
isrh *isr;
int isr_num;
void far (*handler)();
{
	extern int _ISRHT_LENGTH;
	extern unsigned char far *_ISRHT_PTR;
	int i;

	setmem( isr, sizeof *isr, 0 );
	/* the long form of movmem() is used here to avoid 
	   problems with the different memory models...    
	*/
	for ( i = 0; i < _ISRHT_LENGTH; i++ )
	   ((char *)isr)[i] = _ISRHT_PTR[i];

	isr->hndlr = handler;
	isr->isr_num = isr_num;
	isr->isrho = ((long)((void far *)isr)) & 0xffff;
	isr->isrhs = ((long)((void far *)isr)) >> 16;
	isr->prev_hndlr = isr_get_vector( isr_num );

	if ( !isr->prev_hndlr )
	   isr->code_jmpf = OP_IRET;

	isr_set_vector( isr_num, (void far (*)())isr );
}


#pragma vpindex isr_restore
void isr_restore( isr )
isrh *isr;
{
	isr_set_vector( isr->isr_num, isr->prev_hndlr );
}


#ifdef MAIN

volatile long c;
volatile int k;

__regs _REGS;


main()
{
	isrh isr1, isr2, isr3, isrx;
	void far int_1c(), int_09(), int_23();
	int ascii;

	seg86( _REGSP );
	__regs_dump( _REGSP );

	isr_install( &isr1, 0x1c, int_1c );
	isr_install( &isr2, 0x09, int_09 );
	isr_install( &isr3, 0x23, int_23 );

	printf("\nBet ya can't ^C, ^BREAK or CTRL-ALT-DEL out'a this one!\n");
	printf("(hit ESC when you give up!)\n\n");

	ascii = 0;
	do 
	{  printf("Time: %lds, Last Scan code: %x    \r", c * 10l / 182l, k );
	   if ( constat() )
	      ascii = conin();
	} while ( ascii != 27 );

	isr_restore( &isr1 );
	isr_restore( &isr2 );
	isr_restore( &isr3 );
}


int conin()
{
	pcdos( 0x08 );
	return _AL;
}


int constat()
{
	pcdos( 0x0b );
	return !!_AL;
}


void far int_09( isr, _REGS )
isrh *isr;
isr_regs _REGS;
{
	static int ctrl;

	k = inportb( 0x60 );

	     if ( k == 29 )     /* control key pressed  */
	        ctrl = 1;
	else if ( k == 29+0x80 )/* control key released */
	        ctrl = 0;
	else if ( ctrl && ( k == 46 || k == 70 || k == 83 ) )
	     {  /* don't allow ^C, ^BREAK or ^DEL */
	        outportb( 0x61, inportb( 0x61 ) | 0x80 );
	        outportb( 0x61, inportb( 0x61 ) & 0x7f );
	        outportb( 0x20, 0x20 );
	        isr_iret( isr );
	        return;
	     };

	isr_pass( isr );
}

void far int_1c( isr, _REGS )
isrh *isr;
isr_regs _REGS;
{
	c++;
	isr_pass( isr );
}

void far int_23( isr, _REGS )
isrh *isr;
isr_regs _REGS;
{
	_CARRY = 0;
	isr_iret( isr );
}

#endif

