******************************************************
*** NAME:  PICTBOX.PRG
***
*** AUTHOR: BRETT FISHBURNE
***
*** PURPOSE: ALLOW GRAPHIC DRAWING OF MENU BOXES
***
*****************************************************
PARAMETERS XPOS, YPOS, TILENO

*** ESTABLISH ENVIRONMENT
SET ECHO OFF
SET TALK OFF
SET STATUS OFF
SET SCOREBOARD OFF

*** INITIALIZE CONSTRAINTS
CLEAR
GoodVals = 'QWEADZXC '+CHR(13)
XINIT = XPOS
YINIT = YPOS
XCORN = 0
YCORN = 0
i = ' '

*** DRAW INITIAL BORDER
@ 2,0 TO 2,79 DOUBLE
@ 0,0 TO 21,79 DOUBLE
@ 1,55 SAY TIME()
@ 1,70 SAY DATE()

*** SET UP LOOP TO GET THE BOX
DO WHILE (i # CHR(13))
  
  *** WAIT FOR USER RESPONSE
  i = 0
  DO WHILE AT(UPPER(CHR(i)),GoodVals) = 0
    
    *** UPDATE MENU DATA WHILE WAITING
    @ XPOS,YPOS SAY '0'
    i = INKEY()
    @ XPOS,YPOS SAY ' '
    IF XCORN > 0
      @ XCORN,YCORN SAY '+'
    ENDIF
    @ 1,55 SAY TIME()

  ENDDO

  *** PROCESS KEYSTROKE
  i = UPPER(CHR(i))
  DO CASE

    *** MOVE UP-LEFT
    CASE i = 'Q'
      XPOS = XPOS - 1
      YPOS = YPOS - 1

    *** MOVE LEFT
    CASE i = 'A'
      YPOS = YPOS - 1

    *** MOVE UP-RIGHT
    CASE i = 'E'
      XPOS = XPOS - 1
      YPOS = YPOS + 1

    *** MOVE UP
    CASE i = 'W'
      XPOS = XPOS - 1

    *** MOVE RIGHT
    CASE i = 'D'      
      YPOS = YPOS + 1

    *** MOVE DOWN-LEFT
    CASE i = 'Z'
      XPOS = XPOS + 1
      YPOS = YPOS - 1

    *** MOVE DOWN
    CASE i = 'X'
      XPOS = XPOS + 1

    *** MOVE DOWN-RIGHT
    CASE i = 'C'
      XPOS = XPOS + 1
      YPOS = YPOS + 1

    *** MARK THE SECOND BOX CORNER
    CASE XCORN > 0

      *** CHECK IF 2ND IS ABOVE 1ST    
      IF YCORN < YPOS

        *** CHECK IF 2ND IS LEFT OF 1ST
        IF XCORN < XPOS

          *** DRAW BOX AND SAVE
          @ XCORN,YCORN TO XPOS,YPOS DOUBLE
          REPLACE TILE&TILENO WITH STR(XCORN,2) + ', ' + STR(YCORN,2) +;
                                   ' TO ' + STR(XPOS,2) + ',' + STR(YPOS,2)

        ELSE

          *** DRAW BOX AND SAVE
          @ XPOS,YCORN TO XCORN,YPOS DOUBLE
          REPLACE TILE&TILENO WITH STR(XPOS,2) + ',' + STR(YCORN,2) +;
                                   ' TO ' + STR(XCORN,2) + ',' + STR(YPOS,2)

        ENDIF

      ELSE 

        *** CHECK IF 2ND IS LEFT OF 1ST        
        IF XCORN < XPOS

          *** DRAW BOX AND SAVE
          @ XCORN,YPOS TO XPOS,YCORN DOUBLE
          REPLACE TILE&TILENO WITH STR(XCORN,2) + ',' + STR(YPOS,2) +;
                                   ' TO ' + STR(XPOS,2) + ',' + STR(YCORN,2)

        ELSE

          *** DRAW BOX AND SAVE
          @ XPOS,YPOS TO XCORN,YCORN DOUBLE
          REPLACE TILE&TILENO WITH STR(XPOS,2) + ',' + STR(YPOS,2) +;
                                   ' TO ' + STR(XCORN,2) + ',' + STR(YCORN,2)

        ENDIF

      ENDIF

      *** REINITIALIZE CORNERS
      XCORN = 0
      YCORN = 0
      XPOS = XINIT
      YPOS = YINIT

    OTHERWISE

      *** MARK THE FIRST CORNER
      XCORN = XPOS
      YCORN = YPOS

  ENDCASE

  *** KEEP CURSOR ON SCREEN
  IF XPOS > 20

    XPOS = 20

  ELSE

    IF XPOS < 3

      XPOS = 3

    ENDIF

  ENDIF

  IF YPOS > 78

    YPOS = 78

  ELSE

    IF YPOS < 1

      YPOS = 1

    ENDIF

  ENDIF 

ENDDO

*** RESET ORIGIONAL POSITION
XPOS = XINIT
YPOS = YINIT

*** RETURN TO THE CALLING PROGRAM
RETURN