;Support code for Ray Tracing article in Micro C issue #42 by Earl Hinrichs

; Listing 1

  .text
PointOnLine:
;In:    a8 = Ray
;       a9 = Time parameter
;       a10 = Point
  move  *a8(rdx), a0, 1         ;fetch x direction
  move  a9, a1                  ;scale by time parameter
  calla fxMultiply
  move  *a8(rox), a1, 1         ;add x starting value
  add   a1, a0
  move  a0, *a10(px), 1         ;store result
  move  *a8(rdy), a0, 1         ;repeat for y
  move  a9, a1
  calla fxMultiply
  move  *a8(roy), a1, 1
  add   a1, a0
  move  a0, *a10(py), 1
  move  *a8(rdz), a0, 1         ;and for z
  move  a9, a1
  calla fxMultiply
  move  *a8(roz), a1, 1
  add   a1, a0
  move  a0, *a10(pz), 1
  rets





;Listing 2 **********/

intLinePlane:
;In     a8 = Ray
;       a9 = Plane
;Out:   a0 = intersection parameter
;       a0 <= 0 if no intersection
  mmtm  sp, a4, a5, a6, a7, a8, a9
  calla vDot            ;ro.pn (ray_origin dot plane normal)
  move  a0, a4
  addi  rdx, a8
  calla vDot            ;rd.pn (ray direction dot plane normal)
  move  a0, a1
  move  *a9(pc), a0, 1
  sub   a4, a0
  calla fxDivide
  mmfm  sp, a4, a5, a6, a7, a8, a9
  rets                  ;(pc-ro.pn)/(rd.pn)





;Listing 3

intLineRectangle:
;In:    a8 = ray
;       a9 = rectangle data
  mmtm  sp, a4, a5, a8, a9, a10
  move  a9, a5          ;save rectangle pointer
  calla intLinePlane    ;Test for intesection with embedding plane
  btst  31, a0
  jrnz  ir_01           ;if not then quit
  move  a0, a4          ;Save intersection time
  move  a0, a9          ;a8 = ray, a9 = time
  movi  vTemp0, a10     ;a10 will hold point of intersection.
  calla PointOnLine
  move  a10, a8         ;Intersection point
  move  a5, a9
  addi  60H, a9         ;minus origin
  calla vSub            ;to temp.
  addi  80H, a9         ;point to X extent
  calla vCalibrate      ;project temp onto X extent
  btst  31, a0          ;miss if negative
  jrnz  ir_01
  movi  One, a1         ;or greater than one
  cmp   a1, a0
  jrnc  ir_01
  addi  >60, a9         ;point to Y extent
  calla vCalibrate      ;test projection onto Y side
  btst  31, a0          ;miss if negative
  jrnz  ir_01
  movi  One, a1         ;or if greater than 1
  cmp   a1, a0
  jrnc  ir_01
  move  a4, a0          ;return time of intersection
  jruc  ir_00
ir_01:
  movi  -1, a0          ;return negative number if miss.
ir_00:
  mmfm  sp, a4, a8, a9, a10
  rets





;Listing 4

intLineSphere:
;In     a8 = Ray
;       a9 = Sphere
;Out:   a0 = intersection parameter
;       a0 <= 0 if no intersection
  mmtm  sp, a4, a5, a6, a7, a8, a9, a10
  move  a8, a4
  move  a9, a5
  movi  vTemp0, a10
  calla vSub            ;temp0 = ro-sc
  addi  rdx, a8
  move  a8, a9
  calla vDot            ;rd.rd
  move  a0, a6          ;'a' in quadratic equation
  move  a10, a9 
  calla vDot
  add   a0, a0
  move  a6, a1
  calla fxDivide
  move  a0, a7          ;'b' in quadratic equation
  move  a10, a8
  calla vDot
  move  *a5(sr2), a1, 1 ;radius squared
  sub   a1, a0          ;'c' in quadratic equation
  move  a6, a1
  calla fxDivide
  sll   2, a0           ;4ac
  move  a0, a6
  move  a7, a0
  move  a7, a1
  calla fxMultiply      ;b^2
  sub   a6, a0          ;b^2-4ac
  jrlt  is_00           ;no intersection if negative.
  calla fxSqRoot        ;sqrt(b^2-4ac)
  move  a7, a1          ;b
  neg   a1              ;-b
  sub   a0, a1          ;-b-sqrt(b^2-4ac)
  sra   1, a1           ;(-b-sqrt(b^2-4ac))/2
  cmpi SphereMinTime, a1 ;test with room to get started.
  jrgt  is_01           ;if positive then is first intersection.
  add   a0, a1          ;(-b+sqrt(b^2-4ac))/2
                        ;if positive then it is the intersection, if negative
                        ;then there is no intersection. In either case value
                        ;is returned as is.
is_01:
  move  a1, a0
is_00:
  mmfm  sp, a4, a5, a6, a7, a8, a9, a10
  rets





;Listing 5

refLinePlane:
;In:    a8 = Ray
;       a9 = Plane
;       a10 = intersection (point-on-line parameter)
;       a11 = reflection
  mmtm  sp, a4, a5, a6, a7, a8, a9, a10, a11
  move  a8, a4          ;Line
  move  a9, a5          ;Plane
  move  a10, a9         ;point distance
  move  a11, a10        ;build reflective line here
  calla PointOnLine     ;origin.
lp_01:
  addi  rdx, a4         ;line direction
  move  a4, a8
  move  a5, a9          ;plane normal
  calla vDot            ;ld.pn
  sll   1, a0           ;2*ld.pn
  move  a0, a7
  move  a5, a8          ;pn
  calla vDot            ;pn.pn
  move  a0, a1
  move  a7, a0
  calla fxDivide        ;2*ld.pn/(pn.pn)
  move  a0, a9
  movi  vTemp0, a10
  calla vScale          ;(2*ld.pn/(pn.pn))pn
  move  a4, a8          ;ld
  move  a10, a9
  move  a11, a10
  addi  rdx, a10        ;reflection direction
  calla vSub            ;ld-(2*ld.pn/(pn.pn))pn
  mmfm  sp, a4, a5, a6, a7, a8, a9, a10, a11
  rets





;Listing 6

refLineSphere:
;In:    a8 = Line
;       a9 = Sphere
;       a10 = intersection (point-on-line parameter)
;       a11 = reflection
  mmtm  sp, a4, a5, a6, a7, a8, a9, a10, a11
  move  a8, a4          ;Line
  move  a9, a5          ;Sphere
  move  a10, a9         ;point distance
  move  a11, a10        ;build reflective line here
  calla PointOnLine     ;origin.
  move  a10, a8         ;create tangent plane,
  move  a5, a9          ;normal = intersection point - sphere center
  movi  vTemp1, a10
  calla vSub
  move  a10, a5         ;only need normal
  jruc  lp_01           ;continue in line / plane intersection.

