/* Code from Kaypro column in Micro Cornucopia Issue #40 */

/* Figure 1 - VIEW, Displays CP/M text file to the screen */

/*   Written for Small-C compiler vers 2.03 (ASM)
     Pauses every 22 lines; strips high bit so that
     WordStar files will display properly on terminals
     with graphics displays.
*/

#include <stdioa.h>
#include "iolib.asm"
#include "call.asm"

#define MASK 127      /* high bit mask = 01111111b */
#define NOCCARGC

int infile;
char fname[15];

main(argc,argv) int argc, argv[]; {

   int line, ch;

   if (argc == 2)
      infile = fopen(argv[1],"r");
   else {
      fputs("Name of text file to view?",stdout);
      gets(fname);
      infile = fopen(fname,"r");
   }

   if (infile == NULL) {
      fputs("File not found.",stdout);
      exit();
   }

   line = 1;
   while ((ch = getc(infile)) != EOF ) {
      ch &=  MASK;           /* strip high bit */
      putchar(ch);
      if (ch == CR) {
         line++;
         if ((line % 22) == 0)
            pause();
      }
   }

   fclose(infile);
}

/*
*   Pause and wait for user to hit any key.
*   Key pressed does not echo to the console.
*   Control-C will exit program.
*/

pause() {
   int c;
   while ((c = cpm(6,255)) == 0);
   if (c == 3) exit();
}


