{ include the interrupt interface routines }
{$IB:SIOLIB.INC}

Var
   Ch:     Char;
   B:      Byte;
   NoData: Boolean;            { no data read from serial port flag }
   I:      Integer;
   BRate:  Integer;            { baud rate value (0 - 15) }

Begin
     Repeat
           ClrScr;

           Writeln('Baud Rates');
           Writeln;
           Writeln('0  = 50');        Writeln('1  = 75');
           Writeln('2  = 110');       Writeln('3  = 134');
           Writeln('4  = 150');       Writeln('5  = 300');
           Writeln('6  = 600');       Writeln('7  = 1200');
           Writeln('8  = 1800');      Writeln('9  = 2000');
           Writeln('10 = 2400');      Writeln('11 = 3600');
           Writeln('12 = 4800');      Writeln('13 = 7200');
           Writeln('14 = 9600');      Writeln('15 = 19200');
           Writeln;
           Write('Which Baud Rate ? ');
           Readln(BRate);
     Until (BRate In [0..15]);


     { Initialize the SIO to the desired baud rate, 8 data bits, odd parity }
     { and 2 stop bits }

     Writeln('Initializing SIO');
     InitSIO(BRate,8,3,3);
     Writeln('sio initialized');


     { Read a character from the keyboard and if any present send to serial }
     { output 80 times, also read character from serial input fifo and echo }
     { to screen. Pressing control-c terminates program }

     While (True) Do
     Begin
          If (KeyPressed) Then
          Begin
               Read(Kbd,Ch);
               If (Ch = ^C) Then Halt;
               B:=Ord(Ch);
               For I:=1 to 80 Do WriteByte(B);
          End;

          B:=ReadByte(NoData);
          If (Not NoData) Then
               Write(Chr(B));

     End;
End.
