
;SERIAL INPUT/OUTPUT INTERRUPT DRIVEN DRIVERS

; FRANK A. KURUCZ
; 2360 PASEO DE LAURA #20
; OCEANSIDE CA,  92056

; H- (619) 721-8530
; W- (619) 433-6406



; THESE ROUTINES WERE MADE TO BE USED WITH THE TURBO PASCAL
; INTERFACE ROUTINES



; **************************************************************************


UARTDT	SET	4		;SERIAL DATA PORT
CONTROL	SET	6		;SERIAL CONTROL PORT

RET1	SET	0EDH		;THESE TWO BYTES ARE THE Z-80 RETI
RET2	SET	04DH		;INSTRUCTION, NOT SUPPORTED BY THE CP/M ASM

BDOS	SET	5		;BDOS VECTOR
VECTOR	SET	0E000H		;INTERRUPT VECTOR


;******************************************************************

; THE "PROGRAM"

	ORG	100H

UART:	MVI	C,0		;JUST REBOOT
	CALL	BDOS		;THE REST OF THE CODE WILL
				;REMAIN IN HIGH MEMORY JUST
				;UNDER THE CCP


;******************************************************************


;Z-80 SIO UART INTERRUPT VECTORS

	ORG	VECTOR


DW	0			;UNUSED INTERRUPT VECTOR
DW	0			;UNUSED
DW	0			;UNUSED
DW	0			;UNUSED
DW	OUTINT			;SIO OUTPUT VECTOR
DW	EXTINT			;EXTERNAL/STATUS VECTOR
DW	INPINT			;SIO INPUT VECTOR
DW	ERRINT			;INPUT ERROR VECTOR


;************************************************************************


;SERIAL INPUT INTERRUPT HANDLER

INPINT:	PUSH	H		;SAVE THE REGISTERS USED
	PUSH	B
	PUSH	PSW

	IN	UARTDT		;READ DATA FROM THE UART
	MOV	B,A		;SAVE IT

	LDA	SRICNT		;IS THERE ANY ROOM IN THE INPUT FIFO?
	CPI	0FFH
	JZ	INPEXT		;OOPS, IT IS FULL
	INR	A		;NOT FULL YET, SO INCREMENT ITS COUNT
	STA	SRICNT		;AND SAVE IT

	LHLD	SRIINP		;GET INPUT POINTER TO FIFO
	MOV	M,B		;STORE THE DATA IN THE FIFO
	INR	L		;INCREMENT POINTER (AUTO WRAP AROUND)
	SHLD	SRIINP		;AND SAVE THE UPDATED FIFO

INPEXT:	POP	PSW		;RESTORE THE REGISTERS
	POP	B
	POP	H
	EI			;RE-ENABLE INTERRUPTS

	DB	RET1,RET2	;Z-80 RETI INSTRUCTION


;*************************************************************************

;SERIAL OUTPUT INTERRUPT DRIVER


OUTINT:	PUSH	H		;SAVE REGISTERS
	PUSH	PSW

	LDA	SROCNT		;ANYTHING IN THE FIFO TO OUTPUT?
	ORA	A
	JZ	OEMPTY		;NO, GO TO EMPTY FIFO PROCESSOR

	DCR	A		;FIFO NOT EMPTY, SO DECREMENT ITS COUNT
	STA	SROCNT

	LHLD	SROOUT		;GET OUTPUT POINTER TO FIFO
	MOV	A,M		;GET THE DATA TO OUTPUT FROM THE FIFO
	OUT	UARTDT		;AND OUTPUT IT TO THE UART
	INR	L		;INCREMENT FIFO POINTER
	SHLD	SROOUT		;AND INCREMENT THE FIFO

	MVI	A,0FFH
	STA	OUTFLG		;SET THE INTERRUPT EXPECTED FLAG
	JMP	OUTEXT

OEMPTY:	XRA	A		;LOWER THE INTERRUPT EXPECTED FLAG
	STA	OUTFLG
	OUT	CONTROL		;AND RESET THE INTERRUPT
	MVI	A,28H
	OUT	CONTROL

OUTEXT:	POP	PSW		;RESTORE REGISTERS
	POP	H

	EI

	DB	RET1,RET2	;Z-80 RETI INSTRUCTION


;***********************************************************************


;EXTERNAL/STATUS INTERRUPT


EXTINT:	PUSH	PSW		;RESET THE INTERRUPT
	MVI	A,10H
	OUT	CONTROL
	POP	PSW

	EI
	DB	RET1,RET2



;**********************************************************************


;INPUT ERROR INTERRUPT


ERRINT:	PUSH	PSW		;RESET THE INTERRUPT
	MVI	A,30H
	OUT	CONTROL
	POP	PSW

	EI
	DB	RET1,RET2



;***********************************************************************


;DATA AREA

	ORG	VECTOR + 100H



SRIFIF:	DS	100H		;SERIAL INPUT FIFO
SROFIF:	DS	100H		;SERIAL OUTPUT FIFO

SRICNT:	DS	1		;SERIAL INPUT FIFO COUNTER
SRIINP:	DS	2		;INPUT POINTER
SRIOUT:	DS	2		;OUTPUT POINTER

SROCNT:	DS	1		;SERIAL OUTPUT FIFO COUNTER
SROINP:	DS	2		;INPUT POINTER
SROOUT:	DS	2		;OUTPUT POINTER

OUTFLG:	DS	1		;OUTPUT INTERRUPT EXPECTED FLAG

	END	UART
