
add_to_list(X, Y, L) :-
	not(member(X, Y)),
	append([X], Y, L).

build_hand(Suit) :-
	values(Suit, Honor, Points),
	Honor = small,
	add_small(Suit, Points).
build_hand(Suit) :-
	values(Suit, y, 1),
	hand(Suit, L),
	add_to_list(jack, L, Newlist),
	retract(hand(Suit, L)),
	asserta(hand(Suit, Newlist)).
build_hand(Suit) :-
	values(Suit, y, 2),
	hand(Suit, L),
	add_to_list(queen, L, Newlist),
	retract(hand(Suit, L)),
	asserta(hand(Suit, Newlist)).
build_hand(Suit) :-
	values(Suit, y, 3),
	hand(Suit, L),
	add_to_list(king, L, Newlist),
	retract(hand(Suit, L)),
	asserta(hand(Suit, Newlist)).
build_hand(Suit) :-
	values(Suit, y, 4),
	hand(Suit, L),
	add_to_list(ace, L, Newlist),
	retract(hand(Suit, L)),
	asserta(hand(Suit, Newlist)).

values(clubs, small, 1).
values(clubs, y, 1).
values(clubs, n, 2).
values(clubs, n, 3).
values(clubs, n, 4).
values(diamonds, small, 1).
values(diamonds, n, 1).
values(diamonds, n, 2).
values(diamonds, y, 3).
values(diamonds, y, 4).
values(hearts, small, 1).
values(hearts, y, 1).
values(hearts, y, 2).
values(hearts, y, 3).
values(hearts, y, 4).
values(spades, small, 1).
values(spades, y, 1).
values(spades, y, 2).
values(spades, y, 3).
values(spades, y, 4).

major(spades).
major(hearts).

hand(clubs, [jack, x]).
hand(diamonds, [ace, king, x]).
hand(hearts, [ace, king, queen, jack, x]).
hand(spades, [ace, king, queen, jack, x]).

points(clubs, 1, 2).
points(diamonds, 7, 3).
points(hearts, 11, 5).
points(spades, 11, 5).

clear_suits :- retractall(hand(Suit, Hand)).
clear_suits :-
	asserta(hand(spades, [])),
	asserta(hand(hearts, [])),
	asserta(hand(diamonds, [])),
	asserta(hand(clubs, [])).

find_longest_suit :-
	retractall(longest(Suitname, Count)),
	asserta(longest(none, 0)).
find_longest_suit :-
	points(Suit, Points, Count),
	longest(Suitname, Suitcount),
	Count > Suitcount,
	retract(longest(Suitname, Suitcount)),
	asserta(longest(Suit, Count)).

add_small(Suit, 0) :- !.
add_small(Suit, C) :-
	hand(Suit, L),
	append(L, [x], Newlist),
	retract(hand(Suit, L)),
	asserta(hand(Suit, Newlist)),
	X is C - 1,
	add_small(Suit, X).

eval_hand :-
	retractall(points(Suit, Points, Count)),
	asserta(points(spades, 0, 0)),
	asserta(points(hearts, 0, 0)),
	asserta(points(diamonds, 0, 0)),
	asserta(points(clubs, 0, 0)).
eval_hand :- get_count(spades).
eval_hand :- get_count(hearts).
eval_hand :- get_count(diamonds).
eval_hand :- get_count(clubs).
eval_hand :- count_hand.

hand_count(30).

count_hand :-
	retractall(hand_count(X)),
	asserta(hand_count(0)).
count_hand :-
	points(Suit, Points, Count),
	hand_count(X),
	Newpoints is X + Points,
	retractall(hand_count(X)),
	asserta(hand_count(Newpoints)).
count_hand :-
	hand_count(Points),
	print('Your hand is worth ', Points, ' points').

balanced_hand :-
	retractall(even_distr(X)),
	asserta(even_distr(no)).
balanced_hand :-
	points(Suit, Points, Count),
	Count < 3,
	!.
balanced_hand :-
	points(Suit, Points, Count),
	Count > 5,
	!.
balanced_hand :-
	retractall(even_distr(X)),
	asserta(even_distr(yes)).

minor(diamonds).
minor(clubs).

print_hand :- print('Your hand is:').
print_hand :-
	hand(Suit, List),
	print(Suit, ':'),
	tab(5),
	prin(List),
	nl.

bid([1, spades]).

get_values :-
	print('Enter your hand at the prompts'),
	get_suits(spades),
	get_suits(hearts),
	get_suits(diamonds),
	get_suits(clubs).

even_distr(no).

major_suit(spades).
major_suit(hearts).

get_count(Suit) :-
	values(Suit, Honor, Points),
	Honor = small,
	points(Suit, P, Count),
	Newcount is Count + Points,
	retract(points(Suit, P, Count)),
	asserta(points(Suit, P, Newcount)).
get_count(Suit) :-
	values(Suit, Honor, Points),
	not(Honor = small),
	Honor = y,
	points(Suit, P, Count),
	Newcount is Count + 1,
	Newpoints is Points + P,
	retract(points(Suit, P, Count)),
	asserta(points(Suit, Newpoints, Newcount)).
get_count(Suit) :-
	points(Suit, Points, Count),
	Count > 4,
	Newpoints is Points + Count - 4,
	retract(points(Suit, Points, Count)),
	asserta(points(Suit, Newpoints, Count)).

minor_suit(diamonds).
minor_suit(clubs).

eval_suit(Suit) :-
	retractall(points(Suit, Points, Count)),
	assera(points(Suit, 0, 0)),
	get_count(suit).

get_suits(Suit) :-
	print(Suit),
	print('Ace - y/n'),
	read(Ace),
	asserta(values(Suit, Ace, 4)),
	print('King - y/n'),
	read(King),
	asserta(values(Suit, King, 3)),
	print('Queen - y/n'),
	read(Queen),
	asserta(values(Suit, Queen, 2)),
	print('Jack - y/n'),
	read(Jack),
	asserta(values(Suit, Jack, 1)),
	print('How many small ', Suit, ' are in your hand?  '),
	read(Small),
	asserta(values(Suit, small, Small)).

why :- print_hand.
why :-
	hand_count(Points),
	Points < 13,
	print('You have ', Points, ' points. This is not enough
to\nopen'),
	!.
why :-
	bid([1, notrump]),
	hand_count(Points),
	print('Your hand is worth ', Points, ' points'),
	print('You have balanced distribution and between 16
and\n18 points'),
	print('In this situation you bid 1 notrump'),
	!.
why :-
	bid([1, X]),
	points(X, Points, Count),
	longest(Suitname1, Count),
	longest(Suitname2, Count),
	not(Suitname1 = Suitname2),
	print('You have 13 or more points'),
	print('You have 2 suits each with ', Count, ' cards.'),
	print('Bid either the higher ranking of two
touching\nsuits'),
	print('or the lower ranking if the suits do not\ntouch'),
	!.
why :-
	bid('1 club'),
	print('You do not have a biddable major suit'),
	print('Your diamond suit does not contain an honor'),
	print('Your club suit is not really biddable, but
you\nmust open'),
	print('This is a short club situation'),
	!.
why :-
	bid([1, X]),
	points(X, Points, Count),
	print('You have ', Points, ' points and ', Count, '
Cards\n        in ', X),
	print('Bid your longest suit').

touching(spades, hearts).
touching(hearts, diamonds).
touching(diamonds, clubs).
touching(clubs, spades).

decide_bid :- retractall(bid(X)).
decide_bid :- retractall(values(Suit, Honor, Points)).
decide_bid :- get_values.
decide_bid :- eval_hand.
decide_bid :- clear_suits.
decide_bid :- build_hand(spades).
decide_bid :- build_hand(hearts).
decide_bid :- build_hand(diamonds).
decide_bid :- build_hand(clubs).
decide_bid :- print_hand.
decide_bid :-
	hand_count(Count),
	Count < 13,
	print('Pass'),
	asserta(bid(pass)),
	!.
decide_bid :- balanced_hand.
decide_bid :-
	even_distr(yes),
	hand_count(Count),
	Count > 15,
	Count < 19,
	print('1 notrump'),
	asserta(bid([1, notrump])),
	!.
decide_bid :- find_longest_suit.
decide_bid :- find_next_long_suit.
decide_bid :-
	longest(Suit1, Count),
	Count > 4,
	longest(Suit2, Count),
	not(Suit1 = Suit2),
	touching(Suit1, Suit2),
	print('1 ', Suit1),
	asserta(bid([1, Suit1])),
	!.
decide_bid :-
	longest(Suit1, Count),
	Count > 4,
	longest(Suit2, Count),
	not(Suit1 = Suit2),
	print('1 ', Suit2),
	asserta(bid([1, Suit2])),
	!.
decide_bid :-
	longest(Suit, Count),
	Count > 5,
	print('1 ', Suit),
	asserta(bid([1, Suit])),
	!.
decide_bid :-
	points(Suit, Points, Count),
	Count > 4,
	major(Suit),
	print('1 ', Suit),
	asserta(bid([1, Suit])),
	!.
decide_bid :-
	points(Suit, Points, Count),
	Count > 3,
	minor(Suit),
	values(Suit, Honor, Pts),
	Honor = y,
	print('1 ', Suit),
	asserta(bid([1, Suit])),
	!.
decide_bid :-
	points(clubs, Points, Count),
	Count > 2,
	print('1 club'),
	asserta(bid('1 club')),
	!.
decide_bid :-
	longest(Suit1, Count),
	Count > 3,
	longest(Suit2, Count),
	not(Suit1 = Suit2),
	touching(Suit1, Suit2),
	print('1 ', Suit1),
	asserta(bid([1, Suit1])),
	!.
decide_bid :-
	longest(Suit1, Count),
	Count > 3,
	longest(Suit2, Count),
	not(Suit1 = Suit2),
	print('1 ', Suit2),
	asserta(bid([1, Suit2])),
	!.
decide_bid :-
	longest(Suit, Count),
	Count > 3,
	print('1 ', Suit),
	asserta(bid([1, Suit])),
	!.

find_next_long_suit :-
	longest(Suitname, Suitcount),
	points(Suit, _, Count),
	not(Suit = Suitname),
	Count = Suitcount,
	asserta(longest(Suit, Count)).

append([], X, X).
append([X, ..L1], L2, [X, ..L3]) :- append(L1, L2, L3).

member(X, [X, .._]).
member(X, [_, ..Y]) :- member(X, Y).

longest(spades, 5).
longest(hearts, 5).
