/*
     Program:  FXREF (File Cross-Reference)
     
     Version:  1.00
     Date:     September 24, 1987
     
     Language: ANSI C
     
     Reads a file from standard input, sorts and organizes each token
     (word) found using a binary tree, keeping track of the number of
     occurences of each token and their location by line and column,
     and then prints a report to stdout.
     
     Copyright 1987 Scott Robert Ladd.
     Released into the public domain.
     Created for Micro Cornucopia C compiler review.
*/

#include "stdio.h"
#include "string.h"
#include "ctype.h"

#ifdef __TURBOC__
     #include "alloc.h"
#else
     #include "stdlib.h"
#endif

struct location
     {
     unsigned lineno;
     struct location *next;
     };

struct token
     {
     struct token *less, *more;
     char *text;
     struct location *loc, *last;
     };

struct token *root;

char *errmsg[] = {
                 "Cannot allocated space for token table root",
                 "Cannot allocate space for token text",
                 "Cannot allocate space for location references",
                 "Cannot allocate space for token record"
                 };

void parse_tokens(char *, unsigned);
void add_tree(char *, unsigned);
struct token *find_tree(char *);
void show_tree(struct token *);
void error(int);
void exit(int);

int main()
     {
     char buf[256];
     unsigned line=0;

     if (NULL == (root = (struct token *)malloc(sizeof(struct token))))
          error(0);

     root->less = NULL;
     root->more = NULL;
     root->text = NULL;
     root->loc  = NULL;

     while (NULL != (gets(buf)))
          {
          ++line;
          printf("%5u: %s\n",line,buf);
          parse_tokens(buf,line);
          }
          
     printf("\x0C\n");

     show_tree(root);

     return 0;
     }
     
void parse_tokens(buf,line)
char *buf;
unsigned line;
     {
     char tok[256];
     unsigned pos;
     
     while (1)
          {
          while ((!isalpha(*buf)) && (*buf != 0))
               ++buf;
          if (*buf == 0)
               return;
          pos = 0;
          while (isalpha(*buf))
               tok[pos++] = *buf++;
          tok[pos] = 0;
          add_tree(tok,line);
          }
     }

void add_tree(tok,line)
char *tok;
unsigned line;
     {
     struct token *temp_tok, *new_tok;
     struct location *temp_loc;
     int comp;
     
     if (root->text == NULL)
          {
          if (NULL == (root->text = (char *)malloc((unsigned)strlen(tok)+1)))
               error(1);
          strcpy(root->text,tok);
          if (NULL == (root->loc = (struct location *)malloc(sizeof(struct location))))
               error(2);
          root->loc->lineno = line;
          root->loc->next = NULL;
          root->last = root->loc;
          return;
          }
          
     temp_tok = find_tree(tok);
     
     if (comp = strcmp(tok,temp_tok->text))
          /* comp is true (non-zero) if they don't match */
          {
          if (NULL == (new_tok = (struct token *)malloc(sizeof(struct token))))
               error(3);
          if (NULL == (new_tok->text = (char *)malloc((unsigned)strlen(tok)+1)))
               error(1);
          new_tok->less = NULL;
          new_tok->more = NULL;
          strcpy(new_tok->text,tok);
          if (NULL == (new_tok->loc = (struct location *)malloc(sizeof(struct location))))
               error(2);
          new_tok->loc->lineno = line;
          new_tok->loc->next = NULL;
          new_tok->last = new_tok->loc;
          if (comp < 0)
               temp_tok->less = new_tok;
            else
               temp_tok->more = new_tok;
          }
       else
          /* if comp is false (0), the tokens match */
          {
          if (NULL == (temp_loc = (struct location *)malloc(sizeof(struct location))))
               error(2);
          temp_loc->lineno = line;
          temp_loc->next = NULL;
          temp_tok->last->next = temp_loc;
          temp_tok->last = temp_loc;
          }
     }

struct token *find_tree(tok)
char *tok;
     {
     int comp;
     struct token *node;
     
     node = root;
     
     while (1)
          {
          if (0 == (comp = strcmp(tok,node->text)))
               return node;
          if (comp < 0)
               if (node->less == NULL)
                    return node;
                 else
                    node = node->less;
            else
               if (node->more == NULL)
                    return node;
                 else
                    node = node->more;
          }
     }

void show_tree(node)
struct token *node;
     {
     struct location *lloc;
     int pos;
     
     if (NULL == node) return;
     
     show_tree(node->less);
     printf("%-32s: ",node->text);
     pos = 0;
     lloc = node->loc;
     while (lloc != NULL)
          {
          if (++pos == 7)
               {
               pos = 0;
               printf("\n%32s: "," ");
               }
          printf("%5d ",lloc->lineno);
          lloc = lloc->next;
          }
     printf("\n");
     show_tree(node->more);
     }

void error(errno)
int errno;
     {
     printf("\nFXREF ERROR: %s\n",errmsg[errno]);
     exit(errno+1);
     }
