/*
     Program: Grind

     Version: 1.00
     Date:    September 19, 1987

     Language: Generic ANSI C

     Tests all aspects of a C compilers functions, including disk i/o,
     screen i/o, floating point, recursion, prototyping, and memory
     allocation. It should be a large enough program to test the advanced
     optimizers in some compilers.

     Copyright 1987 Scott Robert Ladd. All Rights Reserved.
*/

#include <stdio.h>
#include <math.h>

#define MAXFLOATS 1000

struct tabent
     {
     double val, vsum, vsqr, vcalc;
     };

struct tabent table[MAXFLOATS];

char *errmsg[] = {
                "GRIND.TBL cannot be created",
                "GRIND.TBL cannot be closed properly",
                "GRIND.IN cannot be found",
                "GRIND.IN has been truncated",
                "GRIND.IN floating point format wrong",
                "GRIND.IN cannot be closed properly"
                };

/* function prototypes */
void readfloats(void);
void sortfloats(void);
void quicksort(struct tabent *,int,int);
void maketable(void);
void writetable(FILE *);
void error(int);
void exit(int);
double atof(char *);

main()
     {
     FILE *tblout;

     puts("\nGrind  v1.00  -- A Benchmark Program");
     puts("Written by Scott Robert Ladd for Micro Cornucopia C compiler review.");
     puts("Released: 09/19/87\n");

     readfloats();

     sortfloats();

     maketable();

     if (NULL == (tblout = fopen("GRIND.TBL","w+")))
          error(1);
     writetable(tblout);
     if (fclose(tblout))
          error(2);

     puts("\7\7\7End run GRIND!!!");

     return(0);
     }

void readfloats()
     {
     register int i;
     char buf[12];
     FILE *fltsin;

     printf("--> Reading in floats. At #     ");
     if (NULL == (fltsin = fopen("GRIND.IN","r")))
          error(3);

     for (i = 0; i < MAXFLOATS; ++i)
          {
          printf("\b\b\b\b\b%5d",i);
          if (NULL == fgets(buf,12,fltsin))
               error(4);
          table[i].val = atof(buf);
          }

     if (fclose(fltsin))
          error(6);

     printf("\n");
     }

void sortfloats()
     {
     puts("--> Sorting data");
     quicksort(table,0,MAXFLOATS-1);
     }

void quicksort(item,left,right)
struct tabent *item;
int left, right;
     {
     register int i, j;
     struct tabent x, y;

     i = left;
     j = right;
     x = item[(i+j)/2];

     do
          {
          while (item[i].val < x.val && i < right) i++;
          while (x.val < item[j].val && j > left)  j--;
          if (i <= j)
               {
               y = item[i];
               item[i] = item[j];
               item[j] = y;
               i++;
               j--;
               }
          }
     while (i <= j);

     if (left < j)  quicksort(item,left,j);
     if (i < right) quicksort(item,i,right);
     }

void maketable()
     {
     register int i;
     double sum = 0;

     puts("--> Calculating table values");

     for (i = 0; i < MAXFLOATS; ++i)
          {
          sum = sum + table[i].val;
          table[i].vsum  = sum;
          table[i].vsqr  = table[i].val * table[i].val;
          table[i].vcalc = sqrt(fabs(table[i].val)) * log10(fabs(table[i].val));
          }
     }

void writetable(fd)
FILE *fd;
     {
     register int i;

     puts("--> Writing Table to File");

     for (i = 0; i < MAXFLOATS; i = i + 10)
          {
          fprintf(fd,
                  "val = %5.2f, sum = %5.2f, sqr = %5.2f, calc = %5.2f\n",
                  table[i].val,
                  table[i].vsum,
                  table[i].vsqr,
                  table[i].vcalc);
          }
     }

void error(errno)
int errno;
     {
     printf("\n\7ERROR: %s\7",errmsg[errno-1]);
     exit(errno);
     }
