#include <assert.h>
#include <stdio.h>
#include <dos.h>
#include <memory.h>
#include "umbhelp.h"

void AllocateLarge(void);
void AllocateBlock(unsigned);
void AllocateOffset(unsigned);

main(int argc, char *argv[])
{
	unsigned int uSize, uHandle, ArgSize = 0;
	if (argc > 1)
	    ArgSize = atoi(argv[1]);
	if (ArgSize == 0)
	    ArgSize = 512;
	assert(umb_init() == 0);
	assert(umb_allocate(-1, &uHandle, &uSize) == 0xb0);
	printf("Largest free block 0x%04X Paragraphs\n", uSize);
	assert(umb_allocate(uSize, &uHandle, &uSize) == 0);
	printf("Allocated Handle = 0x%04X, size = 0x%04X\n", uHandle, uSize);
	assert(umb_free(uHandle) == 0);
	AllocateLarge();
	AllocateBlock(ArgSize);
	AllocateOffset(ArgSize);
	AllocateLarge();
	return(0);
}

void AllocateLarge(void)
{
	unsigned uSizeTbl[256];
	unsigned uHandleTbl[256];
	int i, n;
	printf("\nAllocate All of Upper Memory\n");
	for (i = 0; i < 256; i++) {
	    if (umb_allocate(-1, &uHandleTbl[i], &uSizeTbl[i]) != 0xb0)
		break;
	    assert(umb_allocate(uSizeTbl[i], &uHandleTbl[i], &uSizeTbl[i]) == 0);
	    printf("Allocate %3i, Handle = 0x%04X Size = 0x%04X\n", i, uHandleTbl[i], uSizeTbl[i]);
	}
	n = i;
	for (i = 0; i < n; i++) {
	    assert(umb_free(uHandleTbl[i]) == 0);
	    printf("Free     %3i, Handle = 0x%04X\n", i, uHandleTbl[i]);
	}
}

void AllocateBlock(unsigned uSize)
{
	unsigned uSizeTbl[256];
	unsigned uHandleTbl[256];
	int i, n;
	void far * dest;
	printf("\nAllocate 0x%04X Blocks\n", uSize);
	for (i = 0; i < 256; i++) {
	    if (umb_allocate(uSize, &uHandleTbl[i], &uSizeTbl[i]) != 0) {
		printf("Largest block left = 0x%04X\n", uSizeTbl[i]);
		break;
	    }
	    printf("Allocate %3i, Handle = 0x%04X Size = 0x%04X\n", i, uHandleTbl[i], uSizeTbl[i]);
	    FP_OFF(dest) = 0;
	    FP_SEG(dest) = uHandleTbl[i];
	    _fmemset(dest, 0x5a, uSizeTbl[i] * 16);
	}
	AllocateLarge();
	n = i;
	for (i = 0; i < n; i++) {
	    assert(umb_free(uHandleTbl[i]) == 0);
	    printf("Free     %3i, Handle = 0x%04X\n", i, uHandleTbl[i]);
	}
}

void AllocateOffset(unsigned uSize)
{
	unsigned uSizeTbl[256];
	unsigned uHandleTbl[256];
	int i, n;
	printf("\nAllocate 0x%04X Blocks\n", uSize);
	for (i = 0; i < 256; i++) {
	    if (umb_allocate(uSize, &uHandleTbl[i], &uSizeTbl[i]) != 0) {
		printf("Largest block left = 0x%04X\n", uSizeTbl[i]);
		break;
	    }
	    printf("Allocate %3i, Handle = 0x%04X Size = 0x%04X\n", i, uHandleTbl[i], uSizeTbl[i]);
	}
	n = i;
	AllocateLarge();
	for (i = 0; i < n; i += 2) {
	    assert(umb_free(uHandleTbl[i]) == 0);
	    printf("Free     %3i, Handle = 0x%04X\n", i, uHandleTbl[i]);
	}
	for (i = 1; i < n; i += 2) {
	    assert(umb_free(uHandleTbl[i]) == 0);
	    printf("Free     %3i, Handle = 0x%04X\n", i, uHandleTbl[i]);
	}
}
