/* ** This program demonstrates the conversion of cartesian coordinates ** */
/* ** to polar coordinates with mfloat numbers                          ** */

/* if you use the mfloat-library use 'polar.prj', otherwise dont use the */
/* project file */

#define use_mfloat

extern unsigned _stklen = 40000U;

#include <conio.h>
#include <stdio.h>
#include <iomanip.h>

#ifdef use_mfloat
#include "mfloat.cxx"                   // use the mfloat-library
#else
#include <math.h>                       // use the standard library
#define mfloat double                   // use 'normal' float
#endif

mfloat x, y, r, phi, xr, yr;

int main() {
  clrscr();
  cout << "          Conversion cartesian coorinates - polar coordinates\n";
  cout << "          ===================================================\n";
  cout << "\n\n";
  cout << "Cartesian coordinates:\n";
  do {
    cout << "x   = ";
    cin.clear();
    cin  >> x;
  } while (cin.rdstate() != ios::goodbit);
  do {
    cout << "y   = ";
    cin.clear();
    cin >> y;
  } while (cin.rdstate() != ios::goodbit);
  cout << "\nx   = " << setprecision(20) << x
       << "\ny   = " << setprecision(20) << y;

  r = hypot(x,y);
  phi = atan2(y,x);
  cout << "\n\nConversion to polar coordinates:"
       << "\nr   = " << setprecision(20) << r
       << "\nphi = " << setprecision(20) << phi;

  xr = r * cos(phi);
  yr = r * sin(phi);
  cout << "\n\nConversion back to cartesian coordinates:"
       << "\nx   = " << setprecision(20) << xr
       << "\ny   = " << setprecision(20) << yr
       << "\n";

  return(0);
}