comment ! 
FSU - ULTRA	The greatest random number generator that ever was
		or ever will be.  Way beyond Super-Duper.
		(Just kidding, but we think its a good one.)

Authors:	Arif Zaman (arif@stat.fsu.edu) and
		George Marsaglia (geo@stat.fsu.edu).

Date:		27 May 1992

Version:	1.05

Copyright:	To obtain permission to incorporate this program into
		any commercial product, please contact the authors at
		the e-mail address given above or at

		Department of Statistics and
		Supercomputer Computations Research Institute
		Florida State University
		Tallahassee, FL 32306.

See Also:	README		for a brief description
		ULTRA.DOC	for a detailed description

-----------------------------------------------------------------------
! 
;
; File:  ULTRX_FR.ASM (80386 IBM Fortran/2 calling conventions)
;
   DOSSEG
   .MODEL huge,fortran

;===== B: GLOBAL FUNCTIONS, SUBROUTINES and VARIABLES =================
;
	public  i31bit, i15bit, i7bit,  i1bit,  uni,    duni
	public  i32bit, i16bit, i8bit,  rinit,  vni,    dvni
	public	swbstate, swbsize

;===== D. MACRO DEFINITIONS ===========================================
;
; RinitProcStart should take two 32-bit arguments conx and shrx
;   and place them in eax and ebx.
;   es and ds should both point to the data segment.
;   conx must be odd (so we or with 1 just to make sure).
; FillProc
;   DS is already the data segment. ES should also be made the same.

EnterProcedure   macro
    mov  dx,DATA
    push ds
    mov  ds,dx
endm

ExitProcedure	macro
    pop ds
    ret
endm

Enter2arg	macro          ; fortran has call by reference.
    proc conx:dword, shrx:dword
    EnterProcedure
	mov  ax,ds
	mov  es,ax
	lds  si,ShrX
	lodsd                   ; load shrx in ebx
	mov  ebx,eax
	lds  si,ConX            ; and  conx in eax
	lodsd
	shl  eax,1
	or   al,1               ;  ( congx must be odd )
endm

Exit2arg     macro
    ExitProcedure
endm

EnterFill	macro
	mov	ax,ds
	mov	es,ax
endm

ExitFill	macro
	ret
endm

DwordFn macro
endm

WordFn  macro
endm

ByteFn  macro
    cbw                ; fortran doesn't have bytes so return integer*2
endm

RealFn  macro
endm
 
DoubleFn macro
endm
 
DATA SEGMENT WORD PUBLIC 'F@DATA'
  INCLUDE ULTRADAT.INC
DATA ENDS

F@ICODE SEGMENT WORD PUBLIC 'CODE'
ASSUME CS:F@ICODE, DS:DATA
  INCLUDE ULTRxCOD.INC
F@ICODE ENDS
END
