program LADemo;

{ --------------------------------------------------------------------------
                                  LADEMO.PAS

    ---> A  sample that shows how to use the LINALG unit to calculate
         eigenvalues,  eigenvectors,   characteristic   and   minimal
         polynomials of a given matrix.

         (C) 1990, 1992 by Lenimar N. Andrade (CCENDM03@BRUFPB.BITNET)

  -------------------------------------------------------------------------- }

{$E+,N+,M 65520, 0, 655200}

uses
  BasFPTC, LinAlg, Matrices, Equation, Crt;

procedure Pause;

var ch: char;

begin
  Writeln;
  Write('Press any key to continue.');
  ch := ReadKey;
  Writeln;
end;

var
  mat: matrix;
  p: polynomial;
  w: eigenvalues;
  min: minimal;
  rvec: RealEigenvector;
  i, j, k: byte;

begin
  Writeln;
  Writeln('CALCULATING EIGENVALUES, EIGENVECTORS, ... OF A MATRIX');
  Writeln;
  Write('Which is matrix''s order? ');
  Readln(mat.m);
  mat.n := mat.m;

  Writeln;
  Writeln('Enter the elements of matrix M:');
  Writeln;
  for i := 1 to mat.m do
  begin
    Write('Row ', i, ' : ');
    for j := 1 to mat.n do
      Read(mat.a[i, j])
  end;

  { CALCULATING THE CHARACTERISTIC POLYNOMIAL p OF mat }
  CharPoly(mat, p);
  Writeln;
  Writeln('Coefficients of characteristic polynomial: ');
  for i := p.degree downto 0 do
    Write(p.coef[i]:10:2);
  Writeln;
  Pause;

  { CALCULATING THE EIGENVALUES OF mat }
  CalcEigenvalues(p, w);
  if (w.QuantRe > 0) then
  begin
    Writeln;
    Writeln('Real eigenvalues:');
    for i := 1 to w.QuantRe do
      Writeln(w.EigenvalueRe[i].x :6:2, '   ---> multiplicity = ',
              w.EigenvalueRe[i].mult);
  end;
  if (w.QuantComplex > 0) then
  begin
    Writeln;
    Writeln('Complex eigenvalues:');
    for i := 1 to w.QuantComplex do
    begin
      Writeln(w.EigenvalueCx[i].a :6:2, ' + i ', w.EigenvalueCx[i].b :6:2,
              ' ---> multiplicity = ', w.EigenvalueCx[i].mult);
      Writeln(w.EigenvalueCx[i].a :6:2, ' - i ', w.EigenvalueCx[i].b :6:2,
              ' ---> multiplicity = ', w.EigenvalueCx[i].mult);
    end;
  end;
  Pause;

  { CALCULATING THE REAL EIGENVECTORS }
  Writeln;
  if (w.QuantRe > 0) then Writeln('Real eigenvectors:');
  for i := 1 to w.QuantRe do
  begin
    CalcEigenvectors(mat, w.EigenvalueRe[i].x, rvec);
    for j := 1 to rvec.dim do
    begin
      for k := 1 to rvec.n do
        Write(rvec.v[j, k] :6:2);
      Writeln;
    end;
    Writeln;
  end;
  Pause;

  { CALCULATING THE MINIMAL POLYNOMIAL }
  MinPoly(mat, w, min);
  Writeln;
  Writeln('The minimal polynomial is the product  of factors  of  form');
  Writeln('       n');
  Writeln('(x - r) , where each r and its respective n is listed below:');
  Writeln;
  for i := 1 to w.QuantRe do
    Writeln('r = ', w.EigenvalueRe[i].x :6:2, ' ---> n = ', min.expo[i]);
  for i := 1 to w.QuantComplex do
  begin
    Writeln('r = ', w.EigenvalueCx[i].a :6:2, ' + i ',
                     w.EigenvalueCx[i].b :6:2, ' ---> n = ', min.expo[i]);
    Writeln('r = ', w.EigenvalueCx[i].a :6:2, ' - i ',
                     w.EigenvalueCx[i].b :6:2, ' ---> n = ', min.expo[i]);
  end;

end.
