; ENGLISH.LEX  2-May-91

; Copyright (c) 1991 by the Summer Institute of Linguistics
; for academic use only

; NOTE: this version of the English lexicon differs substantially from
; that supplied on the original PC-KIMMO release diskette.

ALTERNATION Begin	       PREFIX1 PREP PRONOUN CONJ DET
	       INTJ CARDINALS ORDINALS
ALTERNATION Prefix1	       PREFIX2
ALTERNATION Prefix2	       NOUN ADJ VERB ADV

ALTERNATION N_Root         N_SUFFIX1A
ALTERNATION N_Suffix1a     N_SUFFIX1B
ALTERNATION N_Suffix1b     N_SUFFIX2 
ALTERNATION N_Suffix2      N_SUFFIX3
ALTERNATION N_Infl	       NUMBER
ALTERNATION Number	       GENITIVE

ALTERNATION Adj_Root       ADJ_SUFFIX1
ALTERNATION Adj_Suffix1    ADJ_SUFFIX2
ALTERNATION Adj_Suffix2    ADJ_SUFFIX3
ALTERNATION Adj_Infl       ADJ_INFL

ALTERNATION V_Root1	       V_INFL
ALTERNATION V_Root2	       V_SUFFIX1
ALTERNATION V_Suffix1      V_SUFFIX2
ALTERNATION V_Infl	       V_INFL

ALTERNATION Adv_Root       End
ALTERNATION Adv_Suffix     End

ALTERNATION Pron	       End
ALTERNATION Prep	       End
ALTERNATION Conj	       End
ALTERNATION Det	       End
ALTERNATION Intj	       End
ALTERNATION Foreign	       End
ALTERNATION Cardinal       ORDZR
ALTERNATION Ordinal	       End

ALTERNATION End	       End

INCLUDE noun.lex	; file containing noun roots
INCLUDE adj.lex	; file containing adjective roots
INCLUDE verb.lex	; file containing verb roots
INCLUDE adv.lex     ; file containing adverb roots
INCLUDE minor.lex	; file containing minor word classes

LEXICON INITIAL
0	Begin	""

LEXICON PREFIX1
; the following prefixes do not change the class of the word
non-+	Prefix1	"NEG3+"
de-+	Prefix1	"REV2+"
pseudo-+	Prefix1	"PEJ3+"
arch-+	Prefix1	"DEG1+" ; degree
co-+	Prefix1	"DEG2+"
hyper+	Prefix1	"DEG3+"
mini-+	Prefix1	"DEG4+"
maxi-+	Prefix1	"DEG5+"
out+	Prefix1	"DEG6+"
over+	Prefix1	"DEG7+"
sub+	Prefix1	"DEG8/LOC1+"
super-+	Prefix1	"DEG9/LOC2+"
sur+	Prefix1	"DEG10+"
ultra-+	Prefix1	"DEG11+"
under+	Prefix1	"DEG12+"
micro+	Prefix1	"DEG13+"
macro+	Prefix1	"DEG14+"
anti-+	Prefix1	"ORI1+" ; orientation
contra+	Prefix1	"ORI2+"
conter-+	Prefix1	"ORI3+"
pro-+	Prefix1	"ORI4+"
fore+	Prefix1	"LOC3+" ;location
inter-+	Prefix1	"LOC4+"
trans-+	Prefix1	"LOC5+"
extra-+	Prefix1	"LOC6+"
intra-+	Prefix1	"LOC7+"
mid-+	Prefix1	"LOC9+"
circum+	Prefix1	"LOC10+"
ante-+	Prefix1	"ORD6+"
step-+	Prefix1	"ORD7+"
bio-+	Prefix1	"COM+"
self-+	Prefix1	"COM+"
0	Prefix1	""

LEXICON PREFIX2
;a+	Prefix2	"NEG1+" ; negative
in+	Prefix2	"NEG2+"
un+	Prefix2	"NEG4/REV1+"
;ab+	Prefix2	"NEG5+"
dis+	Prefix2	"REV2+" ;reversive
mal+	Prefix2	"PEJ1+" ; pejorative
mis+	Prefix2	"PEJ2+"
;cis+	Prefix2	"LOC8+" ;rare
ex-+	Prefix2	"ORD1+" ; time and order
fore+	Prefix2	"ORD2+"
post-+	Prefix2	"ORD3+"
pre-+	Prefix2	"ORD4+"
re-+	Prefix2	"ORD5+"
bi+	Prefix2	"NUM1+" ;number
di+	Prefix2	"NUM2+"
poly-+	Prefix2	"NUM3+"
multi-+	Prefix2	"NUM4+"
semi-+	Prefix2	"NUM5+"
demi-+	Prefix2	"NUM6+"
hemi-+	Prefix2	"NUM7+"
tri-+	Prefix2	"NUM8+"
uni-+	Prefix2	"NUM9+"
mono-+	Prefix2	"NUM10+"
auto+	Prefix2	"NEO1+" ; neo-classical
neo-+	Prefix2	"NEO2+"
paleo+	Prefix2	"NEO3+"
pan-+	Prefix2	"NEO4+"
proto-+	Prefix2	"NEO5+"
tele+	Prefix2	"NEO6+"
vice-+	Prefix2	"NEO7+"

; the following change the class of the word
;a+	Prefix2	"ADJR1+" ;unproductive
;be+	Prefix2	"ADJR2+" ;unproductive
en+	Prefix2	"VBLR1+"
em+	Prefix2	"VBLR2+"
0	Prefix2	""

LEXICON N_SUFFIX1A
; noun suffixes
; denominal nouns
+age	N_Suffix1a	"+NOMR1"
+dom	N_Suffix1a	"+NOMR2"
+ery	N_Suffix1a	"+NOMR3a"
+ry	N_Suffix1a	"+NOMR3b"
+ful	N_Suffix1a	"+NOMR5"
+hood	N_Suffix1a	"+NOMR6"
;+ing	N_Suffix1a	"+NOMR7"
+ship	N_Suffix1a	"+NOMR9"
+eer	N_Suffix1a	"+NOMR10"
;+er	N_Suffix1a	"+NOMR11" ;causes spurious parses
+ess	N_Suffix1a	"+NOMR12"
+ette	N_Suffix1a	"+NOMR13"
+let	N_Suffix1a	"+NOMR14"
+ling	N_Suffix1a	"+NOMR15"
+ster	N_Suffix1a	"+NOMR16"
+ist	N_Suffix1a	"+NOMR31"
+ite	N_Suffix1a	"+NOMR32"
+ie	N_Suffix1a	"+NOMR33"
+iana	N_Suffix1a	"+NOMR36"
+scape	N_Suffix1a	"+NOMR37"
;+i	N_Suffix1a	"+NOMR43" ; only after names
+nik	N_Suffix1a	"+NOMR44"
+cy	N_Suffix1a	"+NOMR40"
0	N_Suffix1a	""

LEXICON N_SUFFIX1B
; noun suffixes
; denominal nouns
+ism	N_Suffix1b	"+NOMR8"
+ry	N_Suffix1b	"+NOMR3b"
0	N_Suffix1b	""


LEXICON N_SUFFIX2
; adjective suffixes
; denominal adjectives
+ese	Adj_Root	"+ADJR3"
+an	Adj_Root	"+ADJR4a"
+ian	Adj_Root	"+ADJR4b"
+ean	Adj_Root	"+ADJR4c"
;+ed	Adj_Root	"+ADJR8"
+ful	Adj_Root	"+ADJR9"
+ish	Adj_Root	"+ADJR10"
+less	Adj_Root	"+ADJR11"
+like	Adj_Root	"+ADJR12"
+ly	Adj_Root	"+ADJR13"
+y	Adj_Root	"+ADJR14"
+some	Adj_Root	"+ADJR15"
+worthy	Adj_Root	"+ADJR16"
; foreign
+al	Adj_Root	"+ADJR17a"
+ial	Adj_Root	"+ADJR17b"
+ual	Adj_Root	"+ADJR17c"
;+en	Adj_Root	"+ADJR18" ;unproductive
+esque	Adj_Root	"+ADJR19"
+ic	Adj_Root	"+ADJR20"
+ical	Adj_Root	"+ADJR20/17"
+ous	Adj_Root	"+ADJR21a"
+ious	Adj_Root	"+ADJR21b"
+ary	Adj_Root	"+ADJR22"
;+ory	Adj_Root	"+ADJR23" ;unproductive
;+ate	Adj_Root	"+ADJR24" ;unproductive
;+ar	Adj_Root	"+ADJR31a" ;unproductive
;+ular	Adj_Root	"+ADJR31b" ;unproductive
0	N_Suffix2	""

LEXICON N_SUFFIX3
; verb suffixes
; denominal verbs
+ate	V_Suffix1	"+VBLR3"
+ify	V_Suffix1	"+VBLR5"
;+fy	V_Suffix1	"+VBLR5"
+ize	V_Suffix1	"+VBLR6"
;+ise	V_Suffix1	"+VBLR7"; British
0	N_Infl	""

LEXICON V_SUFFIX1
; noun suffixes
; deverbal nouns
+ery	N_Suffix1a	"+NOMR3a"
+ry	N_Suffix1a	"+NOMR3b"
+ant	N_Root	"+NOMR17"
+ee	N_Root	"+NOMR18"
+er	N_Root	"+NOMR19"
+or	N_Root	"+NOMR20"
+age	N_Root	"+NOMR21"
+al	N_Root	"+NOMR22"
+ation	N_Root	"+NOMR23a"
+ition	N_Root	"+NOMR23b"
+tion	N_Root	"+NOMR23c"
+ion	N_Root	"+NOMR23d"
;+ing	N_Root	"+NOMR24"
+ment	N_Root	"+NOMR25"
+ance	N_Root	"+NOMR26a"
+ence	N_Root	"+NOMR26b"
;+ory	N_Root	"+NOMR34" ;unproductive
;+y	N_Root	"+NOMR35" ;unproductive
+ure	N_Root	"+NOMR38"
;+ary	N_Root	"+NOMR39" ;unproductive
;+ate	N_Root	"+NOMR46" ;also denominal
0	V_Suffix1	""

LEXICON V_SUFFIX2
; adjective suffixes
; deverbal adjectives
;+ate	Adj_Root	"+ADJR24" ;unproductive
+able	Adj_Root	"+ADJR25a"
+ible	Adj_Root	"+ADJR25b"
+ive	Adj_Root	"+ADJR26"
;+ant	Adj_Root	"+ADJR27a" ;unproductive
+ent	Adj_Root	"+ADJR27b"
+ory	Adj_Root	"+ADJR28a"
+atory	Adj_Root	"+ADJR28b"
;+al	Adj_Root	"+ADJR17a" ;infrequent
+ous	Adj_Root	"+ADJR21a"
+ious	Adj_Root	"+ADJR21b"
+y	Adj_Root	"+ADJR14"
;+en	Adj_Root	"+ADJR30" ;unproductive
0	V_Infl	""

LEXICON ADJ_SUFFIX1
; noun suffixes
; de-adjectival nouns
+ee	N_Root	"+NOMR18"
+ation	N_Root	"+NOMR23a"
+ition	N_Root	"+NOMR23b"
+tion	N_Root	"+NOMR23c"
+ion	N_Root	"+NOMR23d"
+ity	N_Root	"+NOMR26a"
+ty	N_Root	"+NOMR26b"
+ness	N_Root	"+NOMR27"
+ese	N_Root	"+NOMR28"
;+ian	N_Root	"+NOMR29" ;see ADJR4
;+an	N_Root	"+NOMR30" ;see ADJR4
+ist	N_Root	"+NOMR31"
+ism	N_Root	"+NOMR8"
+ite	N_Root	"+NOMR32"
+cy	N_Root	"+NOMR40"
;+ce	N_Root	"+NOMR41"
;+th	N_Root	"+NOMR42" ;unproductive
+ery	N_Root	"+NOMR3"
0	Adj_Suffix1	""

LEXICON ADJ_SUFFIX2
; verb suffixes
; de-adjectival verbs
+ate	V_Root2	"+VBLR3"
+en	V_Root2	"+VBLR4"
+ify	V_Root2	"+VBLR5"; also +fy
+ize	V_Root2	"+VBLR6"
;+ise	V_Root2	"+VBLR7"; British
0	Adj_Suffix2	""

LEXICON ADJ_SUFFIX3
; adverb suffixes
; de-adjectival adverbs
+ly	Adv_Suffix	"+ADVR1"
+-ward	Adv_Suffix	"+ADVR2"
+-wards	Adv_Suffix	"+ADVR3"
+-wise	Adv_Suffix	"+ADVR4"
;+-fold	Adv_Suffix	"+ADVR5"
;+-way	Adv_Suffix	"+ADVR5"
;+-ways	Adv_Suffix	"+ADVR5"
;+-fashion	Adv_Suffix	"+ADVR5"
0	Adj_Infl	""

LEXICON NUMBER
+s	Number	"+PL"
0	Number	""

LEXICON GENITIVE
+'s	End	"+GEN"
0	End	""

LEXICON ADJ_INFL
+er	End	"+COMP"
+est	End	"+SUPER"
0	End	""

LEXICON V_INFL
+ed	End	"+PAST/PRTC"
;+ed	End	"+PRTC"
+en	End	"+PRTC"
+ing	End	"+PROG"
+s	End	"+3SG"
;+eth	End	"+3SG" ;archaic
0	End	""

LEXICON End
; contractions, uncomment to activate
;+'d	#	"+V(would)"
;+'ll	#	"+V(will)"
;+'s	#	"+V(have)"
;+'s	#	"+V(be)"
;+'ve	#	"+V(have)"
; compounds, uncomment to activate
;-	Begin	"-"
0	#	""

END
