/*
 * cmdcfg.c -- a simple keymap configuration utility for cmdedit.com
 *
 * Version 1.0
 *
 * Author:  Wayne Davison (davison@borland.com)
 *
 * Compiler used: Borland C
 */

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <io.h>

#define BUF_SIZE (32 * 1024)

char search_text[] = "CMDEDIT key map";

void print_char(int ch, char *str);

int
main(int argc, char *argv[])
{
    int fn;
    char *buf, *cp;
    unsigned size, left;
    struct ftime ft;

    if (argc != 2) {
	fprintf(stderr, "Usage: cmdcfg <filename>\n");
	exit(1);
    }
    if ((fn = open(argv[1], O_RDWR | O_BINARY)) == -1) {
	fprintf(stderr, "Unable to open %s.\n", argv[1]);
	exit(1);
    }
    getftime(fn, &ft);
    if ((buf = malloc(BUF_SIZE)) == NULL) {
	fprintf(stderr, "Out of memory.\n");
	exit(1);
    }
    size = read(fn, buf, BUF_SIZE);

    for (cp = buf, left = size; left; cp++, left--) {
	if (*cp == *search_text && !strcmp(cp, search_text)) {
	    int i;
	    int ch;
	    short *sp;
	    int changed = 0;

	    cp += sizeof search_text;
	    sp = (short *)cp;
	    printf("Press <space> or the key that should be generated for the listed key.\n");
	    for (i = 0; i < 32; i++) {
		print_char(i, " (");
		print_char(*sp, "): ");
		ch = getch();
                if (ch == '\0')
                    ch = getch() + 256;
                if (ch == 256 + 3)
                    ch = 0;
		if (ch != ' ' && *sp != ch) {
		    *sp = ch;
		    changed = 1;
		}
		print_char(*sp++, "\n");
	    }
	    if (changed) {
		lseek(fn, 0L, 0);
		write(fn, buf, size);
	    }
	    break;
	}
    }
    setftime(fn, &ft);
    close(fn);
    if (!left) {
	fprintf(stderr, "Couldn't find key map table.\n");
	exit(1);
    }
    return 0;
}

void
print_char(int ch, char *str)
{
    if (ch < 32) {
	putchar('^');
	putchar(ch + '@');
        if (ch == 9)
            fputs("/Tab", stdout);
        else if (ch == 13)
            fputs("/Enter", stdout);
        else if (ch == 27)
            fputs("/Esc", stdout);
    }
    else if (ch == 127) {
        putchar('^');
        putchar('?');
    }
    else if (ch > 127) {
        switch (ch) {
        case 327:
            fputs("Home", stdout);
            break;
        case 328:
            fputs("Up", stdout);
            break;
        case 331:
            fputs("Left", stdout);
            break;
        case 333:
            fputs("Right", stdout);
            break;
        case 335:
            fputs("End", stdout);
            break;
        case 336:
            fputs("Down", stdout);
            break;
        case 338:
            fputs("Ins", stdout);
            break;
        case 339:
            fputs("Del", stdout);
            break;
        case 371:
            fputs("^Left", stdout);
            break;
        case 372:
            fputs("^Right", stdout);
            break;
        default:
            printf("?%d?", ch);
            break;
        }
    }
    else
	putchar(ch);
    fputs(str, stdout);
}
