	TITLE	C_CHAR
	page	,132

_TEXT      SEGMENT  BYTE PUBLIC 'CODE'
	ASSUME  cs: _TEXT

	ORG	100H

	public	CCHAR, Vector, Catch, Install
	public	TempA, TempD, TempF

CCHAR	PROC	FAR
	jmp	Install

Catch:	pushf
	mov	WORD PTR cs:[TempA], ax
	pop	ax
	mov	WORD PTR cs:[TempF], ax
	mov	ax, ds
	mov	WORD PTR cs:[TempD], ax

	in	al, 60h			; Get the character code

	push	ds			; Save everything for later
	push	bx
	push	ax
	mov	ax, 0B800h		; Display in lower right-hand corner
	mov	ds, ax
	mov	bx, 24 * 160 + 78 * 2

	pop	ax			; Get a copy of the character,
	push	ax
	call	makehex			;  convert low nybble to ASCII hex,
	mov	byte ptr [ bx + 2 ], al	;  and output it.

	pop	ax			; Do the same for the upper nybble
	push	ax
	shr	al, 1
	shr	al, 1
	shr	al, 1
	shr	al, 1
	call	makehex
	mov	byte ptr [ bx + 0 ], al

	pop	ax			; Recover our senses
	pop	bx
	pop	ds

GoVect:	mov	ax, WORD PTR cs:[Vector+2]
	push	ax
	mov	ax, WORD PTR cs:[Vector]
	push	ax
	mov	ax, WORD PTR cs:[TempD]
	mov	ds,ax
	mov	ax, WORD PTR cs:[TempF]
	push	ax
	popf
	mov	ax, WORD PTR cs:[TempA]
	ret				; (Far return to original vector)

TempA:	dw	0
TempD:	dw	0
TempF:	dw	0
Vector:	dd	0
Char:	dw	0

makehex:
	and	al, 0Fh			; Mask off the nybble
	add	al, '0'			; Convert to ASCII
	cmp	al, '9'			; In the A-F range?
	jle	makedone		; Nope, we're done
	add	al, 7			; Yes, convert to letters
makedone:
	db	0C3h			; (short return)

Install:
	push	cs			; Establish segment registers
	pop	es
	sub	ax, ax
	mov	ds, ax
	mov	di, OFFSET Vector
	mov	si, 9*4
	movsw				; Copy the current vector
	movsw

	mov	ax,cs			; Install my cs
	mov	ds:[9*4+2],ax
	mov	ax, OFFSET Catch	;  and IP
	mov	ds:[9*4], ax

	push	cs
	pop	ds

	mov	dx, OFFSET Message	; Tell them what we've done
	mov	ah,9
	int	21h

	mov	ax, WORD PTR cs:[2Eh]	; Free up environment
	mov	es, ax
	mov	ax, 4900H
	int	21h

	mov	dx, OFFSET Install	; Calculate # of paragraphs
	add	dx, 15			; Minus PSP, round up
	rcr	dx, 1
	sar	dx, 1
	sar	dx, 1
	sar	dx, 1

	mov	ax,3100h
	int	21h			; Terminate and stay resident
	int	20h			; Just in case

Message:
	db	"CCHAR installed. Reboot to remove."
	db	13,10,"$"

My_DS:	dw	0

CCHAR	ENDP

_TEXT	ENDS
END	CCHAR
