#ifndef	_USOCK_H
#define	_USOCK_H

#ifndef	_MBUF_H
#include "mbuf.h"
#endif

#ifndef	_LZW_H
#include "lzw.h"
#endif

#ifndef _PROC_H
#include "proc.h"
#endif

#ifndef _TCP_H
#include "tcp.h"
#endif

#ifndef _UDP_H
#include "udp.h"
#endif

#ifndef _IP_H
#include "ip.h"
#endif

#ifndef _NETROM_H
#include "netrom.h"
#endif

#ifndef _SOCKADDR_H
#include "sockaddr.h"
#endif

struct loc {
	struct usock *peer;
	struct mbuf *q;
	int hiwat;		/* Flow control point */
	int flags;
#define	LOC_SHUTDOWN	1
};
#define	NULLLOC	(struct loc *)0
#define	LOCDFLOW	5	/* dgram socket flow-control point, packets */
#define	LOCSFLOW	2048	/* stream socket flow control point, bytes */
#define	SOCKBASE	128	/* Start of socket indexes */

union sp {
        struct sockaddr *sa;
        struct sockaddr_in *in;
        struct sockaddr_ax *ax;
        struct sockaddr_nr *nr;
        char *p;
};
struct socklink {
	int type;		/* Socket type */
	int (*socket) __ARGS((struct usock *,int));
	int (*bind) __ARGS((struct usock *));
	int (*listen) __ARGS((struct usock *,int));
	int (*connect) __ARGS((struct usock *));
	int accept;
	int (*recv) __ARGS((struct usock *,struct mbuf **,char *,int *));
	int (*send) __ARGS((struct usock *,struct mbuf *,char *to));
	int (*qlen) __ARGS((struct usock *,int));
	int (*kick) __ARGS((struct usock *));
	int (*shut) __ARGS((struct usock *,int));
	int (*close) __ARGS((struct usock *));
	int (*check) __ARGS((char *,int));
	char **error;
	char *(*state) __ARGS((struct usock *));
	int (*status) __ARGS((struct usock *));
	char *eol;
};
extern struct socklink Socklink[];
union cb {
	struct tcb *tcb;
	struct ax25_cb *ax25;
	struct udp_cb *udp;
	struct raw_ip *rip;
	struct raw_nr *rnr;
	struct nr4cb *nr4;
	struct loc *local;
	char *p;
};
/* User sockets */
struct usock {
	unsigned index;
	struct proc *owner;
	int refcnt;
	char noblock;
	char type;
#define	NOTUSED			0
#define	TYPE_TCP		1
#define	TYPE_UDP		2
#define	TYPE_AX25I		3
#define	TYPE_AX25UI		4
#define TYPE_RAW		5
#define TYPE_NETROML3		6
#define TYPE_NETROML4		7
#define	TYPE_LOCAL_STREAM	8
#define	TYPE_LOCAL_DGRAM	9
	struct socklink *sp;
	int rdysock;
	union cb cb;
	char *name;
	int namelen;
	char *peername;
	int peernamelen;
	char errcodes[4];	/* Protocol-specific error codes */
	char tos;		/* Internet type-of-service */
	int flag;		/* Mode flags, defined in socket.h */
};
#define	NULLUSOCK	((struct usock *)0)

extern char *(*Psock[]) __ARGS((struct sockaddr *));
extern char Badsocket[];
extern char *Socktypes[];
extern struct usock **Usock;
extern unsigned Nsock;
extern int16 Lport;

struct usock *itop __ARGS((int s));
void st_garbage __ARGS((int red));

/* In locsocket.c: */
int so_los __ARGS((struct usock *up,int protocol));
int so_lod __ARGS((struct usock *up,int protocol));
int so_lo_recv __ARGS((struct usock *up,struct mbuf **bpp,char *from,
	int *fromlen));
int so_los_send __ARGS((struct usock *up,struct mbuf *bp,char *to));
int so_lod_send __ARGS((struct usock *up,struct mbuf *bp,char *to));
int so_lod_qlen __ARGS((struct usock *up,int rtx));
int so_los_qlen __ARGS((struct usock *up,int rtx));
int so_loc_shut __ARGS((struct usock *up,int how));
int so_loc_close __ARGS((struct usock *up));
char *lopsocket __ARGS((struct sockaddr *p));
int so_loc_stat __ARGS((struct usock *up));

#endif /* _USOCK_H */
