#ifndef	_STDIO_H
#define	_STDIO_H

#ifndef	_GLOBAL_H
#include "global.h"
#endif

#define	EOL_LEN	3

struct _file{
	unsigned cookie;		/* Detect bogus file pointers */
#define	_COOKIE	0xdead
	int refcnt;
	struct _file *prev;
	struct _file *next;

	/* These two entries used only when type == _FL_FILE */
	int fd;			/* File descriptor or socket index */
	long offset;		/* Seek offset */

	int type;
#define	_FL_SOCK	1	/* Associated with network socket */
#define	_FL_FILE	2	/* Associated with file */
#define	_FL_DISPLAY	3	/* Associated with display driver */
#define	_FL_PIPE	4	/* Pipe mode */

	int bufmode;		/* Output buffering mode */
#define	_IOFBF	1		/* Full buffering */
#define	_IOLBF	2		/* Line buffering */
#define	_IONBF	3		/* No buffering */

	int flags;
#define	_FL_ERR		0x1	/* Error on stream */
#define	_FL_EOF		0x2	/* EOF seen */
#define	_FL_ASCII	0x4	/* Ascii (newline translate) mode */
#define	_FL_APPEND	0x8	/* Always seek to end before writing */
#define	_FL_TMP		0x10	/* Delete on close */
	struct mbuf *obuf;	/* Output buffer */
	struct mbuf *ibuf;	/* Input buffer */
	char eol[EOL_LEN];	/* Text mode end-of-line sequence, if any */
	int bufsize;		/* Size of buffer to use */
	void *ptr;		/* File name or display pointer */
};

typedef struct _file FILE;

#ifndef _SIZE_T
#define _SIZE_T
typedef unsigned size_t;
#endif

#undef	NULL
#define	NULL	(void *)0
#define	BUFSIZ	1024
#define	EOF	(-1)
#define	L_tmpnam	13

#define	SEEK_SET	0
#define	SEEK_CUR	1
#define	SEEK_END	2

#define	stdout	Curproc->output
#define	stdin	Curproc->input
#define	stderr	Curproc->output

#define	STREAM_BINARY	0
#define	STREAM_ASCII	1

int close __ARGS((int fd));
FILE *displayopen __ARGS((char *mode,int noscrol));
int fclose __ARGS((FILE *fp));
void fcloseall __ARGS((void));
FILE *fdopen __ARGS((int handle,char *mode));
FILE *fdup __ARGS((FILE *fp));
int fflush __ARGS((FILE *fp));
int fgetc __ARGS((FILE *fp));
int _fgetc __ARGS((FILE *fp));
char *fgets __ARGS((char *buf,int len,FILE *fp));
void flushall __ARGS((void));
int fmode  __ARGS((FILE *fp,int mode));
char *fpname __ARGS((FILE *fp));
int fprintf __ARGS((FILE *fp,char *fmt,...));
int fputc __ARGS((int c,FILE *fp));
int fputs __ARGS((char *buf,FILE *fp));
size_t fread __ARGS((void *ptr,size_t size,size_t n,FILE *fp));
FILE *freopen __ARGS((char *name,char *mode,FILE *fp));
int fseek __ARGS((FILE *fp,long offset,int whence));
long ftell __ARGS((FILE *fp));
size_t fwrite __ARGS((void *ptr,size_t size,size_t n,FILE *fp));
char *gets __ARGS((char *s));
void perror __ARGS((char *s));
FILE *pipeopen __ARGS((void));
int printf __ARGS((char *fmt,...));
int puts __ARGS((char *s));
int rename __ARGS((const char *,const char *));
void setbuf __ARGS((FILE *fp,char *buf));
int seteol __ARGS((FILE *fp,char *seq));
int setvbuf __ARGS((FILE *fp,char *buf,int type,int size));
int sprintf __ARGS((char *,char *, ...));
int sscanf __ARGS((char *,char *,...));	/* From regular library */
FILE *tmpfile __ARGS((void));
char *tmpnam __ARGS((char *));	/* From regular library */
int ungetc __ARGS((int c,FILE *fp));
int unlink __ARGS((const char *));	/* From regular library */
int vfprintf __ARGS((FILE *fp,char *fmt, void *args));
int vprintf __ARGS((char *fmt, void *args));
int vsprintf __ARGS((char *,char *,void *));

/* Macros */
#define	feof(fp)	((fp)->flags & _FL_EOF)
#define ferror(fp)	((fp)->flags & _FL_ERR)
#define	fileno(fp)	((fp) != NULLFILE ? (fp)->fd : -1)
#define fopen(s,m)	(freopen((s),(m),NULLFILE))
#define	putc(c,fp)	(fputc((c),(fp)))
#define	getc(fp)	(fgetc((fp)))
#define	getchar()	(getc(stdin))
#define	clearerr(fp)	((fp)->flags &= ~(_FL_EOF|_FL_ERR))
#define rewind(fp)	((void)fseek((fp),0L,SEEK_SET),clearerr((fp)))
#define	putchar(c)	(putc((c),stdout))

#endif /* _STDIO_H */
