/* Socket status display code
 * Copyright 1991 Phil Karn, KA9Q
 */
#include <stdio.h>
#include "global.h"
#include "mbuf.h"
#include "proc.h"
#include "lzw.h"
#include "usock.h"
#include "socket.h"
#include "commands.h"

/* Socket status display command */
int
dosock(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	register struct usock *up;
	int s,i;
	struct sockaddr fsock;
	struct socklink *sp;
	char *cp;

	if(argc < 2){
		printf("S#  Type    PCB      Remote socket         Owner\n");
		for(s=Nfiles;s<Nsock+Nfiles;s++){
			up = itop(s);
			if(up == NULLUSOCK)
				continue;

			i = sizeof(fsock);
			if(getpeername(s,(char *)&fsock,&i) == 0 && i != 0)
				cp = psocket(&fsock);
			else
				cp = "";

			printf("%3d %-8s%-8lx %-22s%-8lx %-10s\n",
			 s,Socktypes[up->type],ptol(up->cb.p),cp,
			 ptol(up->owner),up->owner->name);
		}
		return 0;
	}
	s = atoi(argv[1]);
	if(s < Nfiles || s >= Nsock+Nfiles){
		printf("Number out of range\n");
		return 1;
	}
	up = itop(s);
	if(up == NULLUSOCK){
		printf("Socket not in use\n");
		return 0;
	}
	sp = up->sp;
	printf("%s %lx\n",Socktypes[up->type],ptol(up->cb.p));
	if(up->cb.p == NULL)
		return 0;
	if(sp->status != NULLFP)
		(*sp->status)(up);
	return 0;	
}

