#ifndef	_SESSION_H
#define	_SESSION_H

#include <stdio.h>

#ifndef	_GLOBAL_H
#include "global.h"
#endif

#ifndef	_PROC_H
#include "proc.h"
#endif

#ifndef _HARDWARE_H
#include "hardware.h"
#endif

#ifndef	_FTPCLI_H
#include "ftpcli.h"
#endif

#ifndef	_TELNET_H
#include "telnet.h"
#endif

struct ttystate {
	char *line;		/* Line buffer */
	char *lp;		/* Pointer into same */
	int echo;		/* Keyboard local echoing? */
	int edit;		/* Local editing? */
	int crnl;		/* Translate cr to lf? */
};

/* Session control structure; only one entry is used at a time */
struct session {
	unsigned index;
	int type;
#define	TELNET	1
#define	FTP	2
#define	AX25TNC	3
#define	FINGER	4
#define	PING	5
#define NRSESSION 6
#define	COMMAND	7
#define	VIEW	8
#define	HOP	9
#define	TIP	10
#define	PPPPASS	11
#define DIAL	12
#define DQUERY	13
#define DCLIST	14
#define	ITRACE	15

	char *name;	/* Name of remote host */
	union {
		struct ftpcli *ftp;
		struct telnet *telnet;
		void *p;
	} cb;
	struct proc *proc;	/* Primary session process (e.g., tn recv) */
	struct proc *proc1;	/* Secondary session process (e.g., tn xmit) */
	struct proc *proc2;	/* Tertiary session process (e.g., upload) */
	FILE *network;		/* Primary network socket (control for FTP) */
	FILE *record;		/* Receive record file */
	FILE *upload;		/* Send file */
	struct ttystate ttystate;
	FILE *input;		/* Input stream */
	FILE *output;		/* Output stream */
	int (*ctlproc) __ARGS((int));	/* Function to hand keyboard ctls */
};
#define	NULLSESSION	(struct session *)0

extern char *Sestypes[];
extern unsigned Nsessions;		/* Maximum number of sessions */
extern struct session **Sessions;	/* Session descriptors themselves */
extern struct session *Current;		/* Always points to current session */
extern struct session *Lastcurr;	/* Last non-command session */
extern struct session *Command;		/* Pointer to command session */

/* In session.c: */
void freesession __ARGS((struct session *sp));
int keywait __ARGS((char *prompt,int flush));
struct session *sessptr __ARGS((char *cp));
struct session *newsession __ARGS((char *name,int type,int makecur));
void sesflush __ARGS((void));
void upload __ARGS((int unused,void *sp1,void *p));

extern int16 Lport;
#define	ALERT_EOF	1

#endif  /* _SESSION_H */
