#ifndef _QTSO_H
#define _QTSO_H
#ifndef	_GLOBAL_H
#include "global.h"
#endif

#ifndef	_MBUF_H
#include "mbuf.h"
#endif

#ifndef	_IFACE_H
#include "iface.h"
#endif

/* PPP definitions */
#define	PPP_ALLOC	128	/* mbuf allocation increment */

/* HDLC envelope constants */
#define HDLC_ENVLEN	8	/* Max bytes for HDLC envelope (outgoing) */

#define HDLC_FLAG	0x7e	/* HDLC async start/stop flag */
#define HDLC_ESC_ASYNC	0x7d	/* HDLC transparency escape flag for async */
#define HDLC_ESC_COMPL	0x20	/* HDLC transparency bit complement mask */

#define HDLC_FCS_START	0xffff	/* Starting bit string for FCS calculation */
#define HDLC_FCS_FINAL	0xf0b8	/* FCS when summed over frame and sender FCS */

#define PPP_ESCAPED	0x01
#define PPP_TOSS	0x02

struct qtso {
	struct qtso *next;
	int32 sendframes;
	int32 aborts;
	int32 crcerrs;
	int32 goodframes;
	struct iface *iface;
};
#define	NULLQTSO	(struct qtso *)0

extern struct qtso *Qtso;

/* In qtso.c: */
int qtso_free __ARGS((struct iface *ifp));
int qtso_send __ARGS((struct mbuf *data,struct iface *iface,int32 gateway,
	int tos));
int qtso_output __ARGS((struct iface *iface, char dest[], char source[],
	int16 type, struct mbuf *data));
void qtso_recv __ARGS((int dev,void *p1,void *p2));

int qtso_init __ARGS((struct iface *iface,int vj));
void qtso_proc __ARGS((struct iface *iface, struct mbuf *bp));

#endif	/* _PPP_H */

