#ifndef	_PC_H
#define	_PC_H
#define _HARDWARE_H

#ifndef	_GLOBAL_H
#include "global.h"
#endif

#ifndef _SESSION_H
#include "session.h"
#endif

#define	NSW	10	/* Number of stopwatch "memories" */

struct stopwatch {
	long calls;
	int16 maxval;
	int16 minval;
};
/* Macros for disabling and restoring interrupts inline.
 * Since the previous flags are saved on the stack, these macros
 * MUST be called in pairs within a single function.
 */
#define	DISABLE() {asm pushf;asm cli;}
#define	RESTORE() {asm popf;}

extern struct stopwatch Sw[];
extern int16 Intstk[];	/* Interrupt stack defined in pcgen.asm */
extern int16 *Stktop;	/* Top of interrupt stack */
extern void (*Shutdown[])();	/* List of functions to call at shutdown */
extern int Mtasker;	/* Type of multitasker, if any */

/* In n8250.c: */
void asytimer __ARGS((void));

/* In dos.c: */
extern unsigned *Refcnt;
int _creat __ARGS((const char *file,int mode));
int _open __ARGS((const char *file,int mode));
int dup __ARGS((int fd));
int _close __ARGS((int fd));
int _read __ARGS((int fd,void *buf,unsigned cnt));
int _write __ARGS((int fd,void *buf,unsigned cnt));
long _lseek __ARGS((int fd,long offset,int whence));

/* In scc.c: */
void scctimer __ARGS((void));
void sccstop __ARGS((void));

/* In pc.c: */
long bioscnt __ARGS((void));
void clrbit __ARGS((unsigned port,char bits));
void ctick __ARGS((void));
int32 divrem __ARGS((int32 dividend,int16 divisor));
INTERRUPT  (*getirq __ARGS((unsigned int)) ) __ARGS((void));
void freescreen __ARGS((struct session *sp));
int getmask __ARGS((unsigned irq));
int intcontext __ARGS((void));
void ioinit __ARGS((void));
void iostop __ARGS((void));
void kbint __ARGS((void));
int kbread __ARGS((void));
int maskoff __ARGS((unsigned irq));
int maskon __ARGS((unsigned irq));
void newscreen __ARGS((struct session *sp));
void pctick __ARGS((void));
void setbit __ARGS((unsigned port,char bits));
int setirq __ARGS((unsigned irq,INTERRUPT (*handler) __ARGS((void))));
void sysreset __ARGS((void));
void systick __ARGS((void));
void writebit __ARGS((unsigned port,char mask,int val));

/* In pcgen.asm: */
INTERRUPT btick __ARGS((void));
void chktasker __ARGS((void));
void chtimer __ARGS((INTERRUPT (*)()));
int32 divrem __ARGS((int32 dividend,int16 divisor));
int16 getss __ARGS((void));
void giveup __ARGS((void));
int kbraw __ARGS((void));
int16 longdiv __ARGS((int16 divisor,int n,int16 *dividend));
int16 longmul __ARGS((int16 multiplier,int n,int16 *multiplicand));
INTERRUPT nullvec __ARGS((void));
void uchtimer __ARGS((void));
int16 clockbits __ARGS((void));

/* In stopwatch.asm: */
void swstart __ARGS((void));
int16 stopval __ARGS((void));

/* In sw.c: */
void swstop __ARGS((int n));

#endif	/* _PC_H */

