/* Routines common to both the FTP client and server
 * Copyright 1991 Phil Karn, KA9Q
 */
#include <stdio.h>
#include "global.h"
#include "mbuf.h"
#include "socket.h"
#include "proc.h"
#include "ftp.h"

/* Send a file (opened by caller) on a network socket.
 * Normal return: count of bytes sent
 * Error return: -1
 */
long
sendfile(fp,network,mode,hash)
FILE *fp;	/* File to be sent */
FILE *network;	/* Network stream to be sent on */
int mode;	/* Transfer mode */
int hash;	/* Print hash marks every BLKSIZE bytes */
{
	long total = 0;
	long hmark = 0;
	char *buf;
	int cnt;

	switch(mode){
	default:
	case LOGICAL_TYPE:
	case IMAGE_TYPE:
		fmode(network,STREAM_BINARY);
		break;
	case ASCII_TYPE:
		fmode(network,STREAM_ASCII);
		break;
	}
	buf = mallocw(BLKSIZE);
	for(;;){
		if((cnt = fread(buf,1,BLKSIZE,fp)) == 0){
			break;
		}
		total += cnt;
		if(fwrite(buf,1,cnt,network) != cnt){
			total = -1;
			break;
		}
		while(hash && total >= hmark+1000){
			putchar('#');
			hmark += 1000;
		}
	}
	free(buf);
	if(hash)
		putchar('\n');
	return total;
}
/* Receive a file (opened by caller) from a network stream
 * Normal return: count of bytes received
 * Error return: -1
 */
long
recvfile(fp,network,mode,hash)
FILE *fp;
FILE *network;
int mode;
int hash;
{
	int cnt;
	long total = 0;
	long hmark = 0;
	char *buf;

	if(fp == NULLFILE)
		fp = stdout;	/* Default */
	switch(mode){
	default:
	case LOGICAL_TYPE:
	case IMAGE_TYPE:
		fmode(network,STREAM_BINARY);
		break;
	case ASCII_TYPE:
		fmode(network,STREAM_ASCII);
		break;
	}
	buf = mallocw(BUFSIZ);
	while((cnt = fread(buf,1,BUFSIZ,network)) != 0){
		total += cnt;
		while(hash && total >= hmark+1000){
			putchar('#');
			hmark += 1000;
		}
		if(fwrite(buf,1,cnt,fp) != cnt){
			total = -1;
			break;
		}
		/* Detect an abnormal close */
		if(socklen(fileno(network),0) == -1){
			total = -1;
			break;
		}
	}
	if(hash)
		putchar('\n');
	return total;
}
/* Determine if a file appears to be binary (i.e., non-text).
 * Return 1 if binary, 0 if ascii text after rewinding the file pointer.
 *
 * Used by FTP to warn users when transferring a binary file in text mode.
 */
int
isbinary(fp)
FILE *fp;
{
	int c,i;
	int rval;

	rval = 0;
	for(i=0;i<512;i++){
		if((c = getc(fp)) == EOF)
			break;
		if(c & 0x80){
			/* High bit is set, probably not text */
			rval = 1;
			break;
		}
	}
	/* Assume it was at beginning */
	fseek(fp,0L,SEEK_SET);
	return rval;
}

