/*****************************************************************************
* Definitions for the Poly3D-R program:                                      *
*****************************************************************************/

#ifndef POLY_3D_R_H
#define POLY_3D_R_H

#include "irit_sm.h"
#include "genmat.h"
#include "iritprsr.h"
#include "gif_lib.h"
#include "cagd_lib.h"

#define DEFAULT_COLOR		63     /* White - in case no color is given. */
#define DEFAULT_BACK_GROUND_COLOR  1	     /* Blue as default back ground. */
#define RGB_COLOR_GIVEN			-1	/* Or if fill RGB was given. */
#define DEFAULT_NORMAL_AVG_DEGREE	30	   /* Less will be averaged. */
#define DEFAULT_SAMPLE_PER_SRF_AXIS	20  /* Fineness srf subdiv. control. */

#define DEFAULT_SCREEN_XSIZE	320
#define DEFAULT_SCREEN_YSIZE	200

#define DEFAULT_BITS_PER_PIXEL	7
#define DEFAULT_LIGHT_SOURCE	{ 1.0, 3.0, 7.0 }
#define DEFAULT_AMBIENT		0.3

#define DEFAULT_FINENESS	4;

typedef struct ShadeInfoStruct {
    int SubSamplePixel;
    int BitsPerPixel;	     /* 2^BitsPerPixel == number of colors possible. */
    int LevelsPerColor;		/* Number of levels per each required color. */
    int DefaultColor;
    int BackGroundColor;
    int TwoSources;  /* If true - two sources at opposite direction assumed. */
    int ScrnXSize;			       /* Rendered image dimensions. */
    int ScrnYSize;
    int Gouraud;			     /* If TRUE use Gouraud shading. */
    int BackFacing;		   /* If TRUE - delete back facing polygons. */
    int *MinIntensityIndex;   /* Hold minimum intensity of this color index. */
    GifColorType *PColorMap;
    RealType LightSource[3];		/* Vector direction of light source. */
    RealType Ambient;
    RealType NrmlAvgDegree;
} ShadeInfoStruct;

typedef struct ScanConvertStruct {
    int MaxEdgeY;		      /* When this edge is no longer active. */
    struct IPVertexStruct *VMinY, *VMaxY; /* Which vertices form this bndry. */
} ScanConvertStruct;

typedef struct PolygonScanConvertStruct {
    ScanConvertStruct Bndry1, Bndry2;
} PolygonScanConvertStruct;

/* The following are global setable variables (via config file poly3d-r.cfg).*/
extern int GlblMore, MouseExists, GraphDriver;
extern ShadeInfoStruct GlblShadeInfo;

/* Total number of polygons/vertices to scan converted, in current scene:    */
extern int GlblNumOfPolys;
extern int GlblNumOfVerts;

/* Used as global measure on the surfaces subdivision fineness. */
extern int FineNess;

/* Amount scene was scaled up from normalized [-1..1] size on both X & Y:    */
extern RealType GlblScaleUpFctr;

/* Global transformation matrix: */
extern MatrixType GlblViewMat;			  /* Current view of object. */

/* All polygons to be scan convert will be inserted into this hash table     */
/* during the preprocessing (PrepareXXXX functions).			     */
extern struct IPPolygonStruct **PolyHashTable;

/* And finally the prototypes of the Poly3D-H.c module: */
IPPolygonStruct *ProcessSurfaces(CagdCrvStruct *Crvs, CagdSrfStruct *Srfs);
VoidPtr MyMalloc(unsigned size);
void MyFree(VoidPtr p);
void MyExit(int ExitCode);
void QuitGifError(void);

/* Prototypes of the PrepData.c module: */
void PrepareViewData(IPObjectStruct *PObjects);

/* Prototypes of the ColorTbl.c module: */
void PrepareColorTable(IPObjectStruct *PObjects);

/* Prototypes of the EvalColr.c module: */
void EvalVrtxColors(IPObjectStruct *PObjects);
int UpdateEqnPolygon(IPPolygonStruct *PPolygon, int SetFlipDir);
int CrossProd(RealType Pt1[3], RealType Pt2[3], RealType Pt3[3]);
void PrintPolyContent(IPPolygonStruct *PPoly);

/* Prototypes of the ScnCnvrt.c module: */
void ScanConvertData(GifFileType *GifFile, GifFileType *GifMask);

#endif /* POLY_3D_R_H */
