/*****************************************************************************
*   "Irit" - the 3d polygonal solid modeller.				     *
*									     *
* Written by:  Gershon Elber				Ver 0.2, Mar. 1990   *
******************************************************************************
* General, visible to others, definitions of primitiv module.		     *
*****************************************************************************/

#ifndef	PRIMITIV_H
#define	PRIMITIV_H

int GetResolution(int ClipToMin);
ObjectStruct *GenBOXObject(VectorType Pt, RealType *WidthX,
					RealType *WidthY, RealType *WidthZ);
ObjectStruct *GenGBOXObject(VectorType Pt,
			VectorType Dir1, VectorType Dir2, VectorType Dir3);
ObjectStruct *GenCONEObject(VectorType Pt, VectorType Dir, RealType *R);
ObjectStruct * GenCONE2Object(VectorType Pt, VectorType Dir, RealType *R1,
							     RealType *R2);
ObjectStruct *GenCYLINObject(VectorType Pt, VectorType Dir, RealType *R);
ObjectStruct *GenSPHEREObject(VectorType Center, RealType *R);
ObjectStruct *GenTORUSObject(VectorType Center, VectorType Normal,
					RealType *Rmajor, RealType *Rminor);
ObjectStruct *GenPLANEObject(VectorType N, VectorType T, RealType *R);
ObjectStruct *GenPOLYGONObject(ObjectStruct *PObjList);
ObjectStruct *GenObjectFromPolyList(ObjectStruct *PObjList);
ObjectStruct *GenCROSSECObject(ObjectStruct *PObj);
ObjectStruct *GenSURFREVObject(ObjectStruct *Cross);
ObjectStruct *GenEXTRUDEObject(ObjectStruct *Cross, VectorType Dir);
void UpdatePolyPlane(PolygonStruct *PPoly, VectorType Vin);

#endif	/* PRIMITIV_H */
