/*****************************************************************************
*   Definitions for program to draw a surface function given as Z = f(X, Y)  *
*									     *
*   Written by :  Gershon Elber				 Ver 0.1, Apr. 1988  *
*****************************************************************************/

#ifndef DRAW_FN_3D_H
#define DRAW_FN_3D_H

#include "Expr2TrG.h"
#include "GenMat.h"

#define VoidPtr		void *

#define ABS(y)		((y) > 0 ? (y) : (-(y)))
#define	SQR(y)		((y) * (y))
#define SGN(x)		((x) > 0 ? 1 : ((x) == 0 ? 0 : -1))
#define DEG2RAD(x)	((x) * M_PI / 180.0)

#define IS_DISK_FILE(FileName)	(!(strstr(FileName, \
					"con com1 com2 com3 lpt1 lpt2 lpt3")))

#define	LINE_LEN	128			     /* Maximum line length. */
#define	LINE_LEN_LONG	1024  /* Max. long line length - for function input. */
#define FILE_NAME_LEN	80

#define	DEFAULT_SAMPLES	50    /* Default number of samples per one iso line. */
#define	MAX_SAMPLES	1000  /* Maximum number of samples per one iso line. */
#define	DEFAULT_ISO_LINES 20		     /* Default number of iso lines. */
#define	MAX_ISO_LINES	100		     /* Maximum number of iso lines. */

typedef	struct IsoLine {
     float Samples[MAX_SAMPLES][3];
} IsoLine;

#define	FUNC_COLOR	MAGENTA			       /* Color of function. */
#define	AXES_COLOR	YELLOW				   /* Color of axes. */

#define	FUNC_POS_X	-0.95		     /* Function as string position. */
#define	FUNC_POS_Y	0.7
#define	FUNC_DIF_Y	0.1		    /* Difference between two lines. */

#define	MAIN_SCALE	1.98	        /* Should be 2 but for the safety... */

#ifndef INFINITY
#define INFINITY 1e6
#endif

#ifndef	NULL
#define	NULL	   0
#endif

#ifndef	TRUE
#define	TRUE	   -1
#define	FALSE	   0
#endif

#define FILES_TO_DIR	"*.fun"		 /* Mask what files to print in dir. */

/* Prototypes in DrawFn3D.c module: */

void RedrawScreen(ExprNode *PFunc[3], char SFunc[3][LINE_LEN_LONG],
	double UMin, double UMax, double VMin, double VMax,
	MatrixType TransMat, int NumOfSamples, int NumOfIsoLines,
	struct IsoLine *IsoLinesU[MAX_ISO_LINES],
	struct IsoLine *IsoLinesV[MAX_ISO_LINES]);
void SetUpHardErr(void);
void MyExit(int ExitCode);
extern int MouseExists;  /* Set according to autotest and config enforcment. */
extern int GraphDriver;						        /* " */


/* Prototypes in GetFunc.c module: */

void DoGetFunc(ExprNode *PFunc[3], char SFunc[3][LINE_LEN_LONG],
	int *InputExists,
	double *UMin, double *UMax, double *VMin, double *VMax,
	int *NumOfIsoLines, int *NumOfSamples,
	struct IsoLine *IsoLinesU[MAX_ISO_LINES],
	struct IsoLine *IsoLinesV[MAX_ISO_LINES], MatrixType TransMat);
int GetLine(FILE *f, int ReadStdin, char *Header, char *s);


/* Prototypes in SetParam.c module: */

void DoSetParam(int *NumOfSamples, int *NumOfIsoLines,
	double *UMin, double * UMax, double * VMin, double * VMax,
	int *DblBuffer,
	struct IsoLine *IsoLinesU[MAX_ISO_LINES],
	struct IsoLine *IsoLinesV[MAX_ISO_LINES]);
void UpdateDataStruct(int OldSamples, int OldIsoLines,
	int *NumOfSamples, int *NumOfIsoLines,
	struct IsoLine *IsoLinesU[MAX_ISO_LINES],
	struct IsoLine *IsoLinesV[MAX_ISO_LINES]);


/* Prototypes in SaveFunc.c module: */

void DoSaveFunc(ExprNode *PFunc[3], char SFunc[3][LINE_LEN_LONG],
	double UMin, double UMax, double VMin, double VMax,
	int NumOfIsoLines, int NumOfSamples, MatrixType TransMat);

#endif DRAW_FN_3D_H
