/*-------------------------------------------------------------------------

  domains.c - List of top-level domains used in Internet domain names.

  Copyright (c) 1993 Rhys Weatherley

  Permission to use, copy, modify, and distribute this material
  for any purpose and without fee is hereby granted, provided
  that the above copyright notice and this permission notice
  appear in all copies, and that the name of Rhys Weatherley not be
  used in advertising or publicity pertaining to this
  material without specific, prior written permission.
  RHYS WEATHERLEY MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR
  SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
  "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES.

  Revision History:
  ================

   Version  DD/MM/YY  By  Description
   -------  --------  --  --------------------------------------
     1.0    10/09/93  RW  Original Version of domains.c

-------------------------------------------------------------------------*/

#ifdef	__TURBOC__
#include <string.h>
#endif

#include <stdio.h>

/*
   This array was derived from the 27 April 1993 version of the posting
   "FAQ: Top-level international country domain names" which is posted
   periodically by Olivier M.J. Crepin-Leblond to the following newsgroups:
   comp.mail.misc, comp.mail.uucp, news.newusers.questions,
   alt.internet.services, alt.answers, and news.answers.  Although new
   domains may be added at any time, this list should be sufficient for
   FTP and moder.lst purposes for quite some time to come.  If your
   domain is missing, then contact Rhys Weatherley at rhys@cs.uq.oz.au.
*/

static	char	*domains[] = {
	"ad", "Andorra",
	"ae", "United Arab Emirates",
	"af", "Afghanistan",
	"ag", "Antigua and Barbuda",
	"ai", "Anguilla",
	"al", "Albania",
	"am", "Armenia",
	"an", "Netherland Antilles",
	"ao", "Angola",
	"aq", "Antarctica",
	"ar", "Argentina",
	"arpa", "Old style Arpanet",
	"as", "American Samoa",
	"at", "Austria",
	"au", "Australia",
	"aw", "Aruba",
	"az", "Azerbaidjan",
	"ba", "Bosnia-Herzegovina",
	"bb", "Barbados",
	"bd", "Bangladesh",
	"be", "Belgium",
	"bf", "Burkina Faso",
	"bg", "Bulgaria",
	"bh", "Bahrain",
	"bi", "Burundi",
	"bj", "Benin",
	"bm", "Bermuda",
	"bn", "Brunei Darussalam",
	"bo", "Bolivia",
	"br", "Brazil",
	"bs", "Bahamas",
	"bt", "Buthan",
	"bv", "Bouvet Island",
	"bw", "Botswana",
	"by", "Bielorussia",
	"bz", "Belize",
	"ca", "Canada",
	"cc", "Cocos (Keeling) Isl.",
	"cf", "Central African Rep.",
	"cg", "Congo",
	"ch", "Switzerland",
	"ci", "Ivory Coast",
	"ck", "Cook Islands",
	"cl", "Chile",
	"cm", "Cameroon",
	"cn", "China",
	"co", "Colombia",
	"com", "Commercial",
	"cr", "Costa Rica",
	"cs", "Czechoslovakia",
	"cu", "Cuba",
	"cv", "Cape Verde",
	"cx", "Christmas Island",
	"cy", "Cyprus",
	"de", "Germany",
	"dj", "Djibouti",
	"dk", "Denmark",
	"dm", "Dominica",
	"do", "Dominican Republic",
	"dz", "Algeria",
	"ec", "Ecuador",
	"edu", "Educational",
	"ee", "Estonia",
	"eg", "Egypt",
	"eh", "Western Sahara",
	"es", "Spain",
	"et", "Ethiopia",
	"fi", "Finland",
	"fj", "Fiji",
	"fk", "Falkland Isl.(Malvinas)",
	"fm", "Micronesia",
	"fo", "Faroe Islands",
	"fr", "France",
	"fx", "France (European Ter.)",
	"ga", "Gabon",
	"gb", "Great Britain (UK)",
	"gd", "Grenada",
	"ge", "Georgia",
	"gf", "Guyana (Fr.)",
	"gh", "Ghana",
	"gi", "Gibraltar",
	"gl", "Greenland",
	"gm", "Gambia",
	"gn", "Guinea",
	"gov", "Government",
	"gp", "Guadeloupe (Fr.)",
	"gq", "Equatorial Guinea",
	"gr", "Greece",
	"gt", "Guatemala",
	"gu", "Guam (US)",
	"gw", "Guinea Bissau",
	"gy", "Guyana",
	"hk", "Hong Kong",
	"hm", "Heard & McDonald Isl.",
	"hn", "Honduras",
	"hr", "Croatia",
	"ht", "Haiti",
	"hu", "Hungary",
	"id", "Indonesia",
	"ie", "Ireland",
	"il", "Israel",
	"in", "India",
	"int", "International field",
	"io", "British Indian O. Terr.",
	"iq", "Iraq",
	"ir", "Iran",
	"is", "Iceland",
	"it", "Italy",
	"jm", "Jamaica",
	"jo", "Jordan",
	"jp", "Japan",
	"ke", "Kenya",
	"kg", "Kirgistan",
	"kh", "Cambodia",
	"ki", "Kiribati",
	"km", "Comoros",
	"kn", "St.Kitts Nevis Anguilla",
	"kp", "Korea (North)",
	"kr", "Korea (South)",
	"kw", "Kuwait",
	"ky", "Cayman Islands",
	"kz", "Kazachstan",
	"la", "Laos",
	"lb", "Lebanon",
	"lc", "Saint Lucia",
	"li", "Liechtenstein",
	"lk", "Sri Lanka",
	"lr", "Liberia",
	"ls", "Lesotho",
	"lt", "Lithuania",
	"lu", "Luxembourg",
	"lv", "Latvia",
	"ly", "Libya",
	"ma", "Morocco",
	"mc", "Monaco",
	"md", "Moldavia",
	"mg", "Madagascar",
	"mh", "Marshall Islands",
	"mil", "US Military",
	"ml", "Mali",
	"mm", "Myanmar",
	"mn", "Mongolia",
	"mo", "Macau",
	"mp", "Northern Mariana Isl.",
	"mq", "Martinique (Fr.)",
	"mr", "Mauritania",
	"ms", "Montserrat",
	"mt", "Malta",
	"mu", "Mauritius",
	"mv", "Maldives",
	"mw", "Malawi",
	"mx", "Mexico",
	"my", "Malaysia",
	"mz", "Mozambique",
	"na", "Namibia",
	"nato", "Nato field",
	"nc", "New Caledonia (Fr.)",
	"ne", "Niger",
	"net", "Network",
	"nf", "Norfolk Island",
	"ng", "Nigeria",
	"ni", "Nicaragua",
	"nl", "Netherlands",
	"no", "Norway",
	"np", "Nepal",
	"nr", "Nauru",
	"nt", "Neutral Zone",
	"nu", "Niue",
	"nz", "New Zealand",
	"om", "Oman",
	"org", "Non-Profit Organization",
	"pa", "Panama",
	"pe", "Peru",
	"pf", "Polynesia (Fr.)",
	"pg", "Papua New Guinea",
	"ph", "Philippines",
	"pk", "Pakistan",
	"pl", "Poland",
	"pm", "St. Pierre & Miquelon",
	"pn", "Pitcairn",
	"pr", "Puerto Rico (US)",
	"pt", "Portugal",
	"pw", "Palau",
	"py", "Paraguay",
	"qa", "Qatar",
	"re", "Reunion (Fr.)",
	"ro", "Romania",
	"ru", "Russian Federation",
	"rw", "Rwanda",
	"sa", "Saudi Arabia",
	"sb", "Solomon Islands",
	"sc", "Seychelles",
	"sd", "Sudan",
	"se", "Sweden",
	"sg", "Singapore",
	"sh", "St. Helena",
	"si", "Slovenia",
	"sj", "Svalbard & Jan Mayen Is",
	"sl", "Sierra Leone",
	"sm", "San Marino",
	"sn", "Senegal",
	"so", "Somalia",
	"sr", "Suriname",
	"st", "St. Tome and Principe",
	"su", "Soviet Union",
	"sv", "El Salvador",
	"sy", "Syria",
	"sz", "Swaziland",
	"tc", "Turks & Caicos Islands",
	"td", "Chad",
	"tf", "French Southern Terr.",
	"tg", "Togo",
	"th", "Thailand",
	"tj", "Tadjikistan",
	"tk", "Tokelau",
	"tm", "Turkmenistan",
	"tn", "Tunisia",
	"to", "Tonga",
	"tp", "East Timor",
	"tr", "Turkey",
	"tt", "Trinidad & Tobago",
	"tv", "Tuvalu",
	"tw", "Taiwan",
	"tz", "Tanzania",
	"ua", "Ukraine",
	"ug", "Uganda",
	"uk", "United Kingdom",
	"um", "US Minor outlying Isl.",
	"us", "United States",
	"uy", "Uruguay",
	"uz", "Uzbekistan",
	"va", "Vatican City State",
	"vc", "St.Vincent & Grenadines",
	"ve", "Venezuela",
	"vg", "Virgin Islands (British)",
	"vi", "Virgin Islands (US)",
	"vn", "Vietnam",
	"vu", "Vanuatu",
	"wf", "Wallis & Futuna Islands",
	"ws", "Samoa",
	"ye", "Yemen",
	"yu", "Yugoslavia",
	"za", "South Africa",
	"zm", "Zambia",
	"zr", "Zaire",
	"zw", "Zimbabwe",
	(char *)0};
static	int	numdomains = 246;

/*
 * Find the descriptive name for a domain.  Returns
 * NULL if the domain could not be found.  It is
 * assumed that the name is in lower case.
 */
char	*FindDomain (domain)
char	*domain;
{
  int left, right, middle, compare;
  left = 0;
  right = numdomains - 1;
  while (left <= right)
    {
      middle = (left + right) / 2;
      compare = strcmp (domain, domains[middle * 2]);
      if (compare == 0)
        return (domains[middle * 2 + 1]);
      if (compare < 0)
        right = middle - 1;
       else
        left = middle + 1;
    } /* while */
  return (NULL);
} /* FindDomain */
