/*-------------------------------------------------------------------------

  help.c - Help data for the moder.lst viewing program.

  Copyright (c) 1993 Rhys Weatherley

  Permission to use, copy, modify, and distribute this material
  for any purpose and without fee is hereby granted, provided
  that the above copyright notice and this permission notice
  appear in all copies, and that the name of Rhys Weatherley not be
  used in advertising or publicity pertaining to this
  material without specific, prior written permission.
  RHYS WEATHERLEY MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR
  SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
  "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES.

  Revision History:
  ================

   Version  DD/MM/YY  By  Description
   -------  --------  --  --------------------------------------
     1.0    10/09/93  RW  Original Version of help.c

-------------------------------------------------------------------------*/

#ifdef	__TURBOC__
#ifndef	MSDOS
#define	MSDOS
#endif
  #pragma warn -par
  #pragma warn -pro
#include <string.h>
#endif

#include <stdio.h>
#include "display.h"

static	char	*help[] = {
"Enter/Return   Go into a submenu.",
#ifdef	MSDOS
"Esc/Q/X        Return to the previous menu or exit the program.",
"J/Cursor-Down  Move down one entry in a menu or scroll text data up one line.",
"K/Cursor-Up    Move up one entry in a menu or scroll text data down one line.",
"H/^/Home       Go to the start of the menu or text data.",
"E/$/End        Go to the end of the menu or text data.",
"U/^U/B/^B/PgUp Go back a page in the menu or text data.",
"D/^D/F/^F/PgDn Go forward a page in the menu or text data.",
#else	/* !MSDOS */
"Q/X            Return to the previous menu or exit the program.",
"J/^J/+/=       Move down one entry in a menu or scroll text data up one line.",
"K/^K/-         Move up one entry in a menu or scroll text data down one line.",
"H/^            Go to the start of the menu or text data.",
"E/$            Go to the end of the menu or text data.",
"U/^U/B/^B      Go back a page in the menu or text data.",
"D/^D/F/^F      Go forward a page in the menu or text data.",
"^R/^L          Redraw the current screen.",
#endif	/* !MSDOS */
"?              This help screen.",
(char *)0};

/*
 * Determine the number of lines of help data to display.
 */
static	int	HelpLength ()
{
  int len = 0;
  while (help[len] != ((char *)0))
    ++len;
  return (len);
} /* HelpLength */

/*
 * Draw a line of help data on the screen.
 */
static	void	DrawHelpLine (display, param, item)
DisplayList *display;
void    *param;
int     item;
{
  DrawChars ((DrawPtr)(help[item]), strlen (help[item]));
} /* DrawHelpLine */

/*
 * Display the help screen for this program.
 */
void	DisplayHelp ()
{
  DisplayList display;
  InitList (&display, (void *)0, DrawHelpLine, HelpLength (),
 		(DrawPtr)"Help", 4, 1);
  SelectDisplay (&display);
} /* DisplayHelp */
