/*

	eb4.cpp
	7-31-91
	Electronic Book


	Copyright 1991
	John W. Small
	All rights reserved

	Licensed users of FlexList may use and modify this
	tool for use in their programs.


	PSW / Power SoftWare
	P.O. Box 10072
	McLean, Virginia 22102 8072 USA

	Voice: (703) 759-3838
	CIS: 73757,2233


	Notes:  The Electronic Book was coded to demonstrate
	the various uses of FlexList.


*/

#include <process.h>
#include <ctype.h>
#include <eb4.hpp>

#ifndef PICKFILE_HPP
#include <pickfile.hpp>
#endif

#ifndef PCKEY_HPP
#include <pckey.hpp>
#endif




Arguments::Arguments(const char *A) : FlexList(FLstrings)
{
	int i, j, l;

	V = (char **)0;
	if (!A)
		return;
	for (i = j = 0; A[i] && i < MAX_HYPER_LINE; i = j) {
		while (isspace(A[i]))
			i++;
		for (j = i; A[j] && !isspace(A[j]); j++)
			/* null stmt */;
		if (j > i && (l = (j-i)) < MAX_ARG_LEN)  {
			strncpy(buf,&A[i],l);
			buf[l] = '\0';
			insQD(buf);
		}
	}
	V = (char **) packPtrs();
}


Palette HVTWdefaultP = {

	0,  /*  monochrome         or         color  */

	svideo(DARKGRAY,LIGHTGRAY),	svideo(LIGHTRED,BLUE),
	svideo(WHITE,LIGHTGRAY),	svideo(LIGHTRED,BLUE),
	svideo(WHITE,LIGHTGRAY),	svideo(LIGHTRED,BLUE),
	svideo(DARKGRAY,BLACK),		svideo(CYAN,BLUE),
	svideo(BLACK,LIGHTGRAY),	svideo(WHITE,BLUE),
	svideo(WHITE,LIGHTGRAY),	svideo(LIGHTGRAY,RED),
	svideo(WHITE,BLACK),		svideo(WHITE,BLUE)
};


int HyperView::view(const char * hyperFname,
	const char * topic, int l, int t, int r, int b)
{
	struct text_info ti;
	TextWindow TW(HVTWdefaultP);
	PickFile pf;
	TargetParser tp;
	ArgumentS A;
	enum HC_ACTIONS hca;
	int backTrack;
	int fullScreen = 0;

	if (l < 1)
		fullScreen = 1;
	if (fullScreen)  {
		gettextinfo(&ti);
		l = t = 1;
		r = ti.screenwidth;
		b = ti.screenheight;
	}
	if (fullScreen)
		TW.window(l,t,r,b,DOUBLE_FRAME,0,1,0);
	else
		TW.window(l,t,r,b);
	if (hyperFname)  {
		hstk.pushTarget(hyperFname,topic);
		backTrack = 0;
	}
	else
		backTrack = 1;
	while (1)  {
		if (!hstk.targets())
			if (pf.choose((char *)0,FA_DIREC,".htx"))  {
				hstk.pushTarget(pf.choice());
				backTrack = 0;
			}
			else  {
				TW.close();
				return -1;
			}
		if ((HC = hser.fetch(hstk.topTarget(),
			backTrack)) == HyperContexT0)  {
			hstk.popTarget();
			backTrack = 1;
			continue;
		}
		while (HC)  {
		hca = HC->view();
		hstk.setTopView(HC->StartColumn(),HC->StartRow(),
			HC->CursorColumn(),HC->CursorRow());
		switch (hca)  {
		case HyperContext::HELP:
			help();
			break;
		case HyperContext::LOAD:
			if (pf.choose((char *)0,FA_DIREC,".htx"))
				if (hstk.pushTarget(pf.choice()))  {
					delete TOC;
					delete IDX;
					TOC = PickTOC0;
					IDX = PickIDX0;
					delete HC;
					HC = HyperContexT0;
					backTrack = 0;
				}
			break;
		case HyperContext::TABLE_OF_CONTENTS:
			if (!TOC) TOC = hser.TableOfContents
				(hstk.topFname());
			if (TOC) if (TOC->choose(HC->TopicNum()))
			if (hstk.pushTarget(hstk.topFname(),
				TOC->choice())) {
				delete HC;
				HC = HyperContexT0;
				backTrack = 0;
			}
			break;
		case HyperContext::INDEX:
			if (!IDX) IDX = hser.Index(hstk.topFname());
			if (IDX) if (IDX->choose())
			if (hstk.pushTarget(hstk.topFname(),
				IDX->choice())) {
				delete HC;
				HC = HyperContexT0;
				backTrack = 0;
			}
			break;
		case HyperContext::LAUNCH:
			switch (tp.parse(HC->newTarget()))  {
			case TargetParser::UNKNOWN:
				break;
			case TargetParser::NEAR_TOPIC:
			case TargetParser::NEAR_DEFAULT:
				if (hstk.pushTarget(hstk.topFname(),
					tp.topic())) {
					delete HC;
					HC = HyperContexT0;
					backTrack = 0;
				}
				break;
			case TargetParser::FAR_TOPIC:
			case TargetParser::FAR_DEFAULT:
				if (hstk.pushTarget(tp.params(),
					tp.topic())) {
					delete TOC;
					delete IDX;
					TOC = PickTOC0;
					IDX = PickIDX0;
					delete HC;
					HC = HyperContexT0;
					backTrack = 0;
				}
				break;
			case TargetParser::FAR_SYSTEM:
				delete TOC;
				delete IDX;
				TOC = PickTOC0;
				IDX = PickIDX0;
				delete HC;
				HC = HyperContexT0;
				TW.close();
				textattr(LIGHTGRAY+BLACK*16);
				clrscr();
				system(tp.params());
				cputs("Press any key ...");
				getch();
				backTrack = 1;
				if (fullScreen)  {
					gettextinfo(&ti);
					l = t = 1;
					r = ti.screenwidth;
					b = ti.screenheight;
				}
				if (fullScreen)
					TW.window(l,t,r,b,DOUBLE_FRAME,0,1,0);
				else
					TW.window(l,t,r,b);
				break;
			case TargetParser::FAR_SPAWN:
				if ((A = new Arguments(tp.params()))
					== ArgumentS0)
					break;
				if (!A->argc())  {
					delete A;
					break;
				}
				delete TOC;
				delete IDX;
				TOC = PickTOC0;
				IDX = PickIDX0;
				delete HC;
				HC = HyperContexT0;
				TW.close();
				textattr(LIGHTGRAY+BLACK*16);
				clrscr();
				spawnvp(P_WAIT,A->argv0(),A->argv());
				delete A;
				backTrack = 1;
				if (fullScreen)  {
					gettextinfo(&ti);
					l = t = 1;
					r = ti.screenwidth;
					b = ti.screenheight;
				}
				if (fullScreen)
					TW.window(l,t,r,b,DOUBLE_FRAME,0,1,0);
				else
					TW.window(l,t,r,b);
				break;
			}
			break;
		case HyperContext::BACKUP:
			if (hstk.targets() > 1)  {
				delete TOC;
				delete IDX;
				TOC = PickTOC0;
				IDX = PickIDX0;
				delete HC;
				HC = HyperContexT0;
				hser.discard(hstk.topFname());
				hstk.popTarget();
				backTrack = 1;
			}
			break;
		case HyperContext::EXIT:
			delete TOC;
			delete IDX;
			TOC = PickTOC0;
			IDX = PickIDX0;
			delete HC;
			HC = HyperContexT0;
			TW.close();
			return 0;
		case HyperContext::ATTR_TOGGLE:
			TW.close();
			forcedmonochrome = !forcedmonochrome;
			if (fullScreen)
				TW.window(l,t,r,b,
					DOUBLE_FRAME,0,1,0);
			else
				TW.window(l,t,r,b);
			break;
		case HyperContext::RES_TOGGLE:
			TW.close();
			toggleRes();
			PCF.reset();
			if (fullScreen)  {
				gettextinfo(&ti);
				l = t = 1;
				r = ti.screenwidth;
				b = ti.screenheight;
			}
			if (fullScreen)
				TW.window(l,t,r,b,
					DOUBLE_FRAME,0,1,0);
			else
				TW.window(l,t,r,b);
			break;

		} // switch (hca)
		} // while (HC)
	}  // while (1)
	TW.close();
	return -1;
}

void HyperView::help()
{
	TextWindow TW;

	TW.window(10,5,70,19);
	TW.putTitle(" EB Help ");
	cputs("\n\r      F1                  Help"
	      "\n\r      F3                  Load new HyperText file"
	      "\n\r      F10, AltT           Table of Contents"
	      "\n\r      AltF10, AltI        Index"
	      "\n\r      CR                  Tranverse HyperLink"
	      "\n\r      AltF1, BACKSP       Backtrack HyperLink"
	      "\n\r      F6                  Toggle 25 - 43/50 lines"
	      "\n\r      ShiftF6             Toggle monochrome/color"
	      "\n\r      AltX                Exit"
	      "\n\n\r      Your choice ...");
	while (!PCK.kbhit()) /* null stmt */;
	TW.close();
}

HyperView::~HyperView()
{
	delete HC; delete TOC; delete IDX;
	while (hstk.targets()) {
		hser.discard(hstk.topFname());
		hstk.popTarget();
	}
}
