          



          Chapter 2 - The Speech Pad and Keyboard



          Speech Pad and Keyboard                           page - 17
          

          INTRODUCTION 

          This chapter describes the Speech Pad functions of JAWS (Job
          Access With Speech).  It is assumed that the speech synthesizer 
          is already installed in your computer and JAWS has been loaded 
          into memory.  For information concerning the installation of the 
          speech synthesizer and the loading of JAWS, refer to the chapter 
          of this  manual entitled  "Introduction" or the Appendix for your
          particular synthesizer.

          This chapter also assumes that you are familiar with the basic 
          layout of your particular keyboard and the numbering of the keys 
          on the numeric keypad.  If you are not, you should listen  to the
          JAWS  Introduction  Training  Tape  or  use  the "help" mode, see
          below.

          The Numeric Pad.

          The JAWS Speech Pad utilizes the numeric key pad (num  pad) which
          is found  on the  far right  side on most IBM Compatible Personal
          Computers.  The  numeric  functions  of  the  key  pad  are still
          accessible when  "Num Lock"  is turned on.  Num Lock is toggle on
          and off by pressing the Num  Lock key  which is  commonly located
          above the  number 7  or the  number 8  on the  key pad.  When you
          press the Num Lock key, the  speech  device  will  tell  you what
          you've changed  the Num  Lock setting  to - if you have turned it
          on, the speech device will say: "Num Lock On", otherwise, it will
          say: "Num  Lock Off".   From  this point  forward, we will assume
          that Num Lock is off.  You can use the program named "NUMOFF.COM"
          to  automatically  turn  off  the  num  lock when the computer is
          booted up, just install  it in  your "AUTOEXEC.BAT"  file, before
          loading jaws.

          Normally, when  Num Lock is off, the keys on the num pad serve as
          "Cursor Movement" keys.   These  keys  include  the  Up  and Down
          arrows (keys  8 and  2, respectively),  the Left and Right arrows
          (keys 4 and 6), the Home and End keys (7 and 1), and the  Page Up
          and Page Down keys (9 and 3).  The num pad also contains the Plus
          and Minus (or Dash) keys.   The Minus  key is  usually located to
          the right of the 9 and the Plus key is usually located just below
          the Minus key.  Along the very bottom row on the num  pad are the
          keys Insert  and Delete  (the 0  and the  Period or Decimal Point
          keys).  The num pad will usually contain other keys  as well, but
          exactly which  other keys is uncertain, depending on the make and
          model of the computer, so JAWS  doesn't  attempt  to  use  any of
          them.

          JAWS redefines and enhances these original key definitions (with 
          Num Lock off) to perform its own custom functions and provide 
          speech output for the blind user.  The original cursor movement 

          Speech Pad and Keyboard                           page - 18
          

          functions can all be accessed by holding down the Alt key and 
          pressing the desired cursor movement key.  Also use the "alt" key
          in combination with Insert,  Delete, Plus,  and Minus  to perform
          the original  functions of  these keys.  For example, to delete a
          character in a word processor hold  down  the  alt  key  and then
          press delete.

          Without JAWS,  when the  Alt key  is used in combination with the
          num pad keys, Extended ASCII  codes  (used  to  produce graphics,
          boxes,  and  other  special  characters)  are  generated.   These
          Extended ASCII characters are  still  available  by  holding down
          both the Shift and the Alt keys and typing the usual numeric code
          used to produce the desired character.



          Speech Pad and Keyboard                           page - 19
          

          The Numbers Row.

          JAWS also makes use of several keys found on the "Numbers Row", 
          that is, the row of numeric keys found above the usual typewriter
          keys (the Q W E R T Y keys).  For example, JAWS has a "Help Mode"
          where only the key labels or  names are  spoken.   To toggle this
          "Help Mode",  simply hold  down the Insert key on the numeric pad
          with your right thumb and press the number 1 key  found along the
          numbersrow (usually  the second  key along  that row).   When you
          press that key, the  speech device  will, if  Help Mode  was off,
          say: "Help  Mode On"  and Help Mode will be turned on; otherwise,
          if Help Mode was on, it will say:  "Help Mode Off"  and Help Mode
          will be turned off.  When Help is on you can explore the keyboard
          to learn the position and function of the keys.

          The Insert Key as a "Shift" Key.

          Most cursor movement and screen reading functions can be 
          performed using only the right hand since nearly all basic speech
          functions are controlled from the speech pad.  The Insert key 
          (located on the bottom row of the numeric pad on the left most 
          corner, usually a large rectangular key) functions as a "Shift" 
          key for the JAWS functions provided by the other keys on the 
          numeric pad.   With  alphabetic keys, there are commonly two keys
          labeled "Shift"  which, when  pressed, will  shift the alphabetic
          keys from  lower to  upper case  - just as on a typewriter.  JAWS
          will  use  the  Insert  key  to  "shift"  or  slightly  alter the
          functions  performed  by  the  other  speech pad keys.  The "most
          obvious" function will be performed  by  the  unshifted  key, the
          shifted (or Insert-) state of these keys perform the less obvious
          but  similar  functions.    These  functions,  and  their shifted
          counterparts, are described below.



          Speech Pad and Keyboard                           page - 20
          

          BASIC CURSOR MOVEMENT AND SPEECH FUNCTIONS

          Here  we  are  discussing  the default keyboard layout, the basic
          configuration that  JAWS is  delivered with.   These  keys can be
          easily   changed,   by   the   user   or   by   loading   another
          configuration/macro file.  Keep that in mind when  reviewing this
          chapter.

          "Prior Character", "Next Character", and "Say Character".

          With "Num Lock" off, pressing the number "4" key on the pad (the 
          Left Arrow  key), will  perform the  Prior Character function. It
          will move the cursor to the left (just as the  regular Left Arrow
          key will) and then it will speak this new character. 

          Pressing the 6 on the numeric pad (the Right Arrow key) will 
          perform the Next Character function. It will cause the cursor 
          to move  to the  right (just as the regular Right Arrow key will)
          and then it will speak this new character.  

          Logically then, if the number 4 (the Left Arrow) is Prior 
          Character and the number 6 (the  Right Arrow)  is Next Character,
          the number  5 on  the pad (normally undefined) should perform the
          Say Character function - and it  does.   Pressing the  5 will not
          move  the  cursor  in  any  direction,  it  will simply speak the
          character that the cursor is on.  Pressing this key  twice within
          a second  will phonetically  speak this  character (alpha, bravo,
          charley, etc.).  If the character is an extended ASCII or control
          character (graphics) its decimal value will be spoken. 

          "Prior Word", "Next Word", and "Say Word".

          As mentioned, the "most obvious" functions are provided by the 
          speech pad keys in their unshifted states.  In their shifted 
          states, they perform less obvious but similar functions.  In 
          light of  this, the  key 4  (Prior Character when unshifted) will
          become Prior Word when it is pressed while the Insert key is held
          down.   Its behavior is similar to Prior Character - it moves the
          cursor left one, and then speaks.   The  only difference  is that
          Prior Word  operates, as  its name implies, on words.  The cursor
          will be moved to the next word to the left, and that  entire word
          will be spoken.  

          Similarly, the Insert-6 (Right Arrow, Next Character when 
          unshifted) will move the cursor to the Next Word to the right 
          and then speak that word.  



          Speech Pad and Keyboard                           page - 21
          

          As before, if the Insert-4 is Prior Word and the Insert-6 is Next
          Word then logically, the Insert-5 should be Say Word - and it is.
          Say Word will speak the entire word that the cursor is on, but it
          will not move the cursor.    Pressing  this  key  twice  within a
          second will spell the word.

          "Prior Line", "Next Line", and "Say Line".

          If the Left Arrow key performs the Prior Character function under
          JAWS (similar to a normal Left Arrow, only  with speech)  and the
          Right Arrow  key performs the Next Character function (similar to
          a normal Right Arrow,  only  with  speech),  then  it  seems only
          natural that  the Up  Arrow key (the 8 on the numeric pad) should
          move up one position to the  prior line  on the  screen and speak
          (similar to the normal Up Arrow, only with speech) - and it does.
          Pressing the Up Arrow will move the cursor to the "Prior Line" on
          the screen  and then  speak that  line.  The cursor will not move
          left or right, it will only move up (just as  the Left  and Right
          arrow keys do not move the cursor up or down).

          Since the Up Arrow key performs the Prior Line function and moves
          the cursor up to the prior  line on  the screen  (as a  normal Up
          Arrow would)  and speaks  the line,  the Down Arrow key (the 2 on
          the numeric pad) has been defined to move the cursor  to the Next
          Line  (as  a  normal  Down  Arrow  would)  and  speak that  line.
          Similarly, the Next Line function only moves the  cursor down, it
          does not move it to the left or the right.

          So what  about a  function to say the current line?  The Up Arrow
          key provides the Prior  Line  function  and  the  Down  Arrow key
          provides  the  Next  Line  function.   The key in between (the 5)
          seems like the most natural choice to say  the current  line, but
          it already has a regular definition (Say Character) and a shifted
          definition (Say Word), so  it would  only cause  confusion to add
          another  function  to  this  key  which  would  operate on lines.
          Therefore, the Insert-8 (Insert- Up Arrow) has been chosen to 
          perform the Say Line function.  This is in keeping with the 
          previous statement - the unshifted cursor movement keys perform 
          the most obvious functions, while the less obvious, but similar, 
          functions are performed by using the Insert key to shift the 
          functions.



          Speech Pad and Keyboard                           page - 22
          

          POSITION DETERMINATION

          Determining the Position of the Cursor on a Line.

          The previous section of this chapter described how to move the 
          cursor around the screen and speak whatever text was found there.
          It did not, however, mention anything about an easy way to 
          determine your position within a line.  To do this, you would 
          have to say the line, say the word and character where the cursor
          was positioned, and possibly move the cursor several words left 
          or right.  This procedure might be tolerable once or twice, but 
          if you were, for example, editing a document in a word processor 
          and making many changes, this would rapidly become annoying.  

          JAWS provides two functions to help alleviate this potential 
          problem.  The first is "Say Up To Cursor".  It will speak all the
          text on a line up to, but not including, the character that the 
          cursor is on.  The second is "Say From Cursor".  It will speak 
          all the text on the current line from the cursor position to the 
          end of the line.

          Since we've  defined Insert-8  (Insert -  Up Arrow) to be the Say
          Line function,  it  seems  natural  that  the  Say  Up  To Cursor
          function (which  will say  everything to  the left of the cursor)
          should be activated by the Insert-7 (Insert - Home) key, which is
          directly to the left of the Insert-8 (Say Line) key.

          Similarly, if we have everything to the left of the cursor spoken
          by pressing the key to the left of the Say  Line, then everything
          to the  right of  the cursor should be spoken when the key to the
          right of the Say Line is  pressed -  and this  is the  case.  Say
          From Cursor  is activated  by pressing  a Insert-9 (Insert - Page
          Up) and it will speak everything from the cursor to  the right on
          the current line.

          Determining the Position of the Cursor on the Screen.

          Many application programs (including JAWS) occasionally refer to 
          the position of the cursor relative to the screen, without regard
          to whatever text might appear on the screen.  In order to do 
          this, the screen is usually thought of as consisting of eighty
          columns across (from left to right) by twenty-five rows down
          (from top to bottom).  The leftmost column is considered column
          one and the rightmost column is considered column eighty.
          Similarly, the top row is considered row one and the bottom row
          is considered  row twenty-five.   Some  of the  new computers and
          video systems  allow more  than these dimensions, JAWS will sense
          the size of the screen and adjust accordingly.



          Speech Pad and Keyboard                           page - 23
          


          JAWS provides a function to report the cursor position in  such a
          "row, column"  format.  By pressing the Delete (Period or Decimal
          Point) key on the numeric pad (located just  to the  right of the
          Insert key),  the speech  device will report the current position
          of the cursor (for example, "Row 5, Column 65").



          Speech Pad and Keyboard                           page - 24
          

          THE JAWS CURSOR.

          An Extra "Read-Only" Cursor.

          JAWS provides a very powerful tool for reading text on the screen
          without disrupting the application program being run - the JAWS
          Cursor. Normally, when running an application program, the PC
          Cursor (the cursor provided by the PC) will be active and the
          speech functions described up to this point will affect it and
          will be DEPENDENT on it -  that  is,  if  an  application program
          restricts the  PC Cursor,  then it also restricts JAWS ability to
          read using  the PC  Cursor.   For example,  if you  are trying to
          enter data  into a  data base  and you  are at the beginning of a
          field, typing Insert-4 might not move the cursor to the next word
          to the left - it may just produce an error tone or it may back up
          to the previous field.  This  is because  the application program
          (in this case, a database) is controlling the PC Cursor.

          The  JAWS  Cursor  is  a  separate  cursor,  provided by JAWS and
          completely independent of  all  application  programs,  which may
          move anywhere on the screen reading any data which appears on 
          the screen.  Any data entered will be placed at the position of 
          the PC Cursor, but the JAWS Cursor can be moved anywhere reading
          data - without having any affect on the PC Cursor.  The best part
          is that all the cursor movement functions described up to this 
          point will function exactly as they were described and will use 
          the same keystrokes.

          To turn on the JAWS Cursor, press the Minus (or Dash) key  on the
          num pad  (usually located just to the right of the 9 (or Page Up)
          key).  The speech device will respond: "JAWS Cursor" and the JAWS
          Cursor  will  be  activated.    Now  all  the cursor movement and
          position functions  described  above  will  operate  on  the JAWS
          Cursor and  the PC  Cursor will remain where it was when the JAWS
          Cursor was activated.   To switch  back to  the PC  Cursor at any
          time, just press the Plus key on the numeric pad (usually located
          just below the Minus key).   When the  PC Cursor  is reactivated,
          the JAWS  Cursor will  remain where it was and will not be moved,
          regardless of the movements of the PC Cursor.



          Speech Pad and Keyboard                           page - 25
          

          The PC Cursor vs. The JAWS Cursor.

          As mentioned, the JAWS Cursor is provided by JAWS and is 
          therefore completely independent of any application program which
          might be run.  The PC Cursor, on the other hand, is completely 
          controlled by the application and, therefore, is totally 
          dependent on the application.  JAWS simply asks the application 
          to perform, for example, a Page Up operation.  The application 
          may refuse to cooperate or may move the cursor to some unexpected
          position.  JAWS will allow the application to finish doing what 
          is requested, and will then speak whatever is there.

          Some interesting and common exceptions to the basic cursor 
          movement functions described above include many word processors 
          which can give you the impression of a "topless" or a 
          "bottomless" screen.  For example, when you are located somewhere
          in the middle of a long document and repeatedly press the Up 
          Arrow (Prior Line) with the PC Cursor turned on, you will move to
          the top  of the  screen.   Then when  you press  the Up Arrow key
          again, the word processor may scroll the text on the screen down 
          and place a new line at the top, which will then be spoken.

          However, when the JAWS  Cursor is  turned on,  its range  will be
          limited  to  the  dimensions  of  the  screen and any application
          programs will not be affected by its movements.  The  JAWS Cursor
          cannot go  "above" the  top or  "below" the bottom of the screen.
          It can, however, wrap around the  left  and  right  edges  of the
          screen  -  for  instance,  performing a Next Word repeatedly will
          eventually bring you to the end of a line and then you  will wrap
          to the beginning of the next line.

          When the JAWS Cursor is on, the Home, End, Page Up, and Page Down
          keys have the following functions:  Home (the number 7) will move
          you to the beginning of the current line.  The cursor will not be
          moved up or down, only to the beginning of the line that the JAWS
          Cursor is  on.   The End  key (the number 1) will move you to the
          end of the current line. It will not move the cursor up  or down,
          only to the end of the line that the JAWS Cursor is on.  The Page
          Up key (the number 9) will move the JAWS Cursor  to the  top line
          of the screen (line 1).  Page Up will not move you to the left or
          the right, only to the top  line of  the screen.   Similarly, the
          Page Down  (the number  3) key  will move  the JAWS Cursor to the
          bottom of the screen (line 25), but not to the left or the right.



          Speech Pad and Keyboard                           page - 26
          

          The Position key (the Delete on  the  num  pad)  will  report the
          position  of  whichever  cursor  is  turned  on  at the time, the
          "Active" cursor.  If the Insert key is held down and the Position
          key is pressed, JAWS will report the position of whichever cursor
          is turned off, the "Inactive" cursor.  For  example, if  the JAWS
          Cursor is  on and  Insert-Delete is pressed, JAWS will report the
          position of the PC Cursor.

          Cursor Routing.

          Occasionally, it may be necessary to move the JAWS Cursor to the 
          location of the PC Cursor, or the PC Cursor to the location of 
          the JAWS Cursor.  For example, while editing a document with a 
          word processor, the JAWS Cursor can be used to move about the 
          screen reading the document.  If some text were found which 
          required change, the changes could not be made to it - the PC 
          Cursor would likely be positioned somewhere else on the screen 
          and any input would be placed there. At this point, a person 
          would want to move (or route) the PC Cursor to the position of 
          the JAWS Cursor, if possible.  

          JAWS provides  a function  called "Route  PC to  JAWS" which will
          attempt to move the PC Cursor to the location of the JAWS Cursor.
          To perform this operation, hold down the Insert key and press the
          PC Cursor key (the Plus on the numeric pad). JAWS will attempt to
          move the PC Cursor to the  position of  the JAWS  Cursor.   If it
          cannot, it will produce an error tone.

          Similarly, it  may also  be necessary to route the JAWS Cursor to
          the PC Cursor and JAWS handles this in much the same manner.   To
          perform the  function:   "Route JAWS  to PC" simply hold down the
          Insert key on the key pad and press the Minus (or Dash) key.  The
          speech device will respond:  "Route JAWS to PC".  However, unlike
          the Route PC to JAWS function, the Route  JAWS to  PC will always
          succeed.   This is  because the  movements of the JAWS Cursor are
          always independent of the application program.

          Neither routing function is dependent on which cursor is turned 
          on at the time.  When a cursor  is routed  it is  also turned on,
          e.g. if  "Route PC  to JAWS" is performed the PC cursor will also
          be turned on, and vice versa.

          "Control-" and "Alt-" Combinations.

          Many word processors use the "Control" key plus  a Left  or Right
          arrow  key,  or  a  Page  Up  or Page Down key to perform various
          cursor movement functions (such  as Control-Right  Arrow for Next
          Word or Control-Page Up to move to the top of a document).  These
          Control key combinations will function in exactly the same manner
          when JAWS is loaded and without regard to which cursor is active,

          Speech Pad and Keyboard                           page - 27
          

          but  they   will  function   without  speech.   All  Control  key
          combinations will  be passed directly to the application and thus
          will operate on  only  the  PC  Cursor.    Remember  that  we are
          referring  to  the  default  keyboard  configuration,  things can
          change depending on the desires of the user and the  macros being
          used.

          Similarly, using "Alt" plus a cursor movement key to pass the
          original, unaltered cursor movement keys to the application
          program will essentially bypass JAWS.  The keys will be passed
          directly to the application program, will not cause anything to
          be spoken, and will operate only on the PC Cursor.  Again, we are
          assuming the default configuration.

          If the Alt key is  pressed  by  itself,  it  will  function  as a
          "Silence" key - whatever is being spoken will be silenced.
          EXTRA SPEECH PAD FUNCTIONS.

          Spelling and Phonetically Spelling Words.

          Spelling the words which appear on the screen can be very helpful
          should the speech device mispronounce something  or should  it be
          necessary to  check the  spelling of  words in  a letter or other
          document.  So far, the only way to  spell a  word is  to move the
          cursor across  the word,  one character at a time, using the Next
          Character key.  JAWS does, however, provide a tool which can make
          this common activity much easier.  

          To spell the word which the active cursor is on, simply press the
          Say Word (Insert-5) key twice within a second.  The speech device
          will then spell the entire word, from beginning to end, character
          by character.    Spelling  a  word  will  also  place  JAWS  in a
          temporary  "Spell  Word"  mode.    This  means  that a Prior Word
          (Insert-4) or a Next Word  (Insert-6)  operation  will  cause the
          cursor to  move to  the prior  or next  word and  then spell that
          word.  To leave the temporary Spell Word  mode, simply  press any
          key other  than Prior  Word or  Next Word  - such as the Say Word
          key.  When a word is spelled the  upper or  lower case  status is
          conveyed by changes in pitch or by saying "CAP".

          For someone who is just learning to use JAWS, the speech produced
          by the  synthesizer may  not always  be understandable.   To help
          overcome  this,  JAWS  also  provides a Phonetic Spell which will
          "spell"  individual  characters.    Phonetically  spelling  means
          saying Alpha for A, Bravo for B, Charlie for C, and so forth.  If
          the character is an extended ASCII or control  character (graphic
          character) its decimal value will be spoken.



          Speech Pad and Keyboard                           page - 28
          

          Accessing the "Phonetic Spell" feature of JAWS is very similar to
          the way the Spell  Word  feature  is  accessed.    To  access the
          Phonetic  Spell  feature,  simply  press  the  Say Character (the
          number 5)  key twice  within a  second.   This will "Phonetically
          Spell" the  character that the active cursor is on and similarly,
          place JAWS in a temporary "Phonetic  Spell" mode.   The temporary
          Phonetic Spell  mode functions  similarly to  the temporary Spell
          Word mode,  only  it  operates  on  characters  -  pressing Prior
          Character or  Next Character  will move  the active cursor to the
          prior or  next character  and phonetically  spell that character.
          To leave  the temporary  Phonetic Spell mode, simply type any key
          other than the Prior Character or Next Character  keys -  such as
          the Say Character key.

          Application Program Status Lines and Screen Reading.

          Many application programs use either the top or bottom lines of 
          the screen as status lines.  Word Perfect, for example, uses the 
          bottom line of the screen (line 25) as a status line to report 
          the page and line that the cursor is on within a document while 
          WordStar uses the top line of the screen for the status line.  
          JAWS has included two functions for reading these lines. To read 
          the top  line of  the screen,  hold down the Insert key and press
          the number 1 key on the numeric pad (the End key) - the speech 
          device will read the contents of line one.  To read the bottom 
          line of the screen, hold down the Insert key and press the number
          3 on the numeric pad (the Page Down key) - the speech device 
          will  read  the  contents  of  line twenty-five.  The status line
          reading functions are not dependent on which cursor  is turned on
          at the  time.   They are  macros that perform "Read line x", they
          can be easily changed to read whatever line or lines you want, or
          perform any other function.

          Another  frequently  needed  feature  is  the ability to read the
          entire screen.  Since JAWS uses a Insert-1  to read  the top line
          of  the  screen  and  a  Insert-3  to read the bottom line of the
          screen, it seems natural  for  the  key  that's  in  between (the
          Insert-2) to  read the  whole thing - the entire screen.  This is
          exactly the  function that  the Insert-2  will perform  - it will
          read everything on the screen.  If a line is blank, there will be
          a slight pause before the next line is  spoken.   The read screen
          function is dependent on which cursor is active.



          Speech Pad and Keyboard                           page - 29
          

          If the JAWS Cursor is active, the Insert-2 will read the contents
          of the screen beginning at the JAWS Cursor's position and working
          downward.    The  reading  will  continue  until  the JAWS Cursor
          reaches the bottom of the screen  or  until  the  control  key is
          pressed to  interrupt the speaking.  When the speaking stops, the
          JAWS Cursor will be positioned either at the bottom of the screen
          or on  the line  which was  being read  when the  control key was
          pressed.

          If the PC Cursor is active,  a Insert-2  will begin  reading from
          the current  cursor position  and will  move the  cursor down one
          line at  a time,  reading each  line it  moves to.   This feature
          could be  quite useful  when using  JAWS with a word processor to
          read a letter, manual, or other  text file  - by  starting at the
          top of  the document  with the PC Cursor on and doing a Insert-2,
          the entire document can be read.  

          The ability of most word processors to provide an infinitely long
          or "bottomless" screen will come into play as the PC Cursor moves
          downward - new lines will  continually  scroll  onto  the screen.
          JAWS will  keep reading the file as long as new lines continue to
          scroll onto the screen.  The reading will continue as long as the
          word processor  is able to scroll the screen or until the control
          key is pressed to interrupt  the  speaking.    When  the speaking
          stops, the  cursor will be left either at the end of the document
          or on the line where it was positioned  when the  control key was
          pressed.

          While reading  a document  this way  the alt  key can  be used to
          silence the voice and scan ahead  rapidly.    Press  the  alt key
          again to  turn the  voice back  on.   You can stop the reading by
          pressing the control key, or just  about any  key other  than the
          alt, the insert, or the down arrow.

          Adjusting the Volume, Rate, and Pitch of Synthesizer Speech.

          The JAWS  Menu System  provides the ability to adjust the volume,
          rate, and pitch for  the  speaking  of  characters  typed  at the
          keyboard  and  for  text  read  from  the  screen  by  speech pad
          functions.  The "Keyboard Echo Menu" will allow the volume, rate,
          and pitch  to be  adjusted for  characters typed at the keyboard.
          The "Speech Pad Echo Menu" will allow the volume, rate, and pitch
          to  be  adjusted  for  text  read  from the screen by the various
          speech pad operations.  For further information concerning either
          of  these  menus,  refer  to  the chapter of this manual entitled
          "The JAWS Menu System".



          Speech Pad and Keyboard                           page - 30
          

          NUMBERS ROW FUNCTIONS.

          As was mentioned earlier, JAWS also makes use of several keys on
          the numbers row (the numeric keys located just above the Q W  E R
          T Y  row of  keys on  the keyboard).   These keys perform several
          important  but  less  frequently  used  functions.    Numbers row
          functions are  all accessed by holding down the Insert key on the
          numeric keypad  and pressing  one of  the numbers  on the numbers
          row.

          Help Mode.

          Holding  down  the  Insert  key  and pressing the number 1 on the
          numbers row will activate or deactivate the JAWS Help Mode.  When
          Insert-1 is  pressed the  first time,  JAWS will turn on the Help
          Mode and the speech device will  respond: "Help  Mode On".   When
          Help Mode is active, JAWS will speak only the labels of whichever
          keys are typed and  will not  move either  cursor or  release any
          character that  might be typed to the application.  To deactivate
          help mode, simply type Insert-1 again and the  speech device will
          respond: "Help  Mode Off".   Help  mode can  be quite useful when
          trying to "get acquainted" with an unfamiliar keyboard.

          Pass Key to Application.

          Holding down the Insert key and pressing the 3 on the numbers row
          will activate the JAWS "Pass Key Through" function.  The next key
          pressed will be passed directly to the application - it will not 
          perform any JAWS function which might be assigned to that key.  
          This feature could be quite useful when working with other 
          Terminate and Stay Resident (TSR) programs which might utilize 
          some of the same key combinations that JAWS uses.  The feature 
          can occasionally prove useful in certain rare cases when using 
          macros (refer to the chapter of this manual entitled "Macros").

          Screen Enhancements.

          Holding down the Insert key and pressing the 5 on the numbers row
          will cause the speech device to report the screen enhancement or 
          color at the current active cursor position.  The responses 
          produced by this command will vary depending on the type of 
          monitor which is being used.  If a color monitor is attached to 
          the  computer,  JAWS  will  sense  that  and a Insert-5 will then
          report the  color of  the screen  under the  cursor (black, blue,
          red, green,  etc.).  The foreground and background colors will be
          spoken On the other hand, if a monochrome  monitor is  used, JAWS
          will  report  the  type  of  monochrome  enhancement found at the
          cursor position (Intense, Normal,  Reverse, Underlined, Blinking,
          etc.).  For further information concerning enhancements, refer to
          the chapter of this manual entitled:  "Enhancements".

          Speech Pad and Keyboard                           page - 31
          

          "Say Field" Mode.

          Holding down the Insert key and pressing the 6 on the numbers row
          will  either  activate  or  deactivate the JAWS "Say Field" mode.
          Normally, Say Field mode is turned off.  The first  time Insert-6
          is pressed,  the speech  device will respond:  "Field On" and the
          Say Field mode will  be  enabled.    The  next  time  Insert-6 is
          pressed,  Say  Field  mode  will  be  disabled.  In this context,
          "Field" refers to a group of  characters or  words on  the screen
          that are all of the same color or enhancement.

          When Say  Field mode  is on,  Prior Word, Say Word, and Next Word
          become Prior Field, Say Field, and  Next  Field.    This  mode of
          operation  can  be  very  useful  when  working  with application
          programs which either use  "Color bars"  or "enhanced"  fields or
          areas of  the screen  to indicate  current selections, errors, or
          various other important items of information.

          Change Routing.

          The "Controls" setting of JAWS assumes that the  application uses
          the standard Control Left Arrow and Control Right Arrow for prior
          and next word respectively.   Unfortunately,  this is  not always
          the  case.    To  accommodate  many  of  these applications, JAWS
          provides an alternative way to move the cursor  to the  prior and
          next  words.    By  holding  down the Insert key and pressing the
          number 7 on the numbers row, JAWS will switch to "Singles".  This
          feature  can  be  quite  useful  with  some  word  processors and
          spreadsheets.  It is  especially useful  when performing terminal
          emulation,  since  it  simulates  the  next  word  and prior word
          functions on a main  frame.    By  pressing  Insert-7  again, the
          original routing method will be used.

          Read  line  X:  Press  Control-space  bar,  then  enter  a letter
          corresponding to the line you want to read: a=1, b=2,  y=25, etc.
          You  can  also  enter  a  number:  1 digit followed by enter or 2
          digits.

          Macros:  Refer to the chapter on Macros to learn how to  move the
          JAWS functions to other keys, if you want, and/or record powerful
          combinations of functions to make life easier.



          Speech Pad and Keyboard                           page - 32
          

          Extended Keyboards.

          JAWS will work fine on the extended keyboards, also known as 101-
          key boards.  These have an extra set of arrow keys and cursor pad
          keys, located between the  numeric pad  and the  typewriter keys.
          You  will  probably  find  that  "extra" keys perform the same as
          their counterparts on the  numeric/cursor pad.   At  some time in
          the future JAWS will be able to distinguish these keys from their
          counterparts, providing an extra set of keys to perform different
          functions.



          Speech Pad and Keyboard                           page - 33
