static char *header = "\n\
                                                                            \n\
/*                                                                          \n\
 *	vifs.c  --  View an Iterated Function System.                       \n\
 *	Theory from M. Barnsley 'Fractals Everywhere' (ISBN 0-12-079062-9). \n\
 *                                                                          \n\
 *	4 june 1989  Olle Olsson  (olle@ergodata.se).                       \n\
 */                                                                         \n\
                                                                            \n\
                                                                            \n\
";

#include <conio.h>
#include <dos.h>
#include <process.h>
#include <string.h>
#include "ifs.h"
#include "gmtc.h"
#include "getkey.h"

/* max number of transforms */
#define NTRANSF 50

/* max group index */
#define MAXGROUP (NTRANSF/2)

/* a mouse graphics cursor shape */
struct gm_gcurs gcu =
	{
	7, 7,			/* horizontal and vertical hot spot */
		{		/* screen mask */
		0   /* initialized by the program */
		},
		{		/* cursor mask */
		0x00, 0x00, 0x00, 0x00,
		0x10, 0x10, 0x10, 0xfe,
		0x10, 0x10, 0x10, 0x00,
		0x00, 0x00, 0x00, 0x00
		}
	};

static void usage( void );

static void usage( void )
{
/* this is probably going to clear the screen */
sleep( 1 );
endshow();

printf( "Usage:\n" );
printf( "\tvifs [options] ifs_data_file\n" );
printf( "Options are:\n" );
printf( "\t-e\t\tedit mode (mouse required)\n" );
printf( "\n" );
}

/* the transformations */
static transform trf[NTRANSF];	/* (could have been a linked list...) */

/* the colors (palette) */
static rgb colors[MAXCOLORS + 1];

void main( argc, argv )
int argc;
char *argv[];
{
FILE *inf;			/* data file */
ifsdes dd;			/* ifs descriptor */
int edmode;			/* show/iterate flag */
int trace;			/* trace flag */
int mouse;			/* mouse flag */
int i, c;			/* tmp */
int running;			/* flag */
char datafile[100];		/* data file name */
char *ap, **p;			/* argument pointers */
struct gm_status gs;		/* for getkey() */

/* advertise */
printf( header );
sleep( 1 );

/* initialize */
dd.tp = trf;
dd.maxsize = NTRANSF;
dd.colors = colors;
dd.clrsize = sizeof (colors) / sizeof (colors[0]);
dd.textcolor = dd.clrsize - 1;
dd.prrdens = 0;
dd.maxgroup = MAXGROUP;

/* set up */
initshow();

/* is there a mouse ? (gm_init() in graphics mode!) */
if (!(mouse = gm_init()))
	{
	printf( "The mouse has escaped, get another one!\n\n" );
	/*sleep( 2 );*/
	}
else
	{
	/* change the mouse cursor */
	/* first initialize the screen mask */
	for (i = 0; i < sizeof (gcu.gm_cumask) / sizeof (gcu.gm_cumask[0]); ++i)
		gcu.gm_scmask[i] = ~gcu.gm_cumask[i];

	gm_defg( &gcu );
	}

/* restore to text mode for error exits */
/*restorecrtmode(); this confuses the mouse driver */


/* read arguments */
datafile[0] = '\0';
trace = edmode = 0;
for (p = argv + 1, c = 1; c < argc; ++c)
	{
	if (trace) printf( "%s:\n", *p );
	ap = *p++;

	if (*ap == '-')	for (i = 1; ap[i]; ++i) switch (ap[i])
		{
/*		case 'u':
			if (++c >= argc)
				error(
			 "-u: upper limit for transformation count missing");

			if ((maxsize = atoi( *p++ ) ) < 2)
				error( "upper limit %d is too low", maxsize );

			continue;
*/

		case 't':
			trace++;
			continue;

		case 'e':
			if (mouse) edmode++;
			else error( "edit isn't possible without a mouse" );
			continue;

		default:
			usage();
			error( "don't understand flag '-%c'", ap[i] );
		}
	else if (!datafile[0])
		{
		strcpy( datafile, ap );
		}
	else
		{
		usage();
		error( "too many data files specified" );
		}
	}

/* open the data file */
if (!datafile[0])
	error( "No IFS data file specified" );

if ((inf = fopen( datafile, "r" )) == NULL)
	error( "Can't open input file '%s'", datafile );

/* read the description */
rdescr( inf, &dd, trace );
fclose( inf );

/* set the text color */
dd.colors[dd.textcolor].r = dd.colors[dd.textcolor].g =
dd.colors[dd.textcolor].b = 2;

if (trace) printf( "(imeasm:%d)\n", dd.im );

if (trace)
	{
	printf( "(trace, esc to quit)\n" );
	if (getch() == '\033') error( "trace exit" );
	cleardevice();
	}

for (running = 1; running;)
	{
	if (edmode)
		{
		/* edit mode */
		if (!(running = edtrans( &dd, trace )))
			break;
		}
	else running = 0;

	/*setgraphmode( grmode ); this confuses the mouse driver,
	 * do cleardevice() instead */
	cleardevice();

	/* set up the palette */
	palsetup( &dd );

	/* show the fractal */
	if (mouse) wbup();
	ifsshow( &dd, mouse ? gotkey : kbhit, 0, putpixel, getpixel );

	/* ready, beep */
	beep();

	/* if ifsshow() was stopped: clear keyboard  (no echo) */
	if (mouse) while (gotkey())
		{
		wbup();
		(void) getkey( &gs );
		}
	else while (kbhit())
		(void) getch();

	/* wait for a (possibly second) key */
	if (mouse)
		{
		wbup();
		(void) getkey( &gs );
		}
	else (void) getch();
	}

endshow();

exit( 0 );
}

void beep()
{
printf( "\007" );
}

void error( s, v1, v2, v3, v4, v5, v6, v7, v8, v9, v10 )
char *s;
int v1, v2, v3, v4, v5, v6, v7, v8, v9, v10;
{
/* this is probably going to clear the screen */
sleep( 1 );
endshow();

fprintf( stderr, "\nError:" );
fprintf( stderr, s, v1, v2, v3, v4, v5, v6, v7, v8, v9, v10 );
fprintf( stderr, "\n" );

exit( 2 );
}

void warning( s, v1, v2, v3, v4, v5, v6, v7, v8, v9, v10 )
char *s;
int v1, v2, v3, v4, v5, v6, v7, v8, v9, v10;
{
fprintf( stderr, "\nWarning:" );
fprintf( stderr, s, v1, v2, v3, v4, v5, v6, v7, v8, v9, v10 );
fprintf( stderr, "\n" );
}

