/******************************* vga13.cpp **********************************/
/*	Author: Don Lewis                                                       */
/*  Date:	February 25, 1993                                               */
/*  Description:                                                            */
/* 				This Program is for demonstrating 15, 16 and 24bit colour   */
/* VESA boards capabilities. This program is for purposes of demonstration  */
/* only. It is not shareware. It is freeware. While Randy Buckland wrote a  */
/* 256 color demo in 'C' this program only maintains Randy's original 'C'   */
/* functions for your exercise. Much credit goes to Randy Buckland for his  */
/* efforts. The assembly code vga24.asm is originally Randy Bucklands code. */
/* I have modified it heavily and am redistributing it as vga24.asm. The    */
/* 'VESA24.EXE' distribution is a compilation of 'vesa24.cpp', 'vheader.h'  */
/* and 'vga24.asm'. I hope you enjoy and further develop this code and      */
/* continue to offer it as freeware so that others might benefit from our   */
/* efforts. Borlandc 3.1 assembler and compiler were used for development.  */
/****************************************************************************/
#pragma inline

#include "conio.h"
#include "dos.h"
#include "stdlib.h"
#include "stdio.h"
#include "dos.h"
#include "process.h"
#include "string.h"
#include <e:\borlandc\cprogs\veinfo.cpp>

struct info;
struct modeinfo;

ReturnCurrentMode(int curmode);
void SetSvgaMode(int);
void GetSvgaInfo(void);
void ReturnSvgaMode(int);
void tone(void);
void PutPixelDemo(unsigned char);
void FillAreaDemo(unsigned char, int);

void VesaInformation(void);
void GetSvgaInfo(void);
void ReturnSvgaMode(int nmode);
ReturnCurrentMode(int curmode);
void SetSvgaMode(int nmode);
void writeText(int x,int y,unsigned char *str);

/* These r,g,b functions will work with std 256 color SVGA
   just use the 0-255 byte color value in 'r' and '0's in 'g','b'.
   Green and blue are ignored. Don Lewis */
extern "C" {void vgapoint_rgb(int row, int column,
		 unsigned char r, unsigned char g, unsigned char b);}
extern "C" {void vgaline (short row1, short col1, short row2, short col2,
		 unsigned char r, unsigned char g, unsigned char b);}
extern "C" {void vgafill (short row, short column, short width,short height,
		 unsigned char r, unsigned char g, unsigned char b);}

/* These std 256 color (only) VGA functions are still supported. */
/* Still SVGA 8bit mode functions */
extern "C" {void vgainit (short vesamode);} /* Works for any VESA mode */
extern "C" {void vgasetcolor(unsigned char[256][3], int, int);}
extern "C" {void vgapoint (short row, short column, unsigned int pixel);}
extern "C" {void vgarect (unsigned char *data, short linewidth,
		  short row, short col, short width, short height);}
/* I have'nt modified or tested these functions. Don Lewis */
extern "C" {void vgarect2 (unsigned char *data, short linewidth,
		   short row, short col, short width, short height);}
extern "C" {void vgasync ();}
extern "C" {void vgatext (short row, short col, char *text,
		  unsigned char fg, unsigned char bg);}
extern "C" {short vgagetbutton();}

long	maxcolor = 0xFFFFFF,defcolor = 0x9f9f00;
/****************************************************************************
*
*	SEG(p)		Evaluates to the segment portion of an 8086 address.
*	OFF(p)		Evaluates to the offset portion of an 8086 address.
*	FP(s,o)		Creates a far pointer given a segment offset pair.
*	PHYS(p)		Evaluates to a long holding a physical address
*
****************************************************************************/
#		define SEG(p)	( ((unsigned *)&(void far *)(p))[1] )
#		define OFF(p)	( (unsigned)(p) )
#		define FP(s,o)	( (void far *)( ((unsigned long)s << 16) +	\
						  (unsigned long)o ))
#		define PHYS(p)	( (unsigned long)OFF(p) +						\
						  ((unsigned long)SEG(p) << 4))


void main()
{
   unsigned char buf[80];
   unsigned char inc;
   unsigned int i,j,x,r,g,b;
   int curmode, OldMode, NewMode;
   OldMode = ReturnCurrentMode(curmode);
   clrscr();
   VesaInformation();
   printf("Enter a 15, 16 or 24bit VESA mode in (hex) ei; 110<ret>\n");
   scanf("%x", &NewMode);
   printf("At the tone. . .");
   delay(1000);
   tone();
   printf(" the present routine is finished. \n");
   printf("Hit any key (which one is that) to continue.\n");
   getch();
   vgainit (NewMode); /* use vga24.asm init function */
   GetSvgaInfo();     /* retrieves all kinda good info */
   ReturnSvgaMode(NewMode); /* retrieves even more great stuff */
   if ( modeinfo.BitsPerPixel < 15 )
   {
	   SetSvgaMode(OldMode);
	   printf(" Sorry, This program does not use 4 or 8 bit per pixel modes.\n");
	   exit(1);
   }
/* 15 bit per pixel example:
   The color range per pixel is 0-31 decimal which is equivalent
   to 0 - 1F hex.                                                */
   if (modeinfo.BitsPerPixel == 15)
   {
	inc = 31;
	PutPixelDemo(inc); /* plot some random pixels */
	vgafill(0,0,modeinfo.XResolution,modeinfo.YResolution,0,20,20);
	vgaline(0,0,modeinfo.YResolution,modeinfo.XResolution,31,20,31);
	vgaline(0,modeinfo.XResolution,modeinfo.YResolution,0,20,31,20);
	FillAreaDemo(inc, NewMode);
   }
/* 16 bit per pixel example:
   The color range per pixel is 0-31 decimal for red and blue, 0 - 62 decimal
   for green which is equivalent to 0 - 1F hex for red and blue, 0 - 3F hex
   for green. A handy way to approximate green level the same as blue or red
   is to double the red or blue value for green. Example, BRIGHT YELLOW
   is red = 31 decimal and green = 62 decimal.		*/
   if (modeinfo.BitsPerPixel == 16)
   {
	   inc = 31;
	   PutPixelDemo(inc);
	   vgafill(0,0,modeinfo.XResolution,modeinfo.YResolution,25,0,20);
	   vgaline(0,0,modeinfo.YResolution,modeinfo.XResolution,10,50,10);
	   vgaline(0,modeinfo.XResolution,modeinfo.YResolution,0,0,0,0);
	   FillAreaDemo(inc, NewMode);
   }
/* 24 bits per pixel example:
   Here all three colors range from 0 - 255 decimal or 0 - FF hex offering
   color choices out of a 16,777,216 million color pallette.     */
   if (modeinfo.BitsPerPixel == 24)
   {
	   inc = 255;
	   PutPixelDemo(inc);
	   vgafill(0,0,modeinfo.XResolution,modeinfo.YResolution,50,100,70);
	   vgaline(0,0,modeinfo.YResolution,modeinfo.XResolution,150,200,150);
	   vgaline(0,modeinfo.XResolution,modeinfo.YResolution,0,200,150,200);
	   FillAreaDemo(inc, NewMode);
	}

/* 	Restore original video mode before program exit.  */
	SetSvgaMode(OldMode);
}

/*									*/
/*	PUTPIXELDEMO: Display a pattern of random dots on the screen	*/
/*	and pick them back up again. From Borland's BGIDEMO.C		*/
/*	Modified by Don Lewis for Hi-color and 24 bit modes.    	*/

void PutPixelDemo(unsigned char cinc)
{
  int seed = 1953;			/* use the year I was born */
  int i, ginc, x, y, h, w, color[3];

  w = modeinfo.YResolution;
  h = modeinfo.XResolution;

  srand( seed );			/* Restart random # function	*/
  if ( modeinfo.BitsPerPixel == 16)
	 ginc = 31;
  else
	 ginc = 0;
  for( i=0 ; i<3000 ; ++i ){		/* Put 3000 pixels on screen	*/
	x = 1 + random( h - 1 );	        /* Generate a random location	*/
	y = 1 + random( w - 1 );
	color[0] = random( cinc );         /* Generate random colors       */
	color[1] = random( cinc + ginc );
	color[2] = random( cinc );
	/* Write pixel to BLACK  background	*/
	vgapoint_rgb( y, x, color[0], color[1], color[2] );
  }
  tone();
  getch();				/* Wait for user's response     */

}
void FillAreaDemo(unsigned char cinc, int mode)
{
	int i, j, ginc, xcnt, ycnt, width, height;
	ycnt = modeinfo.YResolution/2;
	xcnt = modeinfo.XResolution/2;
	width = modeinfo.XResolution/(cinc+1);
	/* adjust for more color and fewer lines */
	if (modeinfo.BitsPerPixel == 16) ginc = 2; /* make green hotter */
	else ginc = 1;
	if ( mode == 0x010F || mode == 0x112)
		height = (ycnt-(cinc/8)) / ((cinc/8)/2);
	else
		height = (ycnt-(cinc+1)) / ((cinc+1)/2);
	for (i=0; i<= cinc; i++)
	{
	   vgafill( 0*height,i*width,width,height,i,0,0);
	   vgafill( 1*height,i*width,width,height,0,i*ginc,0);
	   vgafill( 2*height,i*width,width,height,0,0,i);
	   vgafill( 3*height,i*width,width,height,cinc,i*ginc,0);
	   vgafill( 4*height,i*width,width,height,cinc,0,i);
	   vgafill( 5*height,i*width,width,height,0,cinc*ginc,i);
	   vgafill( 6*height,i*width,width,height,i,i*ginc,0);
	   vgafill( 7*height,i*width,width,height,0,i*ginc,i);
	   vgafill( 8*height,i*width,width,height,i,0,i);
	   vgafill( 9*height,i*width,width,height,i,cinc*ginc,cinc);
	   vgafill(10*height,i*width,width,height,cinc,i*ginc,cinc);
	   vgafill(11*height,i*width,width,height,cinc,cinc*ginc,i);
	   vgafill(12*height,i*width,width,height,i,i*ginc,cinc);
	   vgafill(13*height,i*width,width,height,cinc,i*ginc,i);
	   vgafill(14*height,i*width,width,height,i,cinc*ginc,i);
	   vgafill(15*height,i*width,width,height,i,i*ginc,i);
	   vgafill(30*height,i*width,width,height,i,0,cinc);
	   vgafill(31*height,i*width,width,height,0,i*ginc,cinc);
	   vgafill(32*height,i*width,width,height,i,cinc,0);
	}
	tone();
	getch();
/* put as many colors as we can on the screen. . . Not finished. */
/* 32k and 64k colors show too little, 16mil color mode shows too much */
	for (j=0; j<=cinc; j++)
		for (i=0; i<=cinc; i++)
		{
		vgapoint_rgb(ycnt-i,xcnt-j,0,j*ginc,i);   /* top left     */
		vgapoint_rgb(ycnt+i,xcnt-j,i,j*ginc,i);   /* bottom left  */
		vgapoint_rgb(ycnt+i,xcnt+j,j,i*ginc,i);   /* bottom right */
		vgapoint_rgb(ycnt-i,xcnt+j,j,0,i);        /* top right    */
		}
	writeText(20,100,"******** END OF TEST ********");
	tone();
	getch();
}

void writeText(int x,int y,unsigned char *str)
{
	unsigned char	byte;
	int		i,j,k,length,ch;
	unsigned char	far *_font;

	asm {				/* Bloody inline assembly - we need it here tho	*/
		push	bp
		mov		bh,0x06;
		mov		ax,0x1130;
		int		0x10;
		mov		ax,es;
		mov		bx,bp;
		pop		bp;
		mov		i,ax;
		mov		j,bx;
		}
	_font = (unsigned char *)MK_FP(i,j);

	length = strlen(str);
	x = ( modeinfo.XResolution - (length * modeinfo.XCharSize)) / 2;
	for (k = 0; k < length; k++) {
		ch =  str[k];
		for (j = 0; j < 16; j++) {
			byte = *(_font + ch * 16 + j);
			for (i = 0; i < modeinfo.XCharSize; i++) {
				if ((byte & 0x80) != 0)
					vgapoint_rgb(y+j,x+i,2*j,0,0);
				byte <<= 1;
				}
			}
		x += modeinfo.XCharSize;
		}
}
