/****************************************************************************
*
*						   SuperVGA Test Library
*
*                   Copyright (C) 1993 Kendall Bennett.
*							All rights reserved.
*
* Filename:		$RCSfile: test256.c $
* Version:		$Revision: 1.2 $
*
* Language:		ANSI C
* Environment:	IBM PC (MSDOS)
*
* Description:	Simple program to test the operation of the SuperVGA
*				bank switching code and page flipping code for the
*				256 color SuperVGA video modes.
*
*				MUST be compiled in the large model.
*
* $Id: test256.c 1.2 1993/03/07 04:06:11 kjb Exp $
*
* Revision History:
* -----------------
*
* $Log: test256.c $
* Revision 1.2  1993/03/07  04:06:11  kjb
* Bug fixes.
*
* Revision 1.1  1993/03/03  10:30:09  kjb
* Initial revision
*
****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <conio.h>
#include "svga256.h"

/*---------------------------- Global Variables ---------------------------*/

int		x,y,maxcolor = 255,defcolor = 15;
int		driver = grDETECT,chipID,memory,dac,mode;

extern char *version;

/* External routines */

void _copyTest(void);
void parseArguments(int argc,char *argv[]);

/*----------------------------- Implementation ----------------------------*/

void writeText(int x,int y,uchar *str)
/****************************************************************************
*
* Function:		writeText
* Parameters:	x,y		- Position to begin drawing string at
*				str		- String to draw
*
* Description:	Draws a string using the BIOS 8x16 video font by plotting
*				each pixel in the characters individually. This should
*				work for all video modes.
*
****************************************************************************/
{
	uchar			byte;
	int				i,j,k,length,ch;
	uchar			far *_font;
	struct REGPACK	regs;

	regs.r_ax = 0x1130;
	regs.r_bx = 0x0600;
	intr(0x10,&regs);
	_font = FP(regs.r_es,regs.r_bp);

	length = strlen(str);
	for (k = 0; k < length; k++) {
		ch = str[k];
		for (j = 0; j < 16; j++) {
			byte = *(_font + ch * 16 + j);
			for (i = 0; i < 8; i++) {
				if ((byte & 0x80) != 0)
					putPixel(x+i,y+j,defcolor);
				byte <<= 1;
				}
			}
		x += 8;
		}
}

void moireTest(void)
/****************************************************************************
*
* Function:		moireTest
*
* Description:	Draws a simple Moire pattern on the display screen using
*				lines, and waits for a key press.
*
****************************************************************************/
{
	uchar	buf[80];
	int		i;

	clear();
	for (i = 0; i < maxx; i += 10) {
		line(maxx/2,maxy/2,i,0,i % maxcolor);
		line(maxx/2,maxy/2,i,maxy,(i+1) % maxcolor);
		}
	for (i = 0; i < maxy; i += 10) {
		line(maxx/2,maxy/2,0,i,(i+2) % maxcolor);
		line(maxx/2,maxy/2,maxx,i,(i+3) % maxcolor);
		}

	if (maxx != 319) {
		x = 80;
		y = 80;
		writeText(x,y,"Bank switching test");	y += 32;
		sprintf(buf,"Video mode: %s",MGL_modeName(mode));
		writeText(x,y,buf);	y += 16;
		sprintf(buf,"Maximum x: %d, Maximum y: %d, BytesPerLine %d, Pages: %d",
			maxx,maxy,bytesperline,maxpage+1);
		writeText(x,y,buf);	y += 32;
		writeText(x,y,"You should see a colorful Moire pattern on the screen");
		y += 16;
		}
	else {
		x = 40;
		y = 40;
		}
	writeText(x,y,"Press any key to continue");
	y += 32;
	getch();
}

void readWriteTest(void)
/****************************************************************************
*
* Function:		readWriteTest
*
* Description:	Test the separate read/write bank routines if available.
*				We do this by copying the top 100 scanlines of video memory
*				to another location in video memory.
*
*				This test is desgined to work only in 640 wide video modes.
*
****************************************************************************/
{
	if (twobanks && (maxx == 639)) {
		_copyTest();
		writeText(x,y,"To test the separate read/write banks, the top 100 scanlines of");
		y += 16;
		writeText(x,y,"this display page should be moved to start at scanline 205.");
		y += 16;
		writeText(x,y,"This ensures that a bank boundary will have been crossed");
		y += 78;
		writeText(x,y,"Press any key to continue");
		getch();
		}
}

void pageFlipTest(void)
/****************************************************************************
*
* Function:		pageFlipTest
*
* Description:	Animates a line on the display using page flipping if
*				page flipping is active.
*
****************************************************************************/
{
	int		i,j,istep,jstep,color,apage,vpage;
	char	buf[80];

	if (maxpage != 0) {
		vpage = 0;
		apage = 1;
		setActivePage(apage);
		setVisualPage(vpage);
		i = 0;
		j = maxy;
		istep = 2;
		jstep = -2;
		color = 15;
		while (!kbhit()) {
			setActivePage(apage);
			clear();
			sprintf(buf,"Page %d of %d", vpage+1, maxpage+1);
			if (maxx == 319) {
				writeText(0,80,"Page flipping - should be no flicker");
				writeText(0,100,buf);
				}
			else {
				writeText(80,80,"Page flipping - should be no flicker");
				writeText(80,100,buf);
				}
			line(i,0,maxx-i,maxy,color);
			line(0,maxy-j,maxx,j,color);
			vpage = ++vpage % (maxpage+1);
			setVisualPage(vpage);
			apage = ++apage % (maxpage+1);
			i += istep;
			if (i > maxx) {
				i = maxx-2;
				istep = -2;
				}
			if (i < 0)	i = istep = 2;
			j += jstep;
			if (j > maxy) {
				j = maxy-2;
				jstep = -2;
				}
			if (j < 0)	j = jstep = 2;
			}
		getch();				/* Swallow keypress */
		}
}

void testingComplete(void)
/****************************************************************************
*
* Function:		testingComplete
*
* Description:	Clears the first display page and puts up a message.
*
****************************************************************************/
{
	setActivePage(0);
	setVisualPage(0);
	clear();

	if (maxx == 319) {
		writeText(0,40,"Testing complete");
		writeText(0,60,"press any key to return to text mode");
		}
	else
		writeText(80,80,"Testing complete - press any key to return to text mode");
	getch();
}

void main(int argc,char *argv[])
{
	int		i,choice,maxmenu,result;
	int		menu[20];
	char	buf[80];

	parseArguments(argc,argv);
	initSuperVGA(&driver,&chipID,&memory,&dac);

	while (true) {
		clrscr();
		printf("256 color SuperVGA Test Program (Version %s)\n\n",version);
		printf("Video Card: %s ",MGL_driverName(driver));
		if (driver > grSVGA && MGL_chipsetName(driver,chipID))
			printf("(%s)",MGL_chipsetName(driver,chipID));
		printf("\n");
		printf("Memory:     %dk\n",memory);
		printf("Video DAC:  %s\n",MGL_dacName(dac));
		printf("\n");
		printf("Separate read/write banks: %s\n", twobanks ? "Yes" : "No");
		printf("Extended page flipping:    %s\n", extendedflipping ? "Yes" : "No");
		printf("\n");
		printf("Which video mode to test:\n\n");

		i = maxmenu = 0;
		while (modeList[i] != -1) {
			/* Filter out the 256 color video modes */

			switch (modeList[i]) {
				case grVGA_320x200x256:
				case grSVGA_640x350x256:
				case grSVGA_640x400x256:
				case grSVGA_640x480x256:
				case grSVGA_800x600x256:
				case grSVGA_1024x768x256:
				case grSVGA_1280x1024x256:
					printf("    [%2d] - %s (%d page)\n",maxmenu,
						MGL_modeName(modeList[i]),
						MGL_availablePages(driver,memory,modeList[i]));
					menu[maxmenu++] = modeList[i];
					break;
				}
			i++;
			}
		printf("    [ Q] - Quit\n\n");
		printf("Choice: ");

		gets(buf);
		if (buf[0] == 'q' || buf[0] == 'Q')
			break;

		choice = atoi(buf);
		if (0 <= choice && choice < maxmenu) {
			result = setSuperVGAMode(mode = menu[choice]);
			if (result == -1) {
				printf("ERROR: Invalid video mode for driver!\n");
				printf("       Please report this discrepancy...\n");
				exit(1);
				}
			if (!result) {
				printf("\n");
				printf("ERROR: Video mode did not set correctly!\n");
				printf("       Please report this discrepancy...\n");
				printf("\nPress any key to continue...\n");
				getch();
				}
			else {
				moireTest();
				readWriteTest();
				pageFlipTest();
				testingComplete();
				restoreMode();
				}
			}
		}
}
