/****************************************************************************
*
*						MegaGraph Graphics Library
*
*                   Copyright (C) 1993 Kendall Bennett.
*							All rights reserved.
*
* Filename:		$RCSfile: modes.inc $
* Version:		$Revision: 1.1 $
*
* Language:		ANSI C
* Environment:	IBM PC (MS DOS)
*
* Description:	Include file to define the symbolic names of all supported
*				video modes and video device drivers.
*
* $Id: modes.inc 1.1 1993/03/03 10:46:27 kjb Exp $
*
* Revision History:
* -----------------
*
* $Log: modes.inc $
* Revision 1.1  1993/03/03  10:46:27  kjb
* Initial revision
*
****************************************************************************/

/*
 * Table of device driver names
 */

static char *driverNames[] = {
	"DETECT",
	"CGA",
	"MCGA",
	"EGA",
	"EGA64",
	"EGAMONO",
	"EGA64MONO",
	"HERCMONO",
	"VGA",
	"VESA SuperVGA",
	"ATI SuperVGA",
	"AHEAD A SuperVGA",
	"AHEAD B SuperVGA",
	"Chips & Tech SuperVGA",
	"Everex SuperVGA",
	"Genoa SuperVGA",
	"OAK SuperVGA",
	"Paradise SuperVGA",
	"Trident 8800 SuperVGA",
	"Trident 8900 SuperVGA",
	"Video7 SuperVGA",
	"ET3000 SuperVGA",
	"ET4000 SuperVGA",
	"NCR SuperVGA",
	"S3 SuperVGA",
	"AcuMos SuperVGA",
	"Advance Logic AL2101 SuperVGA",
	"MXIC SuperVGA",
	"Primus 2000 SuperVGA",
	"RealTek 3106 SuperVGA",
	"Cirrus SuperVGA",
	};

/* Table of Video DAC names
 */

static char *dacNames[] = {
	"Normal DAC",
	"HiColor 15 bit DAC",
	"HiColor 16 bit DAC",
	"TrueColor 24 bit DAC",
	};

/*
 * Table of video mode names
 */

static char *modeNames[] = {
	"320 x 200 EGA 16 color",
	"640 x 200 EGA 16 color",
	"640 x 350 EGA 16 color",
	"640 x 400 VGA 16 color",
	"640 x 480 VGA 16 color",
	"320 x 200 VGA 256 color",
	"320 x 200 VGAX 256 color",
	"320 x 240 VGAX 256 color",
	"320 x 400 VGAX 256 color",
	"320 x 480 VGAX 256 color",
	"360 x 200 VGAX 256 color",
	"360 x 240 VGAX 256 color",
	"360 x 400 VGAX 256 color",
	"360 x 480 VGAX 256 color",
	"800 x 600 SVGA 16 color",
	"1024 x 768 SVGA 16 color",
	"1280 x 1024 SVGA 16 color",
	"640 x 350 SVGA 256 color",
	"640 x 400 SVGA 256 color",
	"640 x 480 SVGA 256 color",
	"800 x 600 SVGA 256 color",
	"1024 x 768 SVGA 256 color",
	"1280 x 1024 SVGA 256 color",
	"320 x 200 SVGA 32k color",
	"640 x 350 SVGA 32k color",
	"640 x 400 SVGA 32k color",
	"640 x 480 SVGA 32k color",
	"800 x 600 SVGA 32k color",
	"1024 x 768 SVGA 32k color",
	"1280 x 1024 SVGA 32k color",
	"320 x 200 SVGA 16m color",
	"640 x 350 SVGA 16m color",
	"640 x 400 SVGA 16m color",
	"640 x 480 SVGA 16m color",
	"800 x 600 SVGA 16m color",
	"1024 x 768 SVGA 16m color",
	"1280 x 1024 SVGA 16m color",
	};

/*
 * Table's of chip revision id's
 */

static char *ATINames[] = {
	"18800",
	"18800-1",
	"28800-2",
	"28800-4",
	"28800-5",
	};

static char *ChipsNames[] = {
	"82c451",
	"82c452",
	"82c453",
	};

static char *EverexNames[] = {
	"EvNR",
	"Ev236 (Trident)",
	"Ev620 (Trident)",
	"Ev629 (ET4000)",
	"Ev673 (Trident)",
	"Ev678 (Trident)",
	};

static char *OakNames[] = {
	"OTI-037C",
	"OTI-067",
	"OTI-077",
	};

static char *ParadiseNames[] = {
	"PVGA1A",
	"WD90C00",
	"WD90C10",
	"WD90C11",
	"WD90C30",
	"WD90C31",
	};

static char *ET4000Names[] = {
	"MegaEva/2",
	"Speedstar 24",
	"Genoa 7900",
	};

static char *S3Names[] = {
	"86c911",
	"86c924",
	"86c801/805",
	"86c928",
	};

static char *CirrusNames[] = {
	"CL-GD 5422",
	};

/*
 * Index table into individual chipset names.
 */

static char **chipsetNames[] = {
	ATINames,			/* ATI				*/
	NULL,				/* Ahead A			*/
	NULL,				/* Ahead B			*/
	ChipsNames,			/* Chips & Tech		*/
	EverexNames,		/* Everex			*/
	NULL,				/* Genoa			*/
	OakNames,			/* Oak Tech			*/
	ParadiseNames,		/* Paradise			*/
	NULL,				/* Trident 8800		*/
	NULL,				/* Trident 8900		*/
	NULL,				/* Video 7			*/
	NULL,				/* ET3000			*/
	ET4000Names,		/* ET4000			*/
	NULL,				/* NCR				*/
	S3Names,			/* S3				*/
	NULL,				/* AcuMos			*/
	NULL,				/* Advance Logic	*/
	NULL,				/* MXIC				*/
	NULL,				/* Primus			*/
	NULL,				/* RealTek			*/
	CirrusNames,		/* Cirrus			*/
	};
