

pbm(5)                     Unix Programmer's Manual                     pbm(5)


NAME
     pbm - portable bitmap file format

DESCRIPTION
     The portable bitmap format is a lowest common denominator monochrome file
     format.  It was originally designed to make it reasonable to mail bitmaps
     between different types of machines  using  the  typical  stupid  network
     mailers  we  have today.  Now it serves as the common language of a large
     family of bitmap conversion filters.  The definition is as follows:

     - A "magic number" for identifying the file type.   A  pbm  file's  magic
       number is the two characters "P1".

     - Whitespace (blanks, TABs, CRs, LFs).

     - A width, formatted as ASCII characters in decimal.

     - Whitespace.

     - A height, again in ASCII decimal.

     - Whitespace.

     - Width * height bits, each either '1' or '0', starting at  the  top-left
       corner of the bitmap, proceeding in normal English reading order.

     - The character '1' means black, '0' means white.

     - Whitespace in the bits section is ignored.

     - Characters from a "#" to the next end-of-line are ignored (comments).

     - No line should be longer than 70 characters.

     Here is an example of a small bitmap in this format:
     P1
     # feep.pbm
     24 7
     0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
     0 1 1 1 1 0 0 1 1 1 1 0 0 1 1 1 1 0 0 1 1 1 1 0
     0 1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 1 0
     0 1 1 1 0 0 0 1 1 1 0 0 0 1 1 1 0 0 0 1 1 1 1 0
     0 1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0
     0 1 0 0 0 0 0 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 0 0
     0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0

     Programs that  read  this  format  should  be  as  lenient  as  possible,
     accepting anything that looks remotely like a bitmap.

     There is also a variant on the format, available by setting  the  RAWBITS
     option at compile time.  This variant is different in the following ways:

     - The "magic number" is "P4" instead of "P1".





                              27 September 1991                              1



pbm(5)                     Unix Programmer's Manual                     pbm(5)


     - The bits are stored eight per byte, high bit first low bit last.

     - No whitespace is allowed  in  the  bits  section,  and  only  a  single
       character  of  whitespace  (typically  a  newline) is allowed after the
       height.

     - The files are eight times smaller and many times  faster  to  read  and
       write.

SEE ALSO
     atktopbm(1),  brushtopbm(1),  cmuwmtopbm(1),   g3topbm(1),   gemtopbm(1),
     icontopbm(1),   macptopbm(1),   mgrtopbm(1),   pi3topbm(1),  xbmtopbm(1),
     ybmtopbm(1),  pbmto10x(1),  pnmtoascii(1),  pbmtoatk(1),   pbmtobbnbg(1),
     pbmtocmuwm(1),   pbmtoepson(1),   pbmtog3(1),   pbmtogem(1),  pbmtogo(1),
     pbmtoicon(1),   pbmtolj(1),   pbmtomacp(1),   pbmtomgr(1),   pbmtopi3(1),
     pbmtoplot(1),   pbmtoptx(1),   pbmtox10bm(1),  pbmtoxbm(1),  pbmtoybm(1),
     pbmtozinc(1),   pbmlife(1),   pbmmake(1),    pbmmask(1),    pbmreduce(1),
     pbmtext(1), pbmupc(1), pnm(5), pgm(5), ppm(5)

AUTHOR
     Copyright (C) 1989, 1991 by Jef Poskanzer.





































                              27 September 1991                              2

