

libppm(3)                  Unix Programmer's Manual                  libppm(3)


NAME
     libppm - functions to support portable pixmap programs

SYNOPSIS

     #include <ppm.h>
     cc ... libppm.a libpgm.a libpbm.a


DESCRIPTION

     TYPES AND CONSTANTS

     typedef ... pixel;
     typedef ... pixval;
     #define PPM_MAXMAXVAL ...
     extern pixval ppm_pbmmaxval;

     Each pixel contains three pixvals, each of which should contain only  the
     values  between  0  and  PPM_MAXMAXVAL.  ppm_pbmmaxval is the maxval used
                                 -               -
     when a PPM program reads a PBM file.  Normally it is 1; however, for some
     programs, a larger value gives better results.

     #define PPM_FORMAT ...
     #define RPPM_FORMAT ...
     #define PPM_TYPE PPM_FORMAT
     int PPM_FORMAT_TYPE( int format )

     For distinguishing different file formats and types.

     pixval PPM_GETR( pixel p )
               -
     pixval PPM_GETG( pixel p )
               -
     pixval PPM_GETB( pixel p )
               -

     These three macros retrieve the red, green or blue value from  the  given
     pixel.

     void PPM_ASSIGN( pixel p, pixval red, pixval grn, pixval blu )
             -

     This macro assigns the given red, green and blue values to the pixel.

     int PPM_EQUAL( pixel p, pixel q )
            -

     This macro checks two pixels for equality.

     void PPM_DEPTH( pixel newp, pixel p, pixval oldmaxval, pixval newmaxval )
             -

     This macro scales the colors of pixel p according the old and new maximum
     values  and  assigns  the  new  values  to  newp.  It is intended to make
     writing ppmtowhatever easier.

     float PPM_LUMIN( pixel p )

     This macro determines the luminance of the pixel p.




                                                                             1



libppm(3)                  Unix Programmer's Manual                  libppm(3)


     MEMORY MANAGEMENT

     pixel** ppm_allocarray( int cols, int rows )

     Allocate an array of pixels.

     pixel* ppm_allocrow( int cols )
               -

     Allocate a row of the given number of pixels.

     void ppm_freearray( pixel** pixels, int rows )
             -

     Free the array  allocated  with  ppm_allocarray()  containing  the  given
                                         -
     number of rows.

     void pbm_freerow( pixel* pixelrow )

     Free a row of pixels.

     READING PBM FILES

     void ppm_readppminit( FILE* fp, int* colsP, int* rowsP, pixval*  maxvalP,
     int* formatP )

     Read the header from a PPM file, filling in the rows,  cols,  maxval  and
     format variables.

     void ppm_readppmrow( FILE* fp, pixel* pixelrow, int cols, pixval  maxval,
             -
     int format )

     Read a row of pixels into the pixelrow array.  Format, cols,  and  maxval
     were filled in by ppm_readppminit().
                          -

     pixel** ppm_readppm( FILE* fp, int* colsP, int* rowsP, pixval* maxvalP )

     Read an entire pixmap file into memory, returning the allocated array and
     filling  in  the rows, cols and maxval variables.  This function combines
     ppm_readppminit(), ppm_allocarray() and ppm_readppmrow().
        -                  -                    -

     WRITING FILES

     void ppm_writeppminit( FILE* fp, int cols, int rows, pixval  maxval,  int
     forceplain )

     Write the header for a portable pixmap file.  The forceplain flag  forces
     a plain-format file to be written, as opposed to a raw-format one.

     void ppm_writeppmrow( FILE* fp, pixel* pixelrow, int cols, pixval maxval,
             -
     int forceplain )

     Write a row from a portable pixmap.

     void ppm_writeppm( FILE* fp, pixel** pixels, int cols, int  rows,  pixval
             -
     maxval, int forceplain )

     Write the header and all data  for  a  portable  pixmap.   This  function


                                                                             2



libppm(3)                  Unix Programmer's Manual                  libppm(3)


     combines ppm_writeppminit() and ppm_writeppmrow().
                 -                      -

     COLOR NAMES

     pixel ppm_parsecolor( char* colorname, pixval maxval )

     Parses an ASCII color name into a pixel.  The color can be  specified  in
     three  ways.   One,  as  a  name, assuming that a pointer to an X11-style
     color names file was compiled  in.   Two,  as  an  X11-style  hexadecimal
     number: #rgb, #rrggbb, #rrrgggbbb, or #rrrrggggbbbb.  Three, as a triplet
     of decimal floating point numbers separated by commas: r.r,g.g,b.b.

     char* ppm_colorname( pixel* colorP, pixval maxval, int hexok )
              -

     Returns a pointer to a string describing the given  color.   If  the  X11
     color  names  file is available and the color appears in it, that name is
     returned.  Otherwise, if the  hexok  flag  is  true  then  a  hexadecimal
     colorspec  is returned; if hexok is false and the X11 color names file is
     available, then the closest matching color is returned;  otherwise,  it's
     an error.

SEE ALSO
     pbm(3), pgm(3)

AUTHOR
     Copyright (C) 1989, 1991 by Tony Hansen and Jef Poskanzer.
































                                                                             3

