ECHO OFF
REM
REM   ONEGIF.BAT version 2.0, 01/29/93
REM   James W. Birdsall
REM   This batch file processes the file given as the first argument through
REM   GIFCHECK. It then logs the file name and a remark to the file given as
REM   the second argument, depending on the errorlevel returned by GIFCHECK.
REM   If GIFCHECK indicated that the file needed to be stripped, GIFSTRIP is
REM   run automatically. The results from GIFSTRIP area also logged.
REM
GIFCHECK -B %1 > NUL:
IF ERRORLEVEL 6 GOTO UNREC
IF ERRORLEVEL 5 GOTO STRIPM
IF ERRORLEVEL 4 GOTO STRIP
IF ERRORLEVEL 3 GOTO OOPS
IF ERRORLEVEL 2 GOTO UNEOF
IF ERRORLEVEL 1 GOTO NOTGIF
IF ERRORLEVEL 0 GOTO OK
:UNREC
ECHO %1 : unrecognized ERRORLEVEL! >> %2
GOTO END
:OK
ECHO %1 : GIF OK >> %2
GOTO END
:STRIPM
GIFSTRIP -B -N -M %1 > NUL:
IF ERRORLEVEL 1 GOTO STRIPERR
ECHO %1 : stripped OK >> %2
GOTO END
:STRIP
GIFSTRIP -B -N %1 > NUL:
IF ERRORLEVEL 1 GOTO STRIPERR
ECHO %1 : stripped OK >> %2
GOTO END
:STRIPERR
ECHO %1 : error while stripping >> %2
GOTO END
:NOTGIF
ECHO %1 : not a GIF >> %2
GOTO END
:UNEOF
ECHO %1 : GIF with unexpected EOF >> %2
GOTO END
:OOPS
ECHO %1 : ERROR! >> %2
:END
