/*	
	gli -	graphics interface routine for
			CIE Laser Image Printing System, or LIPS 10

	history...
		15 Jul 90	ver 1.30: can get parameters from configuration file
		25 Apr 89	dummy routines for flipping lines and setting background
					color.
		22 Jul 88	Deleting output file if it already exists.
		9 Jul 87	Creating output file if it doesn't already exist
		21 May 87	Stronger warning msg about using default output port
		13 May 87	Default margins, width, and height set for landscape
					orientation.
		1 May 87	Adapted from Hewlett Packard plotter routine
		23 Jun 86	Adapted from Houstin Instruments plotter routine
		27 Oct 87	Environment variable "plot_setup" can contain an
					alternate setup string.

	bugs...

bench needs to check for "erasing"
g3x needs to call set_height to set character size.

*/

#include <stdio.h>
#include <math.h>
#include <string.h>
#include "g.h"
#include "config.h"

#define ESC 27
#define UNIT (1./300.)
#define BUFSIZE 80

				/* default margins, defined assuming portrait orientation */
#define LMARGIN 1.125
#define RMARGIN 1.125
#define TMARGIN 1.5
#define BMARGIN 1.5

/*	imported variables	*/

extern char *default_script_file;

/*	exported graphics variables	*/

char *machine		=	"CIE LIPS 10";
char *interface_version	=	"1.30";
char *config_file	=	NULL;
static char default_config_file[] = "GRAPHLI.CFG";
int plotting_device	=	1;
int erasing			=	0;
int flipping		=	0;

int max_color		=	1;

int current_color	=	0;
int pixels_wide		=	(72*85)/2;	/* width of screen in pixels */
int pixels_high		=	72*11;		/* height of screen in pixels */
double best_width	=	1.;
double best_height	=	.720;		/* relative height/width parameters */
int pen_diameter	=	3;

int char_rows		=	66;			/* text parameters */
int	char_columns	=	133;
int	char_height		=	108;
int	char_width		=	10;
int	x_offset		=	0;
int	y_offset		=	0;
int	char_v_adjusted	=	1;
int	char_h_adjusted	=	1;

int has_cursor_keys	=	0;
int	up_arrow		=	0x48;		/* cursor keys */
int	down_arrow		=	0x50;
int	left_arrow		=	0x4b;
int	right_arrow		=	0x4d;
int	escaped_arrows	=	1;			/* cursor keys are preceded by 0 */
int	escape_char		=	0;

/* an 'A' on row r, column c  has lower left corner on raster 
				r*char_height + y_offset 
	at pixel
				c*char_width + x_offset			*/


struct PRIM_ATTR prim_attr=
	{2, 	/* # colors                          */
	1,      /* # intensities                     */
	0,      /* nonzero if supported in hardware  */
	1,      /* # linestyles in hardware          */
	1,      /* # linestyles in software          */
	1,      /* # linewidths                      */
	0,      /* nonzero if supported in hardware  */
	1,      /* minimum linewidth                 */
	14,     /* maximum linewidth (.2 in)         */
	1,      /* # pens in hardware                */
	0,      /* # pens in software                */
	1,      /* # fonts                           */
	1,      /* # character sizes                 */
	0,      /* nonzero if supported in hardware  */
	10,     /* minimum character height (pixels) */
	10,     /* maximum character height (pixels) */
	0,      /* # markers in hardware             */
	0,      /* # markers in software             */
	0       /* # pick IDs in hardware            */
	};


static draw();
static erase();
static text();
static character();
char *getenv();

static font=0;
static int plotter_type;
FILE *plot_file;
static file_open = 0;
static int style_code=1;
static int color_code=0;
static char styles[]=" 0123456789:";
static cx=0, cy=0;	/*	actual position of pen  */
static something_printed=0;	/* nonzero if something printed since last
								PAGE command (graphics_clear())  */
static wait()	/* wait for plotter buffer space */   
{	something_printed=1;
}


static set_width(width) int width; 
{	width *= 3;
	if(width<3) width=3;
	else if(width>64) width=64;
	fprintf(plot_file,"SPD %d;\n",width);
}

set_color(color) int color; {}
set_intensity(intensity) double intensity; {}
set_background_color(color) int color; {}
set_background_intensity(intensity) double intensity; {}

inquire_color() {return 1;}
double inquire_intensity() {return 1.;}

/*	draw - draw a straight line 	*/

static int draw(x1,y1,x2,y2) int x1,y1,x2,y2;
{	int t,d1,d2;
/*	y1= pixels_high-1-y1; y2= pixels_high-1-y2; */
	d1=maximum(abs(cx-x1),abs(cy-y1));
	d2=maximum(abs(cx-x2),abs(cy-y2));
#ifdef DEBUG
	printf("\nat (%d,%d)  drawing (%d,%d)(%d away) to (%d,%d)(%d away)",
	 cx,cy,x1,y1,d1,x2,y2,d2);
#endif
	if(d2<d1)
		{t=x1; x1=x2; x2=t; t=y1; y1=y2; y2=t; t=d1; d1=d2; d2=t;
#ifdef DEBUG
		puts("swapping");
#endif
		}
#ifdef DEBUG
	putchar('\n');
#endif
	wait();
	if(d1)
		{fprintf(plot_file,"MAP %d,%d;",x1,y1);
		}
	fprintf(plot_file,"DAP %d,%d;\n",x2,y2);
	cx=x2; cy=y2;
}

/*	gotoxy - move pen to new position (used before text display) */

gotoxy(x,y) int x,y;
{/*	y= pixels_high-1-y; */
	if (x<0) x=0; else if (x>=pixels_wide) x=pixels_wide-1;
	if (y<0) y=0; else if (y>=pixels_high) y=pixels_high-1;
	if(x==cx && y==cy) return;
	wait();
	fprintf(plot_file,"MAP %d,%d;",x,y);
	cx=x; cy=y;
}

static nil() {}

/* exported function pointers */
int (*draw_line)()	=	draw;
int (*erase_line)()	=	nil;
int (*draw_text)()	=	text;
int (*draw_char)()	=	character;
int (*flip_line)()	=	draw;

/*	find a character in a string (case insensitive) */
static int strichr(s, c) char *s, c;
{
	for (c=tolower(c); *s; s++)
		if(tolower(*s) == c)
			return 1;
	return 0;
}

/*		init - initialize the graphics system	*/
init_graphics()
{	int d1, d2, c, i, vel;
	double left, top, w, h, wmax, hmax;
	char buf[BUFSIZE], inbuf[BUFSIZE], *s, *t;
	char *setup_string;

	static int portrait = 0, landscape = 1;
	static int offset_ask = 1,
		size_ask = 1,
		orientation_ask = 1,
/*		plotter_ask = 1, */
/*		velocity_ask = 1, */
		file_ask = 0;
	static double offset[2] = {BMARGIN, LMARGIN};
/*	static double velocity = {38.}; */
	static double size[2] = {11. - BMARGIN - TMARGIN, 8.5 - LMARGIN - RMARGIN};
	static char *port_name = NULL;

	static PARAM parmv[] = {
				{'o', REAL, &offset_ask, offset, 2},
				{'l', REAL, &offset_ask, &offset[0]},
				{'t', REAL, &offset_ask, &offset[1]},
				{'s', REAL, &size_ask, size, 2},
				{'w', REAL, &size_ask, &size[0]},
				{'h', REAL, &size_ask, &size[1]},
				{'p', BOOLEAN, &orientation_ask, &portrait, 0}, 
				{'l', BOOLEAN, &orientation_ask, &landscape, 0}, 
				{'f', STRING, &file_ask, &port_name, 1},
/*				{'n', STRING, &plotter_ask, &plotter_name, 1}, */
/*				{'v', REAL, &velocity_ask, &velocity, 1}, */
				{'\0'}};

	if(config_file == NULL) config_file = default_config_file;
	config(config_file, NULL, parmv, buf, BUFSIZE);

	if(port_name == NULL && version() >= 0x200)
		port_name = getenv("PLOT_PORT");
	if(port_name == NULL) 
		{port_name = strncpy(buf, default_script_file, BUFSIZE-4);
		s = strchr(port_name, '.');
		if(s != NULL) *s = 0;
		strcat(port_name, ".li");
		}

	if(file_ask)
		{port_name = strncpy(buf, port_name, BUFSIZE);
		printf("Enter output file                        (default %s): ",buf);
		gets(inbuf);
		if(inbuf[0]) strcpy(buf,inbuf);
		}
	else
		printf("\noutput written to %s\n", port_name);

	unlink(port_name);				/* delete the file if it exists */
	plot_file=fopen(port_name,"w");		/* this will open a file or device */
	if(plot_file==NULL) {printf("can\'t open output file %s", port_name); exit();}
	file_open = 1;

	setup_string = NULL;
	if(version()>=0x200) setup_string = getenv("PLOT_SETUP");
	if(setup_string == NULL) 
		setup_string = strcpy(buf,"DAF; DAM; UNIT D; SCF; FONT 2;");
	/*	
			LIPS command language mode on
		 	delete all fonts
		 	delete all macros
		 	unit = points (1/300 of inch)
		 	save current font
		 	Prestige Elite, 10-pt, 12 CPI portrait-style font
	*/
	fixup_escapes(setup_string);
	fprintf(plot_file,"(O] %s\n", setup_string);

	if(orientation_ask)
		{printf("Portrait or landscape orientation? ('p' or 'l', default %c): ",
			portrait?'p':'l');
		gets(buf); 
		portrait |= strichr(buf, 'p');
		landscape = !portrait;
		}

	left=offset[0];
	top=offset[1];
	while(1)
		{if(offset_ask)
			{printf("\nEnter left and top margin in inches \n");
			printf("                                 (default %5.3f and %5.3f): ",left,top);
			gets(buf); if(buf[0]) sscanf(buf,"%lf %lf",&left,&top);
			}
		if(left<0. || left>10.75)
			printf("left margin outside valid range 0-10.75\n");
		else if(top<0. || top>10.75)
			printf("top margin outside valid range 0-10.75\n");
		else if((portrait && left > 8.25) || (landscape && top > 8.25) || 
												(left > 8.25 && top > 8.25))
			printf("no room left for plot!\n");
		else break;
		offset_ask = 1;
		left=BMARGIN;
		top=LMARGIN;
		}
								 /* set origin */
	fprintf(plot_file,"SLM %f; STM %f;\n", left/UNIT, top/UNIT);
	
	w = size[0];
	h = size[1];
	
	while(1)
		{if(size_ask)
			{
			printf("\nEnter width and height of plot area in inches \n");
			if(!portrait)
				printf("maximum for landscape orientation, %5.3f by %5.3f\n", 
													10.75 - left, 8.15 - top);
			if(!landscape)
				printf("maximum for portrait orientation,  %5.3f by %5.3f\n", 
													8.15 - left, 10.75 - top);
			printf("                                 (default, %5.3f by %5.3f): ", w, h);
			gets(buf); if(buf[0]) sscanf(buf,"%lf %lf",&w,&h);
			}

		if(landscape) hmax = 8.15 - top; else hmax = 10.75 - top;
		if(portrait) wmax = 8.15 - left; else wmax = 10.75 - left;
								/* round to nearest .01" */
		hmax = floor(hmax*100. + .5)/100.;
		wmax = floor(wmax*100. + .5)/100.;
		h = floor(h*100. + .5)/100.;
		w = floor(w*100. + .5)/100.;

		if(w < .1 || w > wmax)
			printf("width outside valid range 0.1 to %2.3f\n", wmax);
		else if(h < .1 || h > hmax)
			printf("height outside valid range 0.1 to %2.3f\n", hmax);
		else if(w + left > 8.15 && h + top > 8.15)
			printf("either width or height must be reduced\n");
		else break;
							/* find suitable defaults for next time */
		if(!portrait && top < 8.5 - LMARGIN)/* assume landscape orientation */
			{h = 8.5 - top - LMARGIN;
			if(left < 11. - TMARGIN) w=11. - left - TMARGIN;
			else w = 11 - left;
			}
		else if(!landscape && left < 8.5 - RMARGIN)
			{							/* else assume portrait orientation */
			w = 8.5 - RMARGIN - left;
			if(top < 11. - BMARGIN) h = 11. - top - BMARGIN;
			else h = 11. - top;
			}
		else if(!portrait && top<8.15) {h=8.15-top; w=10.75-left;}
		else {h=10.75-top; w=8.15-left;}  /* maximize area */
		size_ask = 1;
		}
	if(h<.1) h=.1;
 	if(w<.1) w=.1; 
 	else if(w+left>10.75) w=10.75-left;
	if(landscape) 
			/* landscape-style with Prestige Elite, 10-pt, 12 CPI font */
		{fprintf(plot_file,"SPO L; FONT 3;");
		if(h+top>9.75+1.) h=9.75+1.-top;
		}
	else
		{if(h+top>7.25+1.) h=7.25+1.-top;
		}

	pixels_wide=w/UNIT;
	pixels_high=h/UNIT;
	char_height=1./6./UNIT;				/* 6 lines/in */
	char_rows=h*6.;
	char_width=1./12./UNIT;				/* 12 char/in */
	char_columns=w*12.;
	if(pixels_wide>=pixels_high)         /* landscape style */
		{best_width=1.;
		best_height=(double)pixels_high/pixels_wide;
		}
	else                                 /* portrait style */
		{best_height=1.;
		best_width=(double)pixels_wide/pixels_high;
		}
}

/* character sizes in units of .005 inch */
 	/* interpret escape sequences in setup string...
 						"$e" -> escape char, 
 						"\n" -> line feed 
 						"\r" -> carriage return
 						"\t" -> tab
 						"\c" -> c (escape an otherwise special character) */
fixup_escapes(s) char *s;
{	char *t;
	for (t=s; *s; s++)
		{if(*s=='$' && s[1]=='e') {*t++=0x1b; s++;}
		else if(*s=='\\' && s[1]=='n') {*t++='\n'; s++;}
		else if(*s=='\\' && s[1]=='t') {*t++='\t'; s++;}
		else if(*s=='\\' && s[1]=='r') {*t++='\r'; s++;}
		else if(*s=='\\') {*t++=s[1]; s++;}
		else *t++=*s;
		}
	*t=0;
}

static text(s) char *s;
{	char *t, c, buf[80];
	int i;
	while(*s)
		{t=s;
		c= *t&127;
		if(c=='\'') {fprintf(plot_file,"TEXT \"'\", E;"); s++; continue;}
		if(c=='\n') {fprintf(plot_file,"TEXT '', N;"); s++; continue;}
		i=0;
		do
			{if(c<32 || c>126) c=' ';
			buf[i++]=c;
			c= *++t&127;
			} while(c && (i<79) && c!='\n' && c!='\'');
		buf[i]=0;
		wait();
		fprintf(plot_file,"TEXT '%s', E;\n", buf);
		s=t;
		}
	cx=cy=-2000;
}

static character(c) char c;
{	char buf[2];
	buf[0]=c; buf[1]=0;
	text(buf);
}


version()	/* return MS-DOS version number. Version 2.01 returned as 0x201 */
{
#ifdef __DESMET__
	extern unsigned _rax;
	_rax=0x3000;
	_doint(0x21);
	return ( (_rax&0xff)<<8 | (_rax&0xff00)>>8 );
#else
#include <dos.h>
	return ( (_version&0xff)<<8 | (_version&0xff00)>>8 );
#endif
}

#ifdef __DESMET__
/*	search environment for given string */

getenv(target) char *target;
{	char buf[256],*s,t[25],*env, *malloc();
	int nt,offset;

	s=t;
	while(*target) *s++=toupper(*target++);
	*s++= '='; *s=0;
	nt = strlen(t);
	offset=0;
	_lmove(2,44,_showcs()-0x10,&env,_showds());
	while(1)
		{_lmove(256,offset,env,buf,_showds());
		s=buf;
		if(*s)
			{/* printf("examining entry: %s \n",s); getchar(); */
			if (strncmp(t,s,nt)==0) 
				{env = malloc(strlen(s+nt)+1);
				if(env == NULL) return NULL;
				return strcpy(env, s+nt);
				}
			}
		else return NULL;
		offset+=strlen(buf)+1;
		}
}
#endif /* DESMET */

/*		finish - close down the graphics system	 */

finish_graphics()
{	if(file_open)
		{clear_graphics();

		fprintf(plot_file,"SPO P; UNIT I; RPF; EXIT;");
			/* 	portrait orientation,
				units are inches,
				return to previous font,
				command language mode off */

		fclose(plot_file);
		file_open = 0;
		}
}

clear_graphics()
{	if(something_printed) fprintf(plot_file,"PAGE;\n");
	something_printed=0;
}


/*	pointers to optional functions (NULL if not implemented)	*/

int	(*new_linestyle)()=0;	/* (*new_linestyle)(style) int style; */
int	(*new_linewidth)()=set_width;	/* (*new_linewidth)(width) int width; */
int	(*new_charsize)()=0;	/* (*new_charsize)(w,h) int w,h; */
int	(*draw_marker)()=0;	/* (*draw_marker)(n) int n; */

#ifdef MAIN

main()
{	char buf[100];
	printf("Interface %s for the %s\n",interface_version,machine);
	init_graphics();
	printf("screen width %d pixels\nheight %d pixels\n",
		pixels_wide,pixels_high);
	printf("height:width ratio %f:%f\n",best_height,best_width);
	printf("%d colors\n",max_color+1);
	printf("primitive attributes...\n");
	printf("color_count=               %d \n",prim_attr.color_count);
	printf("intensity_count=           %d \n",prim_attr.intensity_count);
	printf("intensities_in_hardware=   %d \n",prim_attr.intensities_in_hardware);
	printf("hardware_linestyles=       %d \n",prim_attr.hardware_linestyles);
	printf("software_linestyles=       %d \n",prim_attr.software_linestyles);
	printf("linewidth_count=           %d \n",prim_attr.linewidth_count);
	printf("linewidths_in_hardware=    %d \n",prim_attr.linewidths_in_hardware);
	printf("linewidth_minimum=         %d \n",prim_attr.linewidth_minimum);
	printf("linewidth_maximum=         %d \n",prim_attr.linewidth_maximum);
	printf("hardware_pens=             %d \n",prim_attr.hardware_pens);
	printf("software_pens=             %d \n",prim_attr.software_pens);
	printf("charfont_count=            %d \n",prim_attr.charfont_count);
	printf("charsize_count=            %d \n",prim_attr.charsize_count);
	printf("charsize_in_hardware=      %d \n",prim_attr.charsize_in_hardware);
	printf("charsize_minimum=          %d \n",prim_attr.charsize_minimum);
	printf("charsize_maximum=          %d \n",prim_attr.charsize_maximum);
	printf("hardware_markers=          %d \n",prim_attr.hardware_markers);
	printf("software_markers=          %d \n",prim_attr.software_markers);
	printf("pick_id_count=             %d \n",prim_attr.pick_id_count);
	(*draw_line)(2,4,200,-400);
	(*draw_line)(20,40,100,-200);
	(*erase_line)(2,4,200,-400);
	(*draw_line)(10,30,100,300);
	(*draw_line)(10,40,500,890);
	(*draw_line)(10,40,500,32);
	(*draw_line)(10,1000,78,8900);
	gotoxy(10,-20);
	(*draw_text)(" ello\nDolly ");
	(*draw_char)('H');
	finish_graphics();
}

#endif

maximum(a,b) int a,b;
{	if (a>b) return a;
	return b;
}

