/* sw_splpe.c - spawn a child process.
   Copyright (C) 1990 by Thorsten Ohl, td12@ddagsi3.bitnet

   This file is part of SWAPLIB (the library), a library for efficient
   execution of child processes under MS-DOS.

   The library is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   The library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with the library; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   $Header: e:/gnu/swaplib/RCS/sw_splpe.c'v 0.9 90/09/09 21:44:16 tho Stable $
 */

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <stdarg.h>

#include "swaplib.h"

extern void *xmalloc (size_t size);

int
swap_spawnlpe (char *cmd, char *argv0, ...)
{
  char **argv;
  char **envv;
  int i;
  int rc;
  int argc = 1;

  va_list ap;


  if (argv0)
    {
      /* Count the arguments */

      va_start (ap, argv0);
      while (va_arg (ap, char *))
	argc++;


      /* There should be an environment after NULL. */

      envv = va_arg (ap, char **);

      va_end (ap);

      argv = (char **) xmalloc ((argc + 1) * sizeof (char *));


      /* Set up the pointers. */

      argv[0] = argv0;

      va_start (ap, argv0);
      for (i = 1; i < argc; i++)
	argv[i] = va_arg (ap, char *);
      va_end (ap);

      argv[argc] = NULL;


      /* Call the workhorse.  */

      rc = swap_spawnvpe (cmd, argv, envv);

      free (argv);
    }
  else
    {
      /* Invalid arguments.  */

      rc = -1;
      errno = EINVAL;
    }

  return rc;
}

/* 
 * Local Variables:
 * mode:C
 * ChangeLog:ChangeLog
 * compile-command:make
 * End:
 */
