/* sw_resp.c - manipulate commandlines and respondfiles for swaplib.
   Copyright (C) 1990 by Thorsten Ohl, td12@ddagsi3.bitnet

   This file is part of SWAPLIB (the library), a library for efficient
   execution of child processes under MS-DOS.

   The library is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   The library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with the library; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   $Header: e:/gnu/swaplib/RCS/sw_resp.c'v 0.9 90/09/09 21:44:09 tho Stable $
 */

#include <stdio.h>

#include "swaplib.h"

static struct swap_respondfile_action default_respondfile_actions[] =
{
  { "cl",	_swap_build_cl_environment },
  { "fl",	_swap_build_fl_environment },
  { "masm",	_swap_build_masm_environment },
  { "link",	_swap_build_link_respond_file },
  { "lib",	_swap_build_lib_respond_file },
  { "pkzip",	_swap_build_zip_respond_file },
  { "pkunzip",	_swap_build_zip_respond_file },
  { NULL,	NULL }
};

struct swap_respondfile_action *
swap_set_respondfile_actions (void)
{
  return default_respondfile_actions;
}


/* 
 * Local Variables:
 * mode:C
 * ChangeLog:ChangeLog
 * compile-command:make
 * End:
 */
