/* sw_link.c - respondfiles for the Microsoft linker.
   Copyright (C) 1990 by Thorsten Ohl, td12@ddagsi3.bitnet

   This file is part of SWAPLIB (the library), a library for efficient
   execution of child processes under MS-DOS.

   The library is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   The library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with the library; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   $Header: e:/gnu/swaplib/RCS/sw_link.c'v 0.9 90/09/09 21:43:59 tho Stable $
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "swaplib.h"

/* Build a respondfile for the Microsoft linker from ARGV.  */

int
_swap_build_link_respond_file (char **argv, char **envv)
{
  int col = 0;
  FILE *respond_file;
  _swap_respond_file_name = swap_back_slashify (swap_mktmpname ("lk"));

  respond_file = fopen (_swap_respond_file_name, "w");
  if (!respond_file)
    {
      int last_errno = errno;
      fprintf (stderr, "can't open link respond file: ");
      errno = last_errno;
      perror (_swap_respond_file_name);
      return -1;
    }

  argv++;

  /* Loop over the arguments.  */

  while (*argv)
    {
      char *cp;

      if (strlen (*argv) + col > 50)
	{
	  /* Break the line.  */

	  fprintf (respond_file, "+\n");
	  col = 0;
	}

      while (cp = strchr (*argv, ','))		/* new respond group? */
	{
	  /* Break the line at a new group of responses.  */

	  *cp = '\n';

	  /* No more line breaks. */

	  col = 0;
	}

      col += fprintf (respond_file, "%s ", *argv);

      argv++;
    }

  fprintf (respond_file, "\n\n\n");	/* avoid prompts! */
  fclose (respond_file);

  sprintf (_swap_cmdline_buf, "/batch @%s", _swap_respond_file_name);
  return _swap_format_msdos_environment (NULL, envv, NULL);
}

/* 
 * Local Variables:
 * mode:C
 * ChangeLog:ChangeLog
 * compile-command:make
 * End:
 */
