/* prototyp.h  6-5-92 */
/* function prototypes for tierra simulator, included at end of tierra.h */
/* Tierra Simulator V3.11: Copyright (c) 1991, 1992 Tom Ray & Virtual Life */

/*
 * h_sccsid: @(#)prototyp.h	1.4	4/26/92
 */

#include "license.h"

#ifndef PROTOTYP_H
#define PROTOTYP_H

extern void FreeDynMem P_((void));
extern void GarbageCollectGB P_((void));
extern void VerifyGB P_((void));
extern void SavGeneBank P_((void));
extern void SavDynMem P_((I8s  filename[]));
extern void ReadGeneBank P_((void));
extern void ReadDynMem P_((I8s  filename[]));
extern void DivideBookeep P_((Pcells  ce, Pcells  ne));
extern void OutDisk P_((I32s bd, Pcells nc));
extern void ReapBookeep P_((Pcells  ce));
extern void MutBookeep P_((Ind i));
extern void plan P_((void));
extern void extract P_((Pcells  ce));
extern void GetGenList P_((I32s  flags));
extern void InitGList P_((Pgl g, I32s si, I32s gi, I32s size));
extern void CheckGenotype P_((Pcells  ce, I32u  flags));
extern int gc P_((void));
extern I8s IsNewSize P_((I32s  si));
extern void NewSize P_((Pcells  ce, I32s  flags));
extern I16s IsInGenQueue P_((Pcells  ce));
extern I8s IsInGenBank P_((Pcells  ce, I32s  flags));
extern void NewGenotype P_((Pcells  ce));
extern I32u WhoIs P_((Pcells  Fp ce, Ind a));
extern I8s IsSameGen P_((I32s size, FpInst g1, FpInst g2));
extern void gq_add P_((GList  *p));
extern void gq_movtop P_((GList  *p));
extern I8s gq_swap P_((void));
extern void gq_rem P_((GList  *p));
extern GList *gq_read P_((int si, int gi));
extern void printq P_((void));
extern void IncrLbl P_((I8s *lbln, I8s *lblo));
extern void MaxLbl P_((I8s *lbl, I8s *s));
extern I8s *Int2Lbl P_((I32s i));
extern I16s Lbl2Int P_((I8s  *s));
extern void DelGenFile P_((Pgl tgl));
extern FILE *open_ar P_((I8s *file, I32s size, I32s format, I32s mode));
extern head_t read_head P_((FILE * fp));
extern void write_head P_((FILE * fp, head_t * head));
extern indx_t *read_indx P_((FILE * fp, head_t * head));
extern void write_indx P_((FILE * fp, head_t * head, indx_t * indx));
extern I32s find_gen P_((FILE  *fp, indx_t  *indx, I8s  *gen, I32s  n));
extern Pgl get_gen P_((FILE * fp, head_t * head, indx_t * indxn, I32s n));
extern I32s add_gen P_((FILE * fp, head_t * head, indx_t ** indx, Pgl gen));
extern I16s GetAscGen P_((Pgl g, I8s ifile[]));
extern I8s WritGenFile P_((Pgl  g, I8s  file[]));
extern I8s WritAscFile P_((Pgl  g, I8s  *file));
extern I16s GetGenFormat P_((Pgl g, I8s file[]));
extern Ascii2Ebcdic P_((I8s *s));
extern Ebcdic2Ascii P_((I8s *s));
extern void WritEcoB P_((I32u bits, I8s * buf));
extern void SetBit P_((I32u *seed, I32u bit, I32u value));
extern void nop P_((Pcells ce));
extern void or1 P_((Pcells ce));
extern void shl P_((Pcells ce));
extern void if_cz P_((Pcells ce));
extern void math P_((Pcells ce));
extern void push P_((Pcells ce));
extern void pop P_((Pcells ce));
extern void tcall P_((Pcells ce));
extern void call P_((Pcells ce));
extern void mov P_((Pcells ce));
extern void movdd P_((Pcells ce));
extern void movdi P_((Pcells ce));
extern void movid P_((Pcells ce));
extern void movii P_((Pcells ce));
extern void adr P_((Pcells ce));
extern I32s mal P_((Pcells ce,I32s *sug_addr, I32s sug_size));
extern I8s  chmode P_((Pcells ce, I32s start, I32s size, I32s mode));
extern void malchm P_((Pcells ce));
extern void divide P_((Pcells ce));
extern void CheckCells P_((void));
extern I32s flaw P_((Pcells ce));
extern Ind template
                  P_((Ind f, Ind b, I32s tz, I32s dir, I32s mode, Pcells ce));
extern Ind ctemplate P_((Ind  f, Ind  b, I32s  tz, I32s  dir, Pcells ce));
extern Ind btemplate 
		  P_((Ind f, Ind b, I32s tz, I32s dir, I32s mode, Pcells ce));
extern I8s IsPriv P_((Pcells ce, Ind a));
extern I8s IsBitPriv P_((Pcells ce, Ind a, I32s mode, I32s track));
extern I8s IsInsideCell P_((Pcells ce, Ind a));
extern I8s IsFree P_((Ind a));
extern void WhichCell P_((Ind  a, Pcells Fp  ce, I8s  *md));
extern Ind MemAlloc P_((I32s *size));
extern void MemDealloc P_((Ind p, I32s size));
extern void SetFlag P_((Pcells ce));
extern void thfree P_((I8s Hp ptr));
extern void tfree P_((I8s Fp ptr));
extern I8s Hp threcalloc P_((I8s  Hp ptr, I32u  nsiz, I32u  osiz));
extern I8s Fp trecalloc P_((I8s  Fp ptr, I32u  nsiz, I32u  osiz));
extern I8s Hp thcalloc P_((I32u num, I32u siz));
extern I8s Fp tcalloc P_((I32u  num, I32u  siz));
extern I32u tfread P_((I8s Hp ptr, I32s size, I32s n, FILE * stream));
extern I32u tfwrite P_((I8s Hp ptr, I32s size, I32s n, FILE * stream));
extern void IncrSliceQueue P_((void));
extern void EntBotSlicer P_((Pcells  ce));
extern void UpReaper P_((Pcells  ce));
extern void DownReaper P_((Pcells  ce));
extern void UpRprIf P_((Pcells  ce));
extern void DownReperIf P_((Pcells  ce));
extern void EntBotReaper P_((Pcells  ce));
extern void RmvFrmReaper P_((Pcells  ce));
extern void RmvFrmSlicer P_((Pcells  ce));
extern void SlicerPhoton P_((void));
extern I32s PhotonFit P_((Ind a, I8s *PhotonInst, I32s PhotonSize));
extern I32s PhotonSlide P_((Ind a, I8s *PhotonInst, I32s PhotonSize,
			    I32s PhotonWidth));
extern void PhotonTranslate P_((I8s *PhotonInst, I8s *PhotonWord));
extern void SlicerQueue P_((void));
extern void RanSlicerQueue P_((void));
extern int main P_((int argc, char *argv[]));
extern void life P_((void));
extern void TimeSlice P_((Pcells  ce, I32s size_slice));
extern I16s FetchDecode P_((Pcells  ce));
extern void IncrementIp P_((Pcells  ce));
extern void SystemWork P_((Pcells  ce));
extern void mutate P_((void));
extern void mut_site P_((HpInst s, I32s t));
extern void ReapCheck P_((void));
extern void reaper P_((I32s ex));
extern I32s SubEvent P_((Event * event1, Event * event2, Event * result));
extern void tsrand P_((I32s seed));
extern double tdrand P_((void));
extern I8s GetAVar P_((I8s data[85]));
extern I8s GetAMap P_((I8s data[85]));
extern void GetSoup P_((I32s argc, I8s *argv[]));
extern void StupGenLists P_((void));
extern void GetNewSoup P_((void));
extern void ReadACreature P_((I8s  *crit, Pcells  ce, HpInst  si));
extern void GetOldSoup P_((FILE * inf));
extern void WriteSoup P_((I32s close_disk));
extern void ToggleLog P_((I32s mode));
extern I16s glcmp P_((const void *gl1, const void *gl2));
extern I16s slcmp P_((const void *sl1, const void *sl2));
extern void InitCell P_((I32s  ar, I32s  ci, Pcells  ce));
extern void GenExExe P_((Pcells  ce, Ind adrt));
extern void GenExMov P_((Pcells  ce, I32s  to, I32s  from));
extern void GenExTemp P_((Ind adrt, Pcells  ce, I32s tsize));
extern void FEExit P_((I32s n));
extern void FEMemCheck P_((I8s  *msg));
extern void FEMemProf P_((I32s  SizSoup, I32s  SizCells, I32s  SizFreeMem,
    I32s  SizSl, I32s  SizSli, I32s  SizGl, I32s  SizGli, I32s  SizGen));
extern void FEMessage P_((I32s n, I8s ** pbuf));
extern void FEStats P_((void));
extern void FEClrmsg P_((I32s n));
extern void FECeol P_((void));
extern I16s FEGetc P_((void));
extern void FEStartup P_((void));
extern void FEPlan P_((I32s MaxPop, I32s MaxMem, Genotype * MaxGenPop,
		       Genotype * MaxGenMem));
extern void FEPrintf P_((I32s scr_x, I32s scr_y, I32s scr_a, ...));
/* turbo c insanity in line above */
extern void FEError P_((I32s err_no, I32s err_exit, I32s err_write, ...));

extern void query_size P_((I32s size_class));
extern void query_species P_((I32s num));
#if FRONTEND != STDIO
extern void query_spec_d P_((I32s size, I32s lbl));
extern void FEMenu P_((void));
#endif


#ifdef __TURBOC__
#if FRONTEND == STDIO
extern int T_sig_int   P_((void));
#endif
#if FRONTEND == BASIC
extern void DosToggleVideo  P_((I16s mode));
#endif
#endif

#ifdef unix
extern void T_sig_int  P_((I32s sig, I32s code, I32s *scp, I8s *addr));
extern void T_sig_read P_((I32s sig, I32s code, I32s * scp, I8s *addr));
extern void T_sig_write P_((I32s sig, I32s code, I32s * scp, I8s *addr));
extern void T_sig_info P_((I32s sig, I32s code, I32s * scp, I8s *addr));
#endif

#ifdef ALCOMM
extern void	_t_init_alcomm P_((void));
extern void	_t_life_bookeep P_((void));
extern void     _t_memory_stats P_(( unsigned char which, void *indata,
                    int inlen, void **outdata, int *outdatalen ));
extern void     _t_sim_runcontrol P_(( unsigned char which, void *data,
                    int datalen ));
extern void     _t_init_birthdeath P_(( ALtCLink *clink ));
extern void     _t_query_org P_(( I32s which, void * indata, int inlen, 
                    void **outdata, int *outdatalen ));
#endif

#ifdef MICRO
extern void Micro_Spy P_(( Pcells ce));
#endif

#if INST == 1

    extern void pnop P_((Pcells  ce));
    extern void por1 P_((Pcells  ce));
    extern void pshl P_((Pcells  ce));
    extern void pzero P_((Pcells  ce));
    extern void pif_cz P_((Pcells  ce));
    extern void psub_ab P_((Pcells  ce));
    extern void psub_ac P_((Pcells  ce));
    extern void pinc_a P_((Pcells  ce));
    extern void pinc_b P_((Pcells  ce));
    extern void pdec_c P_((Pcells  ce));
    extern void pinc_c P_((Pcells  ce));
    extern void ppushax P_((Pcells  ce));
    extern void ppushbx P_((Pcells  ce));
    extern void ppushcx P_((Pcells  ce));
    extern void ppushdx P_((Pcells  ce));
    extern void ppop_ax P_((Pcells  ce));
    extern void ppop_bx P_((Pcells  ce));
    extern void ppop_cx P_((Pcells  ce));
    extern void ppop_dx P_((Pcells  ce));
    extern void ptjmp P_((Pcells  ce));
    extern void ptjmpb P_((Pcells  ce));
    extern void ptcall P_((Pcells  ce));
    extern void pret P_((Pcells  ce));
    extern void pmov_dc P_((Pcells  ce));
    extern void pmov_ba P_((Pcells  ce));
    extern void pmoviab P_((Pcells  ce));
    extern void padr P_((Pcells  ce));
    extern void padrb P_((Pcells  ce));
    extern void padrf P_((Pcells  ce));
    extern void pmal P_((Pcells  ce));
    extern void pdivide P_((Pcells  ce));

#endif			   /* INST == 1 */

#endif
