/* instruct.c   6-5-92  instruction set for the tierra simulator */
/* Tierra Simulator V3.11: Copyright (c) 1991, 1992 Tom Ray & Virtual Life */

#ifndef lint
static char sccsid[] = "@(#)instruct.c    1.22     9/19/91";
#endif

#include "license.h"
#include "tierra.h"
#include "extern.h"

#ifdef ALCOMM
#include "tmonitor.h"
#include "trequest.h"
#endif



#ifdef MEM_CHK
#include <memcheck.h>
#endif

void nop(ce)
    Pcells  ce;
{
    ce->c.fl = 0;
}

void or1(ce)           /* flip low order bit of destination register */
    Pcells  ce;
{
    *(is.dreg) ^= (1 + flaw(ce));
    if (is.dmod)
    {   *(is.dreg) = mo(*(is.dreg), is.dmod);
        is.dmod = 0;
    }
    else if (is.dran && (*(is.dreg) > is.dran || *(is.dreg) < -is.dran))
    {   *(is.dreg) = is.dval;
        is.dran = 0;
        SetFlag(ce);
        return;
    }
    ce->c.fl = 0;
}

void shl(ce)
    Pcells  ce;
{
    *(is.dreg) <<= (Reg) (1 + flaw(ce));
    if (is.dmod)
    {   *(is.dreg) = mo(*(is.dreg), is.dmod);
        is.dmod = 0;
    }
    else if (is.dran && (*(is.dreg) > is.dran || *(is.dreg) < -is.dran))
    {   *(is.dreg) = is.dval;
        is.dran = 0;
        SetFlag(ce);
        return;
    }
    ce->c.fl = 0;
}

void if_cz(ce)           /* execute next instruction only if cx == 0 */
    Pcells  ce;
{
    if (is.sval + flaw(ce))
        is.iip = 2;
    ce->c.fl = 0;
}

void math(ce)
    Pcells  ce;
{
    *(is.dreg) = is.sval + is.sval2 + flaw(ce);
    if (is.dmod)
    {   *(is.dreg) = mo(*(is.dreg), is.dmod);
        is.dmod = 0;
    }
    else if (is.dran && (*(is.dreg) > is.dran || *(is.dreg) < -is.dran))
    {   *(is.dreg) = is.dval;
        is.dran = 0;
        SetFlag(ce);
        return;
    }
    ce->c.fl = 0;
}

void push(ce)
    Pcells  ce;
{
    ce->c.sp = ++ce->c.sp % STACK_SIZE;
    ce->c.st[ce->c.sp] = is.sval;
    ce->c.fl = 0;
}

void pop(ce)
    Pcells  ce;
{
    if (is.dran && (ce->c.st[ce->c.sp] > is.dran ||
        ce->c.st[ce->c.sp] < -is.dran))
    {   is.dran = 0;
        SetFlag(ce);
        return;
    }
    *(is.dreg) = ce->c.st[ce->c.sp];
    if (!ce->c.sp) ce->c.sp = STACK_SIZE - 1;    /* decrement stack pointer */
    else --ce->c.sp;
    if (is.dmod)
    {   *(is.dreg) = mo(*(is.dreg), is.dmod);
        is.dmod = 0;
    }
    ce->c.fl = 0;
}

void tcall(ce)           /* call template */
    Pcells  ce;
{
    push(ce);
    adr(ce);
}

void call(ce)           /* call address */
    Pcells  ce;
{
    push(ce);
    movdd(ce);
}

void mov(ce)
    Pcells  ce;
{
    switch (is.mode)
    {   case 0: movdd(ce); break; /*   direct destination,   direct source */
        case 1: movdi(ce); break; /*   direct destination, indirect source */
        case 2: movid(ce); break; /* indirect destination,   direct source */
        case 3: movii(ce); break; /* indirect destination, indirect source */
    }
}

void movdd(ce)
    Pcells  ce;
{
    *(is.dreg) = is.sval + flaw(ce);
    if (is.dmod)
    {   *(is.dreg) = mo(*(is.dreg), is.dmod);
        is.dmod = 0;
    }
    else if (is.dran && (*(is.dreg) > is.dran || *(is.dreg) < -is.dran))
    {   *(is.dreg) = is.dval;
        is.dran = 0;
        SetFlag(ce);
        return;
    }
    ce->c.fl = 0;
}

void movdi(ce)
    Pcells  ce;
{
    if ((IsInsideCell(ce, is.sval) || !is.sins->read) &&
        (0 <= is.sval && is.sval < SoupSize))
    {   *(is.dreg) = is.sins->inst + flaw(ce);
        ce->c.fl = 0;
    }
    else
    {   SetFlag(ce);
        return;
    }
    if (is.dmod)
    {   *(is.dreg) = mo(*(is.dreg), is.dmod);
        is.dmod = 0;
    }
    else if (is.dran && (*(is.dreg) > is.dran || *(is.dreg) < -is.dran))
    {   *(is.dreg) = is.dval;
        is.dran = 0;
        SetFlag(ce);
        return;
    }
}

void movid(ce)
    Pcells  ce;
{
    if ((IsInsideCell(ce, is.dval) || !is.dins->write) &&
        (0 <= is.dval && is.dval < SoupSize))
    {   is.dins->inst = is.sval + flaw(ce);
        ce->c.fl = 0;
    }
    else SetFlag(ce);
}

void movii(ce)
    Pcells  ce;
{
    if ((!is.dins->write || IsInsideCell(ce, is.dval)) &&
        (!is.sins->read || IsInsideCell(ce, is.sval)) &&
        (0 <= is.dval && is.dval < SoupSize) &&
        (0 <= is.sval && is.sval < SoupSize))
    {   is.dins->inst = is.sins->inst;
        if (RateMovMut && ++CountMovMut >= RateMovMut)
        {   mut_site(soup + ad(is.dval), is.dtra);
            CountMovMut = tlrand() % RateMovMut;
            TotMovMut++;
        }
        if (WatchMov) GenExMov(ce, is.dval, is.sval);
        if (is.dval >= ce->md.p && is.dval <= ce->md.p + ce->md.s)
            ce->d.mov_daught++;
        else
            MutBookeep(is.dval);
        ce->c.fl = 0;
    }
    else SetFlag(ce);
#ifdef ALCOMM
    if ( MIsDFEnabled( TrtMVEvent ) )
        TMoveD( ce->mm.p,is.sval,is.dval);
#endif /* ALCOMM */
}

/* void adr(ce)
 * is.dreg  = address of instruction after target template
 * is.dreg2 = template size
 * is.sval2 = size of template
 * is.dval  = start address for forward search
 * is.dval2 = start address for backward search
 * is.mode  = search direction: 0 out, 1 forward, 2 backward
 * is.mode2 = match style: 0 = complement, 1 = direct
 */

void adr(ce)
    Pcells  ce;
{
    Ind adrt;

    if (!is.sval2)
    {   SetFlag(ce);
        return;
    }                             /* source template missing */
    if (!is.mode)                 /* outward search */
    adrt = ctemplate(is.dval, is.dval2, is.sval2, 'o', ce);
    if (is.mode == 1)             /* forward search */
        adrt = ctemplate(is.dval, is.dval2, is.sval2, 'f', ce);
    if (is.mode == 2)             /* backward search */
        adrt = ctemplate(is.dval, is.dval2, is.sval2, 'b', ce);
    if (adrt < 0)                 /* target template not found */
    {   is.iip = is.sval2 + 1;    /* skip ip over source template */
        SetFlag(ce);
        return;
    }
    *(is.dreg) = adrt;
    *(is.dreg2) = is.sval2;
    if (is.dmod)
    {   *(is.dreg) = mo(*(is.dreg), is.dmod);
        is.dmod = 0;
    }
    else if (is.dran && (*(is.dreg) > is.dran || *(is.dreg) < -is.dran))
    {   *(is.dreg) = is.dval;
        is.dran = 0;
        SetFlag(ce);
        return;
    }
    if (is.dmod2)
    {   *(is.dreg2) = mo(*(is.dreg2), is.dmod2);
        is.dmod2 = 0;
    }
    else if (is.dran2 && (*(is.dreg2) > is.dran2 || *(is.dreg2) < -is.dran2))
    {   *(is.dreg2) = is.dval2;
        is.dran2 = 0;
        SetFlag(ce);
        return;
    }
    ce->c.fl = 0;
    return;
}

void malchm(ce)
    Pcells  ce;
{   /* is.sval = requested size of block, is.sval2 = flawed size of block */
    /* is.dreg = location of block */
    if ( !(is.sval2 = mal(ce,is.dreg,is.sval)))
        SetFlag(ce);
    is.sval = *(is.dreg);
    /* is.sval  = location of chmoded block */
    /* is.sval2 = size of chmoded block */
    /* is.dtra  = track being chmoded */
    /* is.mode  = chmod mode, unix notation, e.g. 7 = full protection */
    if (chmode(ce,is.sval,is.sval2,is.mode)) /* could be MemModeProt */
        SetFlag(ce);
    else ce->c.fl = 0;
}

void divide(ce)
    Pcells  ce;
{
    Pcells nc;           /* pointer to the new cell */
    I32s  i, j, found = 0;
    CellInd  ni;

    if (ce->md.s < MinCellSize || ce->d.mov_daught < (I32s) (ce->md.s *
        MovPropThrDiv) || !ce->d.mov_daught)
    {   SetFlag(ce);
        return;
    }
    if (DivSameSiz)
    {   if (ce->mm.s != ce->md.s)
        {   SetFlag(ce);
            return;
        }
        if (DivSameGen &&
            !IsSameGen(ce->mm.s, soup + ce->md.p, soup + ce->mm.p))
        {   SetFlag(ce);
            return;
        }
    }
    switch (is.mode) {
    case 0:           /* create cpu */
    {   if ((ce->d.ne.a == ce->q.this.a) && (ce->d.ne.i == ce->q.this.i))
            /* if there is no cpu (first call to div 0) */
        {   if (++NumCells > CellsSize - 2)
                CheckCells();
            for (i = 0; i < NumCelAr; i++)  /* find unoccupied cell struct */
            {   for (j = 0; j < CelArSiz; j++)
                {
#ifdef ERROR
                    if (i * j >= CellsSize)
                        FEError(-500,EXIT,WRITE,
                            "Tierra divide() error A0, exiting");
#endif
                    if(!cells[i][j].ld)
                    {   found = 1;
                        nc = &cells[i][j];
                        break;
                    }
                }
                if (found)
                    break;
            }
            InitCell(i, j, nc);
            nc->ld = 1;
            nc->mm = ce->md;
            nc->c.ip = nc->mm.p;
            nc->d.dm = 1;
            ce->d.ne = nc->q.this;
        }
        else      /* if there is a cpu (second call to div 0) */
        {   nc = &cells[ce->d.ne.a][ce->d.ne.i];
            if (nc->d.is)   /* call to div 0 after call to div 1 */
            {   RmvFrmSlicer(nc);
                nc->d.is = 0;
            }
            else     /* two sequential calls to div 0, error */
            {   SetFlag(ce);
                 return;
            }
        }
        break;
    }
    case 1:           /* start cpu */
    {   if ((ce->d.ne.a == ce->q.this.a) && (ce->d.ne.i == ce->q.this.i))
            /* if there is no cpu, div 1 before div 0 */
        {   if (++NumCells > CellsSize - 2)
                CheckCells();
            for (i = 0; i < NumCelAr; i++)  /* find unoccupied cell struct */
            {   for (j = 0; j < CelArSiz; j++)
                {
#ifdef ERROR
                    if (i * j >= CellsSize)
                        FEError(-501,EXIT,WRITE,
                            "Tierra divide() error B0, exiting");
#endif
                    if(!cells[i][j].ld)
                    {   found = 1;
                        nc = &cells[i][j];
                        break;
                    }
                }
                if (found)
                    break;
            }
            InitCell(i, j, nc);
            nc->ld = 1;
            nc->mm = ce->md;
            nc->c.ip = nc->mm.p;
            nc->d.dm = 1;
            ce->d.ne = nc->q.this;
        }
        else     /* if there is already a cpu, make pointers to it */
            nc = &cells[ce->d.ne.a][ce->d.ne.i];
        if (nc->d.is) /* 2nd call to div 1, cpu is already started */
        {   RmvFrmSlicer(nc);
            nc->d.is = 0;
        }
        else    /* not 2nd call to div 1, cpu is not already started */
        {   EntBotSlicer(nc);
            nc->d.is = 1;
        }
        break;
    }
    case 2: /* split cells */
    {   if ((ce->d.ne.a == ce->q.this.a) && (ce->d.ne.i == ce->q.this.i))
            /* if there is no cpu, div 2 before div 0 */
        {   if (++NumCells > CellsSize - 2)
                CheckCells();
            for (i = 0; i < NumCelAr; i++)  /* find unoccupied cell struct */
            {   for (j = 0; j < CelArSiz; j++)
                {
#ifdef ERROR
                    if (i * j >= CellsSize)
                        FEError(-502,EXIT,WRITE, 
                            "Tierra divide() error C0, exiting");
#endif
                    if(!cells[i][j].ld)
                    {   found = 1;
                        nc = &cells[i][j];
                        break;
                    }
                }
                if (found)
                    break;
            }
            InitCell(i, j, nc);
            nc->ld = 1;
            nc->mm = ce->md;
            nc->c.ip = nc->mm.p;
        }
        else
            nc = &cells[ce->d.ne.a][ce->d.ne.i];
        if (!nc->d.is)   /* no slicer, div CX before div BX */
        {   EntBotSlicer(nc);
            nc->d.is = 1;
        }
        ce->md.s = ce->md.p = 0;
        ce->d.ne = ce->q.this; /* clean up if AX or BX before CX */
        nc->d.dm = 0;
        EntBotReaper(nc);
        DownReperIf(ce);
        DivideBookeep(ce, nc);
    }
    } /* switch */
    ce->c.fl = 0;
}

void CheckCells() /* check and adjust memory allocation if necessary */
{   I32s j, oCellsSize = CellsSize;
    Pcells Fp  tcells;

#ifdef ERROR
    sprintf(mes[0], "in_div CheckCells: recalloc, NumCells = %ld", NumCells);
    sprintf(Buff, "    old CellsSize = %ld  ", CellsSize);
#endif
    NumCelAr++;
    tcells = (Pcells Fp) trecalloc((I8s Fp) cells,
        (I32u) sizeof(Pcells) * (I32u) NumCelAr,
        (I32u) sizeof(Pcells) * (I32u) (NumCelAr - 1));
    if (tcells)
        cells = tcells;
    else if (cells)
    {   tfree(cells);
        cells = NULL;
        FEError(-503,EXIT,WRITE, 
        "Tierra CheckCells() cells trecalloc error, out of memory, exiting");
    }
    CellsSize = NumCelAr * CelArSiz;
    cells[NumCelAr - 1] = (Pcells) tcalloc(CelArSiz, sizeof(Cell));
    if (cells[NumCelAr - 1] == NULL)
    {   FEError(-504,EXIT,WRITE, 
         "Tierra CheckCells() cells[] tcalloc error, out of memory, exiting");
    }
#ifdef ERROR
    sprintf(mes[1], "%s new CellsSize = %ld", Buff, CellsSize);
    FEMessage(2,mes);
#ifdef __TURBOC__
    sprintf(mes[0], "coreleft = %lu  divide (cells)", coreleft());
    FEMessage(1,mes);
#endif
#endif
    for (j = 0; j < CelArSiz; j++)
        InitCell(NumCelAr - 1, j, &cells[NumCelAr - 1][j]);
}

I32s flaw(ce)
    Pcells  ce;
{
    CountFlaw++;
    if (RateFlaw && CountFlaw >= RateFlaw)
    {   CountFlaw = tlrand() % RateFlaw;
        TotFlaw++;
        ce->d.flaw++;
        if (tcrand() % 2) return 1;
        return -1;
    }
    return 0;
}

Ind ctemplate(f, b, tz, dir, ce) /* search in specified direction for */
 /* nop template return address, returns address of instruction following */
 /* target template, i.e., target + tz */
 /* NOTE: ce->c.ip must point to the instruction (agent) being executed */
    Ind f;   /* starting address for forward search */
    Ind b;   /* starting address for backward search */
    I32s tz; /* template size */
    I32s dir; /* direction of search, f = forward, b = backward, o = out */
    Pcells  ce; /* which cell */
{
    Ind o, l = 1, adrt;
    I32s i = 0, match;
    I8s df, db;
    Pgl tgl;

    if ((tz < MinTemplSize) || (tz > SoupSize))
    {   adrt = -1;
        goto finish;
    }
    if ((I8s) dir == 'o') df = db = 1;       /* both directions */
    if ((I8s) dir == 'f') /* forward only */
    {   df = 1;
        db = 0;
    }
    if ((I8s) dir == 'b') /* backwards only */
    {   df = 0;
        db = 1;
    }
    o = ad(ce->c.ip + 1);
    while (1) {
    while (1) /* this skips sections of codes that are not templates (NOPs) */
    {
#if PLOIDY == 1
        if (df && (soup[f].inst == Nop0    /* forward */
               ||  soup[f].inst == Nop1))
#else /* PLOIDY > 1 */
        if (df && (soup[f][ce->c.tr].inst == Nop0    /* forward */
               ||  soup[f][ce->c.tr].inst == Nop1))
#endif /* PLOIDY > 1 */
            break;
        else
        {   f++;
            f = ad(f);
        }
#if PLOIDY == 1
        if (db && (soup[b].inst == Nop0    /* backward */
               ||  soup[b].inst == Nop1))
#else /* PLOIDY > 1 */
        if (db && (soup[b][ce->c.tr].inst == Nop0    /* backward */
               ||  soup[b][ce->c.tr].inst == Nop1))
#endif /* PLOIDY > 1 */
            break;
        else
        {   b--;
            b = ad(b);
        }
    }
    match = 1;   /* forward */
#if PLOIDY == 1
        if (df && (soup[f].inst == Nop0    /* if NOPs */
               ||  soup[f].inst == Nop1))
#else /* PLOIDY > 1 */
        if (df && (soup[f][ce->c.tr].inst == Nop0    /* if NOPs */
               ||  soup[f][ce->c.tr].inst == Nop1))
#endif /* PLOIDY > 1 */
    {   for (i = 0; i < tz; i++)   /* over the full template size */
        {   
#if PLOIDY == 1
            if (soup[ad(o + i)].inst +
                soup[ad(f + i)].inst - NopS)
#else /* PLOIDY > 1 */
            if (soup[ad(o + i)][ce->c.tr].inst +
                soup[ad(f + i)][ce->c.tr].inst - NopS)
#endif /* PLOIDY > 1 */
            {   match = 0;
                break;
            }
        }
        if (match)
        {   f += flaw(ce);
            adrt = ad(f + tz);
            goto finish;
        }
    }
    match = 1;       /* backward */
#if PLOIDY == 1
        if (db && (soup[b].inst == Nop0    /* if NOPs */
               ||  soup[b].inst == Nop1))
#else /* PLOIDY > 1 */
        if (db && (soup[b][ce->c.tr].inst == Nop0    /* if NOPs */
               ||  soup[b][ce->c.tr].inst == Nop1))
#endif /* PLOIDY > 1 */
    {   for (i = 0; i < tz; i++)  /* over the full template size */
        {
#if PLOIDY == 1
            if (soup[ad(o + i)].inst +
                soup[ad(b + i)].inst - NopS)
#else /* PLOIDY > 1 */
            if (soup[ad(o + i)][ce->c.tr].inst +
                soup[ad(b + i)][ce->c.tr].inst - NopS)
#endif /* PLOIDY > 1 */
            {   match = 0;
                break;
            }
        }
        if (match)
        {   b += flaw(ce);
            adrt = ad(b + tz);
            goto finish;
        }
    }           /* increment search pointers, backward and forward */
    if (db)
    {   b--;
        b = ad(b);
    }
    if (df)
    {   f++;
        f = ad(f);
    }
    l++;
    if (l > Search_limit)   /* if we exceed the search limit abort */
    {   adrt = -1;
        goto finish;
    }
    }  /* outermost while(1) */
finish:
    if (1 && WatchTem)
    tgl = sl[ce->d.gen.size]->g[ce->d.gi];
    if (1 && WatchTem && adrt >= 0 && !ce->d.flaw && !ce->d.mut &&
        ce->mm.p <= ce->c.ip && ce->c.ip < (ce->mm.p + ce->mm.s) &&
        IsBit(tgl->bits, 0))
    GenExTemp(ad(adrt - tz), ce, tz);
    return adrt;  /* address of instruction following target template */
}

#ifdef FUTURE

Ind template(f, b, tz, dir, mode, ce) /* search in specified direction for */
 /* nop template return address, returns address of instruction following */
 /* target template, i.e., target + tz */
 /* NOTE: ce->c.ip must point to the instruction (agent) being executed */
    Ind f;    /* starting address for forward search */
    Ind b;    /* starting address for backward search */
    I32s tz;  /* template size */
    I32s dir;  /* direction of search, f = forward, b = backward, o = out */
    I8s mode; /* match mode: 0 = complement, 1 = direct */
    Pcells  ce; /* which cell */
{
    Ind o, l = 1, adrt;
    I32s i = 0, match;
    I8s df, db;
    Pgl tgl;

    if ((tz < MinTemplSize) || (tz > SoupSize))
    {   adrt = -1;
        goto finish;
    }
    if ((I8s) dir == 'o') df = db = 1;       /* both directions */
    if ((I8s) dir == 'f') /* forward only */
    {   df = 1;
        db = 0;
    }
    if ((I8s) dir == 'b') /* backwards only */
    {   df = 0;
        db = 1;
    }
    o = ad(ce->c.ip + 1);
    while (1) {
    while (1) /* this skips sections of codes that are not templates (NOPs) */
    {   
        if (df && (soup[f][ce->c.tr].inst == Nop0 /* forward */
               ||  soup[f][ce->c.tr].inst == Nop1))
        break;
        else
        {   f++;
            f = ad(f);
        }
        if (db && (soup[b][ce->c.tr].inst == Nop0 /* backward */
               ||  soup[b][ce->c.tr].inst == Nop1))
        break;
        else
        {   b--;
            b = ad(b);
        }
    }
    match = 1;       /* forward */
    if (df && (soup[f][ce->c.tr].inst == Nop0
           ||  soup[f][ce->c.tr].inst == Nop1))  /* if NOPs */
    {   if (!mode)  /* compliment match mode */
        {   for (i = 0; i < tz; i++) /* over the full template size */
            {   if (!(soup[ad(o + i)][ce->c.tr].inst   /* if not compl */
                    - soup[ad(f + i)][ce->c.tr].inst ))
                {   match = 0;
                    break;
                }
            }
        }
        else  /* direct match mode */
        {   for (i = 0; i < tz; i++)  /* over the full template size */
            {   if (soup[ad(o + i)][ce->c.tr].inst         /* if compl */
                    - soup[ad(f + i)][ce->c.tr].inst )
                {   match = 0;
                    break;
                }
            }
        }
        if (match)
        {   f += flaw(ce);
            adrt = ad(f + tz);
            goto finish;
        }
    }
    match = 1;  /* backward */
    if (db && (soup[b][ce->c.tr].inst == Nop0
           ||  soup[b][ce->c.tr].inst == Nop1))  /* if NOPs */
    {   if (!mode)  /* compliment match mode */
        {   for (i = 0; i < tz; i++)  /* over the full template size */
            {   if (!(soup[ad(o + i)][ce->c.tr].inst
                    - soup[ad(b + i)][ce->c.tr].inst ))
                {   match = 0;
                    break;
                }
            }
        }
        else  /* direct match mode */
        {   for (i = 0; i < tz; i++) /* over the full template size */
            {   if (soup[ad(o + i)][ce->c.tr].inst
                    - soup[ad(b + i)][ce->c.tr].inst)
                {   match = 0;
                    break;
                }
            }
        }
        if (match)
        {   b += flaw(ce);
            adrt = ad(b + tz);
            goto finish;
        }
    }   /* increment search pointers, backward and forward */
    if (db)
    {   b--;
        b = ad(b);
    }
    if (df)
    {   f++;
        f = ad(f);
    }
    l++;
    if (l > Search_limit)  /* if we exceed the search limit abort */
    {   adrt = -1;
        goto finish;
    }
    }
finish:
    if (1 && WatchTem)
    tgl = sl[ce->d.gen.size]->g[ce->d.gi];
    if (1 && WatchTem && adrt >= 0 && !ce->d.flaw && !ce->d.mut &&
        ce->mm.p <= ce->c.ip && ce->c.ip < (ce->mm.p + ce->mm.s) &&
        IsBit(tgl->bits, 0))
    GenExTemp(ad(adrt - tz), ce, tz);
    return adrt; /* address of instruction following target template */
}

Ind btemplate(f, b, tz, dir, mode, ce) /* search in specified direction for */
 /* binary template return address, returns address of instruction */
 /* following target template, i.e., target + tz */
 /* NOTE: ce->c.ip must point to the instruction (agent) being executed */
    Ind f;    /* starting address for forward search */
    Ind b;    /* starting address for backward search */
    I32s tz;  /* template size */
    I8s dir;  /* direction of search, f = forward, b = backward, o = out */
    I8s mode; /* match mode: 0 = complement, 1 = direct */
    Pcells  ce; /* which cell */
{   Ind o, l = 1, adrt;
    I32s i = 0, match;
    I8s df, db;
    Pgl tgl;

    if ((tz < MinTemplSize) || (tz > SoupSize))
    {   adrt = -1;
        goto finish;
    }
    if (dir == 'o') df = db = 1; /* both directions */
    if (dir == 'f') /* forward only */
    {   df = 1;
        db = 0;
    }
    if (dir == 'b') /* backwards only */
    {   df = 0;
        db = 1;
    }
    o = ad(ce->c.ip + 1);
    while (1) {
    match = 1;
    if (df)  /* if direction forwards */
    {   if (!mode) /* compliment match mode */
        {   for (i = 0; i < tz; i++) /* for full template size */
            {   if ((soup[ad(o + i)][ce->c.tr].inst
                ^ soup[ad(f + i)][ce->c.tr].inst) == 31)
                {   match = 0;
                    break;
                }
            }
        }
        else  /* direct match mode */
        {   for (i = 0; i < tz; i++) /* for full template size */
            {   if (soup[ad(o + i)][ce->c.tr].inst
                    == soup[ad(f + i)][ce->c.tr].inst)
                {   match = 0;
                    break;
                }
            }
        }
        if (match)
        {   f += flaw(ce);
            adrt = ad(f + tz);
            goto finish;
        }
    }
    if (db) /* if direction backwards */
    {   match = 1;
        if (!mode) /* compliment match mode */
        {   for (i = 0; i < tz; i++) /* for full template size */
            {   if ((soup[ad(o + i)][ce->c.tr].inst
                ^ soup[ad(b + i)][ce->c.tr].inst) == 31)
                {   match = 0;
                    break;
                }
            }
        }
        else  /* direct match mode */
        {   for (i = 0; i < tz; i++) /* for full template size */
            {   if (soup[ad(o + i)][ce->c.tr].inst
                    == soup[ad(b + i)][ce->c.tr].inst)
                {   match = 0;
                    break;
                }
            }
        }
        if (match)
        {   b += flaw(ce);
            adrt = ad(b + tz);
            goto finish;
        }
    }   /* increment search pointers, backward and forward */
    if (db)
    {   b--;
        b = ad(b);
    }
    if (df)
    {   f++;
        f = ad(f);
    }
    l++;
    if (l > Search_limit)
    {   adrt = -1;
        goto finish;
    }
    }
finish:
    if (1 && WatchTem)
    tgl = sl[ce->d.gen.size]->g[ce->d.gi];
    if (1 && WatchTem && adrt >= 0 && !ce->d.flaw && !ce->d.mut &&
        ce->mm.p <= ce->c.ip && ce->c.ip < (ce->mm.p + ce->mm.s) &&
        IsBit(tgl->bits, 0))
    GenExTemp(ad(adrt - tz), ce, tz);
    return adrt; /* address of instruction following target template */
}

#endif /* FUTURE */
